/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithUKM;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECVKOAgreement {
    private final Digest digest;
    private ECPrivateKeyParameters key;
    private BigInteger ukm;

    public ECVKOAgreement(Digest digest) {
        this.digest = digest;
    }

    private static BigInteger toInteger(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        for (int k = 0; k != n; ++k) {
            byArray2[k] = byArray[byArray.length - k - 1];
        }
        return new BigInteger(1, byArray2);
    }

    private byte[] fromPoint(ECPoint object) {
        int n;
        Object object2 = ((ECPoint)object).getAffineXCoord().toBigInteger();
        object = ((ECPoint)object).getAffineYCoord().toBigInteger();
        int n2 = ((BigInteger)object2).toByteArray().length > 33 ? 64 : 32;
        int n3 = n2;
        int n4 = n3 * 2;
        byte[] byArray = new byte[n4];
        object2 = BigIntegers.asUnsignedByteArray(n3, (BigInteger)object2);
        object = BigIntegers.asUnsignedByteArray(n3, (BigInteger)object);
        for (n = 0; n != n2; ++n) {
            byArray[n] = (byte)object2[n2 - n - 1];
        }
        for (int k = 0; k != n2; ++k) {
            n = n2 + k;
            byArray[n] = (byte)object[n2 - k - 1];
        }
        ECVKOAgreement eCVKOAgreement = this;
        eCVKOAgreement.digest.update(byArray, 0, n4);
        byte[] byArray2 = new byte[eCVKOAgreement.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        return byArray2;
    }

    public void init(CipherParameters cipherParameters) {
        ECVKOAgreement eCVKOAgreement = parametersWithUKM;
        ParametersWithUKM parametersWithUKM = (ParametersWithUKM)cipherParameters;
        eCVKOAgreement.key = (ECPrivateKeyParameters)parametersWithUKM.getParameters();
        eCVKOAgreement.ukm = ECVKOAgreement.toInteger(parametersWithUKM.getUKM());
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters object) {
        object = (ECPublicKeyParameters)object;
        Object object2 = this.key.getParameters();
        if (((ECDomainParameters)object2).equals(((ECKeyParameters)object).getParameters())) {
            ECDomainParameters eCDomainParameters = object2;
            object2 = eCDomainParameters.getH().multiply(this.ukm).multiply(this.key.getD()).mod(((ECDomainParameters)object2).getN());
            object = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), ((ECPublicKeyParameters)object).getQ());
            if (!((ECPoint)object).isInfinity()) {
                if (!((ECPoint)(object = ((ECPoint)object).multiply((BigInteger)object2).normalize())).isInfinity()) {
                    return this.fromPoint((ECPoint)object);
                }
                throw new IllegalStateException("Infinity is not a valid agreement value for ECVKO");
            }
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        throw new IllegalStateException("ECVKO public key has wrong domain parameters");
    }
}

