/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class CamelliaLightEngine
implements BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int MASK8 = 255;
    private static final int[] SIGMA = new int[]{-1600231809, 1003262091, -1233459112, 1286239154, -957401297, -380665154, 1426019237, -237801700, 283453434, -563598051, -1336506174, -1276722691};
    private static final byte[] SBOX1 = new byte[]{112, -126, 44, -20, -77, 39, -64, -27, -28, -123, 87, 53, -22, 12, -82, 65, 35, -17, 107, -109, 69, 25, -91, 33, -19, 14, 79, 78, 29, 101, -110, -67, -122, -72, -81, -113, 124, -21, 31, -50, 62, 48, -36, 95, 94, -59, 11, 26, -90, -31, 57, -54, -43, 71, 93, 61, -39, 1, 90, -42, 81, 86, 108, 77, -117, 13, -102, 102, -5, -52, -80, 45, 116, 18, 43, 32, -16, -79, -124, -103, -33, 76, -53, -62, 52, 126, 118, 5, 109, -73, -87, 49, -47, 23, 4, -41, 20, 88, 58, 97, -34, 27, 17, 28, 50, 15, -100, 22, 83, 24, -14, 34, -2, 68, -49, -78, -61, -75, 122, -111, 36, 8, -24, -88, 96, -4, 105, 80, -86, -48, -96, 125, -95, -119, 98, -105, 84, 91, 30, -107, -32, -1, 100, -46, 16, -60, 0, 72, -93, -9, 117, -37, -118, 3, -26, -38, 9, 63, -35, -108, -121, 92, -125, 2, -51, 74, -112, 51, 115, 103, -10, -13, -99, 127, -65, -30, 82, -101, -40, 38, -56, 55, -58, 59, -127, -106, 111, 75, 19, -66, 99, 46, -23, 121, -89, -116, -97, 110, -68, -114, 41, -11, -7, -74, 47, -3, -76, 89, 120, -104, 6, 106, -25, 70, 113, -70, -44, 37, -85, 66, -120, -94, -115, -6, 114, 7, -71, 85, -8, -18, -84, 10, 54, 73, 42, 104, 60, 56, -15, -92, 64, 40, -45, 123, -69, -55, 67, -63, 21, -29, -83, -12, 119, -57, -128, -98};
    private boolean initialized;
    private boolean _keyis128;
    private int[] subkey = new int[96];
    private int[] kw = new int[8];
    private int[] ke = new int[12];
    private int[] state = new int[4];

    private static int rightRotate(int n, int n2) {
        return (n >>> n2) + (n << 32 - n2);
    }

    private static int leftRotate(int n, int n2) {
        return (n << n2) + (n >>> 32 - n2);
    }

    private static void roldq(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n3 + 0;
        int n5 = n2 + 0;
        int n6 = n2 + 1;
        int n7 = 32 - n;
        nArray2[n4] = nArray[n5] << n | nArray[n6] >>> n7;
        int n8 = n3 + 1;
        int n9 = n2 + 2;
        nArray2[n8] = nArray[n6] << n | nArray[n9] >>> n7;
        int n10 = n3 + 2;
        nArray2[n10] = nArray[n9] << n | nArray[n2 += 3] >>> n7;
        nArray2[n3 += 3] = nArray[n2] << n | nArray[n5] >>> n7;
        nArray[n5] = nArray2[n4];
        nArray[n6] = nArray2[n8];
        nArray[n9] = nArray2[n10];
        nArray[n2] = nArray2[n3];
    }

    private static void decroldq(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n3 + 2;
        int n5 = n2 + 0;
        int n6 = n2 + 1;
        int n7 = 32 - n;
        nArray2[n4] = nArray[n5] << n | nArray[n6] >>> n7;
        int n8 = n3 + 3;
        int n9 = n2 + 2;
        nArray2[n8] = nArray[n6] << n | nArray[n9] >>> n7;
        int n10 = n3 + 0;
        nArray2[n10] = nArray[n9] << n | nArray[n2 += 3] >>> n7;
        nArray2[++n3] = nArray[n2] << n | nArray[n5] >>> n7;
        nArray[n5] = nArray2[n4];
        nArray[n6] = nArray2[n8];
        nArray[n9] = nArray2[n10];
        nArray[n2] = nArray2[n3];
    }

    private static void roldqo32(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n3 + 0;
        int n5 = n2 + 1;
        int n6 = n - 32;
        int n7 = n2 + 2;
        n = 64 - n;
        nArray2[n4] = nArray[n5] << n6 | nArray[n7] >>> n;
        int n8 = n3 + 1;
        int n9 = n2 + 3;
        nArray2[n8] = nArray[n7] << n6 | nArray[n9] >>> n;
        int n10 = n3 + 2;
        nArray2[n10] = nArray[n9] << n6 | nArray[n2 += 0] >>> n;
        nArray2[n3 += 3] = nArray[n2] << n6 | nArray[n5] >>> n;
        nArray[n2] = nArray2[n4];
        nArray[n5] = nArray2[n8];
        nArray[n7] = nArray2[n10];
        nArray[n9] = nArray2[n3];
    }

    private static void decroldqo32(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n3 + 2;
        int n5 = n2 + 1;
        int n6 = n - 32;
        int n7 = n2 + 2;
        n = 64 - n;
        nArray2[n4] = nArray[n5] << n6 | nArray[n7] >>> n;
        int n8 = n3 + 3;
        int n9 = n2 + 3;
        nArray2[n8] = nArray[n7] << n6 | nArray[n9] >>> n;
        int n10 = n3 + 0;
        nArray2[n10] = nArray[n9] << n6 | nArray[n2 += 0] >>> n;
        nArray2[++n3] = nArray[n2] << n6 | nArray[n5] >>> n;
        nArray[n2] = nArray2[n4];
        nArray[n5] = nArray2[n8];
        nArray[n7] = nArray2[n10];
        nArray[n9] = nArray2[n3];
    }

    private int bytes2int(byte[] byArray, int n) {
        int n2 = 0;
        for (int k = 0; k < 4; ++k) {
            n2 = (n2 << 8) + (byArray[k + n] & 0xFF);
        }
        return n2;
    }

    private void int2bytes(int n, byte[] byArray, int n2) {
        for (int k = 0; k < 4; ++k) {
            int n3 = n;
            int n4 = n;
            n = 3 - k + n2;
            byArray[n] = (byte)n4;
            n = n3 >>> 8;
        }
    }

    private byte lRot8(byte by, int n) {
        return (byte)(by << n | (by & 0xFF) >>> 8 - n);
    }

    private int sbox2(int n) {
        return this.lRot8(SBOX1[n], 1) & 0xFF;
    }

    private int sbox3(int n) {
        return this.lRot8(SBOX1[n], 7) & 0xFF;
    }

    private int sbox4(int n) {
        return SBOX1[this.lRot8((byte)n, 1) & 0xFF] & 0xFF;
    }

    private void camelliaF2(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = nArray;
        int[] nArray4 = nArray;
        int n2 = nArray[0] ^ nArray2[n + 0];
        byte[] byArray = SBOX1;
        int n3 = this.sbox4(n2 & 0xFF) | this.sbox3(n2 >>> 8 & 0xFF) << 8 | this.sbox2(n2 >>> 16 & 0xFF) << 16 | (SBOX1[n2 >>> 24 & 0xFF] & 0xFF) << 24;
        n2 = nArray[1] ^ nArray2[n + 1];
        n2 = CamelliaLightEngine.leftRotate(byArray[n2 & 0xFF] & 0xFF | this.sbox4(n2 >>> 8 & 0xFF) << 8 | this.sbox3(n2 >>> 16 & 0xFF) << 16 | this.sbox2(n2 >>> 24 & 0xFF) << 24, 8);
        int n4 = n3 ^ n2;
        n2 = CamelliaLightEngine.leftRotate(n2, 8) ^ n4;
        int n5 = CamelliaLightEngine.rightRotate(n4, 8) ^ n2;
        nArray4[2] = nArray4[2] ^ (CamelliaLightEngine.leftRotate(n2, 16) ^ n5);
        nArray4[3] = nArray4[3] ^ CamelliaLightEngine.leftRotate(n5, 8);
        n2 = nArray[2] ^ nArray2[n + 2];
        int n6 = nArray[3] ^ nArray2[n + 3];
        int n7 = CamelliaLightEngine.leftRotate(byArray[n6 & 0xFF] & 0xFF | this.sbox4(n6 >>> 8 & 0xFF) << 8 | this.sbox3(n6 >>> 16 & 0xFF) << 16 | this.sbox2(n6 >>> 24 & 0xFF) << 24, 8);
        int n8 = (this.sbox4(n2 & 0xFF) | this.sbox3(n2 >>> 8 & 0xFF) << 8 | this.sbox2(n2 >>> 16 & 0xFF) << 16 | (byArray[n2 >>> 24 & 0xFF] & 0xFF) << 24) ^ n7;
        n7 = CamelliaLightEngine.leftRotate(n7, 8) ^ n8;
        n6 = CamelliaLightEngine.rightRotate(n8, 8) ^ n7;
        nArray3[0] = nArray[0] ^ (CamelliaLightEngine.leftRotate(n7, 16) ^ n6);
        nArray3[1] = nArray[1] ^ CamelliaLightEngine.leftRotate(n6, 8);
    }

    private void camelliaFLs(int[] nArray, int[] nArray2, int n) {
        int n2;
        int[] nArray3 = nArray;
        nArray3[1] = n2 = nArray3[1] ^ CamelliaLightEngine.leftRotate(nArray[0] & nArray2[n + 0], 1);
        nArray3[0] = nArray3[0] ^ (nArray2[n + 1] | n2);
        n2 = nArray[2];
        int n3 = nArray2[n + 3];
        int n4 = nArray[3];
        nArray[2] = n2 ^= n3 | n4;
        nArray[3] = n4 ^ CamelliaLightEngine.leftRotate(nArray2[n + 2] & n2, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setKey(boolean bl, byte[] byArray) {
        Object object;
        int n;
        int[] nArray = new int[8];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        int n2 = byArray.length;
        if (n2 != 16) {
            if (n2 != 24) {
                if (n2 != 32) throw new IllegalArgumentException("key sizes are only 16/24/32 bytes.");
                nArray[0] = ((CamelliaLightEngine)object).bytes2int(byArray, 0);
                nArray[1] = ((CamelliaLightEngine)object).bytes2int(byArray, 4);
                nArray[2] = ((CamelliaLightEngine)object).bytes2int(byArray, 8);
                nArray[3] = ((CamelliaLightEngine)object).bytes2int(byArray, 12);
                nArray[4] = ((CamelliaLightEngine)object).bytes2int(byArray, 16);
                nArray[5] = ((CamelliaLightEngine)object).bytes2int(byArray, 20);
                nArray[6] = ((CamelliaLightEngine)object).bytes2int(byArray, 24);
                nArray[7] = ((CamelliaLightEngine)object).bytes2int(byArray, 28);
                ((CamelliaLightEngine)object)._keyis128 = false;
            } else {
                nArray[0] = ((CamelliaLightEngine)object).bytes2int(byArray, 0);
                nArray[1] = ((CamelliaLightEngine)object).bytes2int(byArray, 4);
                nArray[2] = ((CamelliaLightEngine)object).bytes2int(byArray, 8);
                nArray[3] = ((CamelliaLightEngine)object).bytes2int(byArray, 12);
                nArray[4] = ((CamelliaLightEngine)object).bytes2int(byArray, 16);
                int n3 = ((CamelliaLightEngine)object).bytes2int(byArray, 20);
                int[] nArray5 = nArray;
                nArray5[5] = n3;
                nArray[6] = ~nArray5[4];
                nArray[7] = ~n3;
                ((CamelliaLightEngine)object)._keyis128 = false;
            }
        } else {
            int[] nArray6 = nArray;
            ((CamelliaLightEngine)object)._keyis128 = true;
            nArray[0] = ((CamelliaLightEngine)object).bytes2int(byArray, 0);
            nArray[1] = ((CamelliaLightEngine)object).bytes2int(byArray, 4);
            nArray[2] = ((CamelliaLightEngine)object).bytes2int(byArray, 8);
            nArray6[3] = ((CamelliaLightEngine)object).bytes2int(byArray, 12);
            nArray6[7] = 0;
            nArray6[6] = 0;
            nArray6[5] = 0;
            nArray[4] = 0;
        }
        for (n = 0; n < 4; ++n) {
            nArray2[n] = nArray[n] ^ nArray[n + 4];
        }
        ((CamelliaLightEngine)object).camelliaF2(nArray2, SIGMA, 0);
        for (n = 0; n < 4; ++n) {
            nArray2[n] = nArray2[n] ^ nArray[n];
        }
        CamelliaLightEngine camelliaLightEngine = object;
        camelliaLightEngine.camelliaF2(nArray2, SIGMA, 4);
        if (camelliaLightEngine._keyis128) {
            if (bl) {
                CamelliaLightEngine camelliaLightEngine2 = object;
                object = camelliaLightEngine2.kw;
                object[0] = nArray[0];
                object[1] = nArray[1];
                object[2] = nArray[2];
                camelliaLightEngine2.kw[3] = nArray[3];
                object = camelliaLightEngine2.subkey;
                CamelliaLightEngine.roldq(15, nArray, 0, (int[])object, 4);
                object = camelliaLightEngine2.subkey;
                CamelliaLightEngine.roldq(30, nArray, 0, (int[])object, 12);
                CamelliaLightEngine.roldq(15, nArray, 0, nArray4, 0);
                camelliaLightEngine2.subkey[18] = nArray4[2];
                camelliaLightEngine2.subkey[19] = nArray4[3];
                object = camelliaLightEngine2.ke;
                CamelliaLightEngine.roldq(17, nArray, 0, (int[])object, 4);
                object = camelliaLightEngine2.subkey;
                CamelliaLightEngine.roldq(17, nArray, 0, (int[])object, 24);
                object = camelliaLightEngine2.subkey;
                CamelliaLightEngine.roldq(17, nArray, 0, (int[])object, 32);
                object = camelliaLightEngine2.subkey;
                object[0] = nArray2[0];
                object[1] = nArray2[1];
                object[2] = nArray2[2];
                camelliaLightEngine2.subkey[3] = nArray2[3];
                CamelliaLightEngine.roldq(15, nArray2, 0, (int[])object, 8);
                object = camelliaLightEngine2.ke;
                CamelliaLightEngine.roldq(15, nArray2, 0, (int[])object, 0);
                CamelliaLightEngine.roldq(15, nArray2, 0, nArray4, 0);
                object = camelliaLightEngine2.subkey;
                object[16] = nArray4[0];
                camelliaLightEngine2.subkey[17] = nArray4[1];
                CamelliaLightEngine.roldq(15, nArray2, 0, (int[])object, 20);
                object = camelliaLightEngine2.subkey;
                CamelliaLightEngine.roldqo32(34, nArray2, 0, (int[])object, 28);
                object = camelliaLightEngine2.kw;
                CamelliaLightEngine.roldq(17, nArray2, 0, (int[])object, 4);
                return;
            } else {
                CamelliaLightEngine camelliaLightEngine3 = object;
                object = camelliaLightEngine3.kw;
                object[4] = nArray[0];
                object[5] = nArray[1];
                object[6] = nArray[2];
                camelliaLightEngine3.kw[7] = nArray[3];
                object = camelliaLightEngine3.subkey;
                CamelliaLightEngine.decroldq(15, nArray, 0, (int[])object, 28);
                object = camelliaLightEngine3.subkey;
                CamelliaLightEngine.decroldq(30, nArray, 0, (int[])object, 20);
                CamelliaLightEngine.decroldq(15, nArray, 0, nArray4, 0);
                camelliaLightEngine3.subkey[16] = nArray4[0];
                camelliaLightEngine3.subkey[17] = nArray4[1];
                object = camelliaLightEngine3.ke;
                CamelliaLightEngine.decroldq(17, nArray, 0, (int[])object, 0);
                object = camelliaLightEngine3.subkey;
                CamelliaLightEngine.decroldq(17, nArray, 0, (int[])object, 8);
                object = camelliaLightEngine3.subkey;
                CamelliaLightEngine.decroldq(17, nArray, 0, (int[])object, 0);
                object = camelliaLightEngine3.subkey;
                object[34] = nArray2[0];
                object[35] = nArray2[1];
                object[32] = nArray2[2];
                camelliaLightEngine3.subkey[33] = nArray2[3];
                CamelliaLightEngine.decroldq(15, nArray2, 0, (int[])object, 24);
                object = camelliaLightEngine3.ke;
                CamelliaLightEngine.decroldq(15, nArray2, 0, (int[])object, 4);
                CamelliaLightEngine.decroldq(15, nArray2, 0, nArray4, 0);
                object = camelliaLightEngine3.subkey;
                object[18] = nArray4[2];
                camelliaLightEngine3.subkey[19] = nArray4[3];
                CamelliaLightEngine.decroldq(15, nArray2, 0, (int[])object, 12);
                object = camelliaLightEngine3.subkey;
                CamelliaLightEngine.decroldqo32(34, nArray2, 0, (int[])object, 4);
                object = camelliaLightEngine3.kw;
                CamelliaLightEngine.roldq(17, nArray2, 0, (int[])object, 0);
            }
            return;
        } else {
            for (n = 0; n < 4; ++n) {
                nArray3[n] = nArray2[n] ^ nArray[n + 4];
            }
            ((CamelliaLightEngine)object).camelliaF2(nArray3, SIGMA, 8);
            if (bl) {
                Object object2 = object;
                object = ((CamelliaLightEngine)object2).kw;
                object[0] = nArray[0];
                object[1] = nArray[1];
                object[2] = nArray[2];
                ((CamelliaLightEngine)object2).kw[3] = nArray[3];
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldqo32(45, nArray, 0, (int[])object, 16);
                object = ((CamelliaLightEngine)object2).ke;
                CamelliaLightEngine.roldq(15, nArray, 0, (int[])object, 4);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldq(17, nArray, 0, (int[])object, 32);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldqo32(34, nArray, 0, (int[])object, 44);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldq(15, nArray, 4, (int[])object, 4);
                object = ((CamelliaLightEngine)object2).ke;
                CamelliaLightEngine.roldq(15, nArray, 4, (int[])object, 0);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldq(30, nArray, 4, (int[])object, 24);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldqo32(34, nArray, 4, (int[])object, 36);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldq(15, nArray2, 0, (int[])object, 8);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldq(30, nArray2, 0, (int[])object, 20);
                object = ((CamelliaLightEngine)object2).ke;
                object[8] = nArray2[1];
                object[9] = nArray2[2];
                object[10] = nArray2[3];
                ((CamelliaLightEngine)object2).ke[11] = nArray2[0];
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldqo32(49, nArray2, 0, (int[])object, 40);
                object = ((CamelliaLightEngine)object2).subkey;
                object[0] = nArray3[0];
                object[1] = nArray3[1];
                object[2] = nArray3[2];
                ((CamelliaLightEngine)object2).subkey[3] = nArray3[3];
                CamelliaLightEngine.roldq(30, nArray3, 0, (int[])object, 12);
                object = ((CamelliaLightEngine)object2).subkey;
                CamelliaLightEngine.roldq(30, nArray3, 0, (int[])object, 28);
                object = ((CamelliaLightEngine)object2).kw;
                CamelliaLightEngine.roldqo32(51, nArray3, 0, (int[])object, 4);
                return;
            } else {
                Object object3 = object;
                object = ((CamelliaLightEngine)object3).kw;
                object[4] = nArray[0];
                object[5] = nArray[1];
                object[6] = nArray[2];
                ((CamelliaLightEngine)object3).kw[7] = nArray[3];
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldqo32(45, nArray, 0, (int[])object, 28);
                object = ((CamelliaLightEngine)object3).ke;
                CamelliaLightEngine.decroldq(15, nArray, 0, (int[])object, 4);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldq(17, nArray, 0, (int[])object, 12);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldqo32(34, nArray, 0, (int[])object, 0);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldq(15, nArray, 4, (int[])object, 40);
                object = ((CamelliaLightEngine)object3).ke;
                CamelliaLightEngine.decroldq(15, nArray, 4, (int[])object, 8);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldq(30, nArray, 4, (int[])object, 20);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldqo32(34, nArray, 4, (int[])object, 8);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldq(15, nArray2, 0, (int[])object, 36);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldq(30, nArray2, 0, (int[])object, 24);
                object = ((CamelliaLightEngine)object3).ke;
                object[2] = nArray2[1];
                object[3] = nArray2[2];
                object[0] = nArray2[3];
                ((CamelliaLightEngine)object3).ke[1] = nArray2[0];
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldqo32(49, nArray2, 0, (int[])object, 4);
                object = ((CamelliaLightEngine)object3).subkey;
                object[46] = nArray3[0];
                object[47] = nArray3[1];
                object[44] = nArray3[2];
                ((CamelliaLightEngine)object3).subkey[45] = nArray3[3];
                CamelliaLightEngine.decroldq(30, nArray3, 0, (int[])object, 32);
                object = ((CamelliaLightEngine)object3).subkey;
                CamelliaLightEngine.decroldq(30, nArray3, 0, (int[])object, 16);
                object = ((CamelliaLightEngine)object3).kw;
                CamelliaLightEngine.roldqo32(51, nArray3, 0, (int[])object, 0);
            }
        }
    }

    private int processBlock128(byte[] objectArray, int n, byte[] byArray, int n2) {
        int n3;
        for (int k = 0; k < 4; ++k) {
            CamelliaLightEngine camelliaLightEngine = object;
            camelliaLightEngine.state[k] = ((CamelliaLightEngine)object).bytes2int((byte[])objectArray, k * 4 + n);
            camelliaLightEngine.state[k] = camelliaLightEngine.state[k] ^ ((CamelliaLightEngine)object).kw[k];
        }
        CamelliaLightEngine camelliaLightEngine = object;
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 0);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 4);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 8);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaFLs((int[])objectArray, camelliaLightEngine.ke, 0);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 12);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 16);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 20);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaFLs((int[])objectArray, camelliaLightEngine.ke, 4);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 24);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 28);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 32);
        int[] nArray = camelliaLightEngine.state;
        Object object = ((CamelliaLightEngine)object).kw;
        nArray[2] = n3 = camelliaLightEngine.state[2] ^ ((CamelliaLightEngine)object).kw[4];
        nArray[3] = camelliaLightEngine.state[3] ^ object[5];
        nArray[0] = camelliaLightEngine.state[0] ^ object[6];
        nArray[1] = camelliaLightEngine.state[1] ^ object[7];
        camelliaLightEngine.int2bytes(n3, byArray, n2);
        camelliaLightEngine.int2bytes(camelliaLightEngine.state[3], byArray, n2 + 4);
        camelliaLightEngine.int2bytes(camelliaLightEngine.state[0], byArray, n2 + 8);
        camelliaLightEngine.int2bytes(camelliaLightEngine.state[1], byArray, n2 + 12);
        return 16;
    }

    private int processBlock192or256(byte[] objectArray, int n, byte[] byArray, int n2) {
        int n3;
        for (int k = 0; k < 4; ++k) {
            CamelliaLightEngine camelliaLightEngine = object;
            camelliaLightEngine.state[k] = ((CamelliaLightEngine)object).bytes2int((byte[])objectArray, k * 4 + n);
            camelliaLightEngine.state[k] = camelliaLightEngine.state[k] ^ ((CamelliaLightEngine)object).kw[k];
        }
        CamelliaLightEngine camelliaLightEngine = object;
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 0);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 4);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 8);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaFLs((int[])objectArray, camelliaLightEngine.ke, 0);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 12);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 16);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 20);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaFLs((int[])objectArray, camelliaLightEngine.ke, 4);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 24);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 28);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 32);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaFLs((int[])objectArray, camelliaLightEngine.ke, 8);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 36);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 40);
        objectArray = camelliaLightEngine.state;
        camelliaLightEngine.camelliaF2((int[])objectArray, camelliaLightEngine.subkey, 44);
        int[] nArray = camelliaLightEngine.state;
        Object object = ((CamelliaLightEngine)object).kw;
        nArray[2] = n3 = camelliaLightEngine.state[2] ^ ((CamelliaLightEngine)object).kw[4];
        nArray[3] = camelliaLightEngine.state[3] ^ object[5];
        nArray[0] = camelliaLightEngine.state[0] ^ object[6];
        nArray[1] = camelliaLightEngine.state[1] ^ object[7];
        camelliaLightEngine.int2bytes(n3, byArray, n2);
        camelliaLightEngine.int2bytes(camelliaLightEngine.state[3], byArray, n2 + 4);
        camelliaLightEngine.int2bytes(camelliaLightEngine.state[0], byArray, n2 + 8);
        camelliaLightEngine.int2bytes(camelliaLightEngine.state[1], byArray, n2 + 12);
        return 16;
    }

    @Override
    public String getAlgorithmName() {
        return "Camellia";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.setKey(bl, ((KeyParameter)cipherParameters).getKey());
            this.initialized = true;
            return;
        }
        throw new IllegalArgumentException("only simple KeyParameter expected.");
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.initialized) {
            if (n + 16 <= byArray.length) {
                if (n2 + 16 <= byArray2.length) {
                    if (this._keyis128) {
                        return this.processBlock128(byArray, n, byArray2, n2);
                    }
                    return this.processBlock192or256(byArray, n, byArray2, n2);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("Camellia is not initialized");
    }

    @Override
    public void reset() {
    }
}

