/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.EphemeralKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.IESParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.IESWithCipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class IESEngine {
    public BasicAgreement agree;
    public DerivationFunction kdf;
    public Mac mac;
    public BufferedBlockCipher cipher;
    public byte[] macBuf;
    public boolean forEncryption;
    public CipherParameters privParam;
    public CipherParameters pubParam;
    public IESParameters param;
    public byte[] V;
    private EphemeralKeyPairGenerator keyPairGenerator;
    private KeyParser keyParser;
    private byte[] IV;

    public IESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac) {
        IESEngine iESEngine = this;
        this.agree = basicAgreement;
        this.kdf = derivationFunction;
        this.mac = mac;
        iESEngine.macBuf = new byte[mac.getMacSize()];
        iESEngine.cipher = null;
    }

    public IESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac, BufferedBlockCipher bufferedBlockCipher) {
        this.agree = basicAgreement;
        this.kdf = derivationFunction;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = bufferedBlockCipher;
    }

    private void extractParams(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            IESEngine iESEngine = parametersWithIV;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            iESEngine.IV = parametersWithIV.getIV();
            iESEngine.param = (IESParameters)parametersWithIV.getParameters();
        } else {
            ((IESEngine)((Object)parametersWithIV)).IV = null;
            ((IESEngine)((Object)parametersWithIV)).param = (IESParameters)cipherParameters;
        }
    }

    private byte[] encryptBlock(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        byte[] byArray3;
        Object object;
        if (this.cipher == null) {
            IESEngine iESEngine = this;
            object = new byte[n2];
            int n3 = this.param.getMacKeySize() / 8;
            byArray3 = new byte[n3];
            int n4 = n2 + n3;
            byte[] byArray4 = new byte[n4];
            iESEngine.kdf.generateBytes(byArray4, 0, n4);
            if (iESEngine.V.length != 0) {
                System.arraycopy(byArray4, 0, byArray3, 0, n3);
                System.arraycopy(byArray4, n3, object, 0, n2);
            } else {
                System.arraycopy(byArray4, 0, object, 0, n2);
                System.arraycopy(byArray4, n2, byArray3, 0, n3);
            }
            byArray2 = new byte[n2];
            for (n4 = 0; n4 != n2; ++n4) {
                byArray2[n4] = (byte)(byArray[n + n4] ^ object[n4]);
            }
        } else {
            IESEngine iESEngine = this;
            int n5 = ((IESWithCipherParameters)iESEngine.param).getCipherKeySize() / 8;
            byArray2 = new byte[n5];
            int n6 = this.param.getMacKeySize() / 8;
            byte[] byArray5 = new byte[n6];
            int n7 = n5 + n6;
            byte[] byArray6 = new byte[n7];
            this.kdf.generateBytes(byArray6, 0, n7);
            System.arraycopy(byArray6, 0, byArray2, 0, n5);
            System.arraycopy(byArray6, n5, byArray5, 0, n6);
            if (iESEngine.IV != null) {
                KeyParameter keyParameter;
                ParametersWithIV parametersWithIV;
                object = parametersWithIV;
                KeyParameter keyParameter2 = keyParameter;
                keyParameter = new KeyParameter(byArray2);
                parametersWithIV = new ParametersWithIV(keyParameter2, this.IV);
                this.cipher.init(true, (CipherParameters)object);
            } else {
                KeyParameter keyParameter;
                object = keyParameter;
                keyParameter = new KeyParameter(byArray2);
                this.cipher.init(true, (CipherParameters)object);
            }
            IESEngine iESEngine2 = this;
            byArray2 = new byte[iESEngine2.cipher.getOutputSize(n2)];
            int n8 = iESEngine2.cipher.processBytes(byArray, n, n2, byArray2, 0);
            n2 = iESEngine2.cipher.doFinal(byArray2, n8) + n8;
            byArray3 = byArray5;
        }
        IESEngine iESEngine = this;
        byArray = iESEngine.param.getEncodingV();
        byte[] byArray7 = null;
        if (iESEngine.V.length != 0) {
            byArray7 = this.getLengthTag(byArray);
        }
        IESEngine iESEngine3 = this;
        int n9 = iESEngine3.mac.getMacSize();
        byte[] byArray8 = new byte[n9];
        iESEngine3.mac.init(new KeyParameter(byArray3));
        iESEngine3.mac.update(byArray2, 0, byArray2.length);
        if (byArray != null) {
            this.mac.update(byArray, 0, byArray.length);
        }
        if (this.V.length != 0) {
            this.mac.update(byArray7, 0, byArray7.length);
        }
        IESEngine iESEngine4 = this;
        iESEngine4.mac.doFinal(byArray8, 0);
        byArray = iESEngine4.V;
        byArray7 = new byte[iESEngine4.V.length + n2 + n9];
        int n10 = byArray.length;
        System.arraycopy(byArray, 0, byArray7, 0, n10);
        n10 = this.V.length;
        System.arraycopy(byArray2, 0, byArray7, n10, n2);
        n10 = this.V.length + n2;
        System.arraycopy(byArray8, 0, byArray7, n10, n9);
        return byArray7;
    }

    private byte[] decryptBlock(byte[] byArray, int n, int n2) {
        IESEngine iESEngine = bufferedBlockCipher;
        int n3 = 0;
        int n4 = iESEngine.V.length;
        if (n2 >= iESEngine.mac.getMacSize() + n4) {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            if (((IESEngine)((Object)bufferedBlockCipher)).cipher == null) {
                IESEngine iESEngine2 = bufferedBlockCipher;
                n4 = n2 - ((IESEngine)((Object)bufferedBlockCipher)).V.length - ((IESEngine)((Object)bufferedBlockCipher)).mac.getMacSize();
                byArray4 = new byte[n4];
                int n5 = ((IESEngine)((Object)bufferedBlockCipher)).param.getMacKeySize() / 8;
                byArray3 = new byte[n5];
                int n6 = n4 + n5;
                byte[] byArray5 = new byte[n6];
                iESEngine2.kdf.generateBytes(byArray5, 0, n6);
                if (iESEngine2.V.length != 0) {
                    System.arraycopy(byArray5, 0, byArray3, 0, n5);
                    System.arraycopy(byArray5, n5, byArray4, 0, n4);
                } else {
                    System.arraycopy(byArray5, 0, byArray4, 0, n4);
                    System.arraycopy(byArray5, n4, byArray3, 0, n5);
                }
                byArray2 = new byte[n4];
                for (n6 = 0; n6 != n4; ++n6) {
                    byArray2[n6] = (byte)(byArray[n + ((IESEngine)((Object)bufferedBlockCipher)).V.length + n6] ^ byArray4[n6]);
                }
            } else {
                KeyParameter keyParameter;
                IESEngine iESEngine3 = bufferedBlockCipher;
                n3 = ((IESWithCipherParameters)iESEngine3.param).getCipherKeySize() / 8;
                byte[] byArray6 = new byte[n3];
                int n7 = ((IESEngine)((Object)bufferedBlockCipher)).param.getMacKeySize() / 8;
                byArray3 = new byte[n7];
                int n8 = n3 + n7;
                byte[] byArray7 = new byte[n8];
                ((IESEngine)((Object)bufferedBlockCipher)).kdf.generateBytes(byArray7, 0, n8);
                System.arraycopy(byArray7, 0, byArray6, 0, n3);
                System.arraycopy(byArray7, n3, byArray3, 0, n7);
                Object object = keyParameter;
                keyParameter = new KeyParameter(byArray6);
                byArray6 = iESEngine3.IV;
                if (iESEngine3.IV != null) {
                    ParametersWithIV parametersWithIV;
                    ParametersWithIV parametersWithIV2 = parametersWithIV;
                    parametersWithIV = new ParametersWithIV((CipherParameters)object, byArray6);
                    object = parametersWithIV2;
                }
                IESEngine iESEngine4 = bufferedBlockCipher;
                iESEngine4.cipher.init(false, (CipherParameters)object);
                byArray2 = new byte[iESEngine4.cipher.getOutputSize(n2 - ((IESEngine)((Object)bufferedBlockCipher)).V.length - ((IESEngine)((Object)bufferedBlockCipher)).mac.getMacSize())];
                object = ((IESEngine)((Object)bufferedBlockCipher)).V;
                n4 = n + ((IESEngine)((Object)bufferedBlockCipher)).V.length;
                n3 = iESEngine4.cipher.processBytes(byArray, n4, n2 - ((Object)object).length - ((IESEngine)((Object)bufferedBlockCipher)).mac.getMacSize(), byArray2, 0);
            }
            IESEngine iESEngine5 = bufferedBlockCipher;
            byte[] byArray8 = iESEngine5.param.getEncodingV();
            byArray4 = null;
            if (iESEngine5.V.length != 0) {
                byArray4 = ((IESEngine)((Object)bufferedBlockCipher)).getLengthTag(byArray8);
            }
            IESEngine iESEngine6 = bufferedBlockCipher;
            int n9 = n + n2;
            byte[] byArray9 = Arrays.copyOfRange(byArray, n9 - ((IESEngine)((Object)bufferedBlockCipher)).mac.getMacSize(), n9);
            int n10 = byArray9.length;
            byte[] byArray10 = new byte[n10];
            iESEngine6.mac.init(new KeyParameter(byArray3));
            byte[] byArray11 = byArray;
            byArray = ((IESEngine)((Object)bufferedBlockCipher)).V;
            iESEngine6.mac.update(byArray11, n += ((IESEngine)((Object)bufferedBlockCipher)).V.length, n2 - byArray.length - n10);
            if (byArray8 != null) {
                ((IESEngine)((Object)bufferedBlockCipher)).mac.update(byArray8, 0, byArray8.length);
            }
            if (((IESEngine)((Object)bufferedBlockCipher)).V.length != 0) {
                ((IESEngine)((Object)bufferedBlockCipher)).mac.update(byArray4, 0, byArray4.length);
            }
            ((IESEngine)((Object)bufferedBlockCipher)).mac.doFinal(byArray10, 0);
            if (Arrays.constantTimeAreEqual(byArray9, byArray10)) {
                BufferedBlockCipher bufferedBlockCipher = ((IESEngine)((Object)bufferedBlockCipher)).cipher;
                if (bufferedBlockCipher == null) {
                    return byArray2;
                }
                return Arrays.copyOfRange(byArray2, 0, bufferedBlockCipher.doFinal(byArray2, n3) + n3);
            }
            throw new InvalidCipherTextException("invalid MAC");
        }
        throw new InvalidCipherTextException("Length of input must be greater than the MAC and V combined");
    }

    public void init(boolean bl, CipherParameters cipherParameters, CipherParameters cipherParameters2, CipherParameters cipherParameters3) {
        IESEngine iESEngine = this;
        this.forEncryption = bl;
        this.privParam = cipherParameters;
        iESEngine.pubParam = cipherParameters2;
        iESEngine.V = new byte[0];
        this.extractParams(cipherParameters3);
    }

    public void init(AsymmetricKeyParameter asymmetricKeyParameter, CipherParameters cipherParameters, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.forEncryption = true;
        this.pubParam = asymmetricKeyParameter;
        this.keyPairGenerator = ephemeralKeyPairGenerator;
        this.extractParams(cipherParameters);
    }

    public void init(AsymmetricKeyParameter asymmetricKeyParameter, CipherParameters cipherParameters, KeyParser keyParser) {
        this.forEncryption = false;
        this.privParam = asymmetricKeyParameter;
        this.keyParser = keyParser;
        this.extractParams(cipherParameters);
    }

    public BufferedBlockCipher getCipher() {
        return this.cipher;
    }

    public Mac getMac() {
        return this.mac;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] processBlock(byte[] byArray, int n, int n2) {
        KDFParameters kDFParameters;
        IESEngine iESEngine;
        IESEngine iESEngine2;
        Object object;
        if (((IESEngine)object3).forEncryption) {
            object = ((IESEngine)object3).keyPairGenerator;
            if (object != null) {
                IESEngine iESEngine3 = object3;
                object = ((EphemeralKeyPairGenerator)object).generate();
                iESEngine3.privParam = ((EphemeralKeyPair)object).getKeyPair().getPrivate();
                iESEngine3.V = ((EphemeralKeyPair)object).getEncodedPublicKey();
            }
        } else if (((IESEngine)object3).keyParser != null) {
            ByteArrayInputStream byteArrayInputStream;
            object = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            try {
                ((IESEngine)object3).pubParam = ((IESEngine)object3).keyParser.readKey((InputStream)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidCipherTextException(b.b.a("unable to recover ephemeral public key: ").append(illegalArgumentException.getMessage()).toString(), illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new InvalidCipherTextException(b.a(iOException, b.b.a("unable to recover ephemeral public key: ")), iOException);
            }
            ((IESEngine)object3).V = Arrays.copyOfRange(byArray, n, n2 - ((ByteArrayInputStream)object).available() + n);
        }
        IESEngine iESEngine4 = object3;
        iESEngine4.agree.init(((IESEngine)object3).privParam);
        object = iESEngine4.agree.calculateAgreement(((IESEngine)object3).pubParam);
        object = BigIntegers.asUnsignedByteArray(iESEngine4.agree.getFieldSize(), (BigInteger)object);
        byte[] byArray2 = iESEngine4.V;
        if (iESEngine4.V.length != 0) {
            Object object2 = object;
            object = Arrays.concatenate(byArray2, (byte[])object);
            Arrays.fill((byte[])object2, (byte)0);
        }
        try {
            IESEngine iESEngine5 = object3;
            iESEngine2 = iESEngine5;
            iESEngine = iESEngine5;
        }
        catch (Throwable throwable) {
            Arrays.fill((byte[])object, (byte)0);
            throw throwable;
        }
        KDFParameters kDFParameters2 = kDFParameters;
        {
            kDFParameters = new KDFParameters((byte[])object, ((IESEngine)object3).param.getDerivationV());
            iESEngine2.kdf.init(kDFParameters2);
            Object object3 = iESEngine.forEncryption ? ((IESEngine)object3).encryptBlock(byArray, n, n2) : ((IESEngine)object3).decryptBlock(byArray, n, n2);
        }
        Arrays.fill((byte[])object, (byte)0);
        return object3;
    }

    public byte[] getLengthTag(byte[] byArray) {
        Object object = new byte[8];
        if (byArray != null) {
            Pack.longToBigEndian((long)byArray.length * 8L, (byte[])object, 0);
        }
        return object;
    }
}

