/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC5Parameters;

public class RC564Engine
implements BlockCipher {
    private static final int wordSize = 64;
    private static final int bytesPerWord = 8;
    private static final long P64 = -5196783011329398165L;
    private static final long Q64 = -7046029254386353131L;
    private int _noRounds = 12;
    private long[] _S = null;
    private boolean forEncryption;

    private void setKey(byte[] byArray) {
        long[] lArray;
        long l;
        int n = (byArray.length + 7) / 8;
        long[] lArray2 = new long[n];
        for (int k = 0; k != byArray.length; ++k) {
            int n2 = k / 8;
            lArray2[n2] = l = lArray2[n2] + ((long)(byArray[k] & 0xFF) << k % 8 * 8);
        }
        long[] lArray3 = new long[(this._noRounds + 1) * 2];
        this._S = lArray3;
        lArray3[0] = -5196783011329398165L;
        int n3 = 1;
        while (true) {
            lArray = this._S;
            if (n3 >= this._S.length) break;
            lArray[n3] = lArray[n3 - 1] + -7046029254386353131L;
            ++n3;
        }
        n3 = n > lArray.length ? n * 3 : lArray.length * 3;
        long l2 = 0L;
        l = 0L;
        int n4 = 0;
        int n5 = 0;
        for (int k = 0; k < n3; ++k) {
            RC564Engine rC564Engine = this;
            long[] lArray4 = rC564Engine._S;
            l2 = rC564Engine.rotateLeft(rC564Engine._S[n4] + l2 + l, 3L);
            long l3 = l;
            lArray4[n4] = l2;
            l = lArray2[n5] + l2 + l;
            long l4 = l2 + l3;
            lArray2[n5] = l = rC564Engine.rotateLeft(l, l4);
            n4 = (n4 + 1) % this._S.length;
            n5 = (n5 + 1) % n;
        }
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        long l = this.bytesToWord(byArray, n) + this._S[0];
        long l2 = this.bytesToWord(byArray, n + 8) + this._S[1];
        for (int k = 1; k <= this._noRounds; ++k) {
            long l3 = l2;
            int n3 = k * 2;
            l2 = this.rotateLeft(l ^ l2, l2) + this._S[n3];
            l = this.rotateLeft(l3 ^ l2, l2) + this._S[n3 + 1];
            long l4 = l2;
            l2 = l;
            l = l4;
        }
        RC564Engine rC564Engine = this;
        rC564Engine.wordToBytes(l, byArray2, n2);
        int n4 = n2 + 8;
        rC564Engine.wordToBytes(l2, byArray2, n4);
        return 16;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        RC564Engine rC564Engine = this;
        long l = rC564Engine.bytesToWord(byArray, n);
        long l2 = rC564Engine.bytesToWord(byArray, n + 8);
        for (int k = (v271562)._noRounds; k >= 1; --k) {
            long l3 = l;
            RC564Engine rC564Engine2 = this;
            int n3 = k * 2;
            l = rC564Engine2.rotateRight(l2 - this._S[n3 + 1], l) ^ l;
            l2 = this.rotateRight(l3 - rC564Engine2._S[n3], l) ^ l;
            long l4 = l2;
            l2 = l;
            l = l4;
        }
        RC564Engine rC564Engine3 = this;
        rC564Engine3.wordToBytes(l - this._S[0], byArray2, n2);
        this.wordToBytes(l2 - rC564Engine3._S[1], byArray2, n2 + 8);
        return 16;
    }

    private long rotateLeft(long l, long l2) {
        return l << (int)(l2 &= 0x3FL) | l >>> (int)(64L - l2);
    }

    private long rotateRight(long l, long l2) {
        return l >>> (int)(l2 &= 0x3FL) | l << (int)(64L - l2);
    }

    private long bytesToWord(byte[] byArray, int n) {
        long l = 0L;
        for (int k = 7; k >= 0; --k) {
            l = (l << 8) + (long)(byArray[k + n] & 0xFF);
        }
        return l;
    }

    private void wordToBytes(long l, byte[] byArray, int n) {
        for (int k = 0; k < 8; ++k) {
            byArray[k + n] = (byte)l;
            l >>>= 8;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "RC5-64";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof RC5Parameters) {
            RC564Engine rC564Engine = rC5Parameters;
            RC5Parameters rC5Parameters = (RC5Parameters)cipherParameters;
            rC564Engine.forEncryption = bl;
            rC564Engine._noRounds = rC5Parameters.getRounds();
            rC564Engine.setKey(rC5Parameters.getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC564 init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    @Override
    public void reset() {
    }
}

