/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.MacDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFDoublePipelineIterationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFDoublePipelineIterationBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final Mac prf;
    private final int h;
    private byte[] fixedInputData;
    private int maxSizeExcl;
    private byte[] ios;
    private boolean useCounter;
    private int generatedBytes;
    private byte[] a;
    private byte[] k;

    public KDFDoublePipelineIterationBytesGenerator(Mac mac) {
        int n;
        KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
        this.prf = mac;
        kDFDoublePipelineIterationBytesGenerator.h = n = mac.getMacSize();
        kDFDoublePipelineIterationBytesGenerator.a = new byte[n];
        kDFDoublePipelineIterationBytesGenerator.k = new byte[n];
    }

    private void generateNext() {
        if (this.generatedBytes == 0) {
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            kDFDoublePipelineIterationBytesGenerator.prf.update(this.fixedInputData, 0, this.fixedInputData.length);
            kDFDoublePipelineIterationBytesGenerator.prf.doFinal(this.a, 0);
        } else {
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            kDFDoublePipelineIterationBytesGenerator.prf.update(this.a, 0, this.a.length);
            kDFDoublePipelineIterationBytesGenerator.prf.doFinal(this.a, 0);
        }
        KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
        kDFDoublePipelineIterationBytesGenerator.prf.update(this.a, 0, this.a.length);
        if (kDFDoublePipelineIterationBytesGenerator.useCounter) {
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator2 = this;
            int n = kDFDoublePipelineIterationBytesGenerator2.generatedBytes / this.h + 1;
            byte[] byArray = kDFDoublePipelineIterationBytesGenerator2.ios;
            switch (kDFDoublePipelineIterationBytesGenerator2.ios.length) {
                default: {
                    throw new IllegalStateException("Unsupported size of counter i");
                }
                case 4: {
                    byArray[0] = (byte)(n >>> 24);
                }
                case 3: {
                    int n2 = byArray.length - 3;
                    byArray[n2] = (byte)(n >>> 16);
                }
                case 2: {
                    int n2 = byArray.length - 2;
                    byArray[n2] = (byte)(n >>> 8);
                }
                case 1: 
            }
            int n3 = n;
            n = byArray.length - 1;
            byArray[n] = (byte)n3;
            this.prf.update(byArray, 0, byArray.length);
        }
        KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator3 = this;
        kDFDoublePipelineIterationBytesGenerator3.prf.update(this.fixedInputData, 0, this.fixedInputData.length);
        kDFDoublePipelineIterationBytesGenerator3.prf.doFinal(this.k, 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFDoublePipelineIterationParameters) {
            derivationParameters = (KDFDoublePipelineIterationParameters)derivationParameters;
            this.prf.init(new KeyParameter(((KDFDoublePipelineIterationParameters)derivationParameters).getKI()));
            this.fixedInputData = ((KDFDoublePipelineIterationParameters)derivationParameters).getFixedInputData();
            int n = ((KDFDoublePipelineIterationParameters)derivationParameters).getR();
            this.ios = new byte[n / 8];
            if (((KDFDoublePipelineIterationParameters)derivationParameters).useCounter()) {
                BigInteger bigInteger = TWO.pow(n).multiply(BigInteger.valueOf(this.h));
                int n2 = bigInteger.compareTo(INTEGER_MAX) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
                this.maxSizeExcl = n2;
            } else {
                this.maxSizeExcl = Integer.MAX_VALUE;
            }
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            kDFDoublePipelineIterationBytesGenerator.useCounter = ((KDFDoublePipelineIterationParameters)derivationParameters).useCounter();
            kDFDoublePipelineIterationBytesGenerator.generatedBytes = 0;
            return;
        }
        throw new IllegalArgumentException("Wrong type of arguments given");
    }

    @Override
    public Mac getMac() {
        return this.prf;
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        int n3 = this.generatedBytes;
        int n4 = n3 + n2;
        if (n4 >= 0 && n4 < this.maxSizeExcl) {
            if (n3 % this.h == 0) {
                this.generateNext();
            }
            int n5 = n;
            KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = this;
            n3 = kDFDoublePipelineIterationBytesGenerator.generatedBytes;
            n4 = kDFDoublePipelineIterationBytesGenerator.h;
            int n6 = n3;
            n3 %= n4;
            n4 = Math.min(n4 - n6 % n4, n2);
            System.arraycopy(kDFDoublePipelineIterationBytesGenerator.k, n3, byArray, n, n4);
            kDFDoublePipelineIterationBytesGenerator.generatedBytes += n4;
            n = n2 - n4;
            n3 = n5 + n4;
            while (n > 0) {
                int n7 = n3;
                int n8 = n;
                KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator2 = this;
                kDFDoublePipelineIterationBytesGenerator2.generateNext();
                n = Math.min(kDFDoublePipelineIterationBytesGenerator2.h, n);
                System.arraycopy(kDFDoublePipelineIterationBytesGenerator2.k, 0, byArray, n3, n);
                kDFDoublePipelineIterationBytesGenerator2.generatedBytes += n;
                n3 = n8 - n;
                n = n7 + n;
                int n9 = n3;
                n3 = n;
                n = n9;
            }
            return n2;
        }
        throw new DataLengthException(b.a(b.b.a("Current KDFCTR may only be used for "), this.maxSizeExcl, " bytes"));
    }
}

