/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;

public class Poly1305KeyGenerator
extends CipherKeyGenerator {
    private static final byte R_MASK_LOW_2 = -4;
    private static final byte R_MASK_HIGH_4 = 15;

    public static void clamp(byte[] byArray) {
        if (byArray.length == 32) {
            byte[] byArray2 = byArray;
            byArray2[3] = (byte)(byArray[3] & 0xF);
            byArray2[7] = (byte)(byArray[7] & 0xF);
            byArray2[11] = (byte)(byArray[11] & 0xF);
            byArray2[15] = (byte)(byArray[15] & 0xF);
            byArray2[4] = (byte)(byArray[4] & 0xFFFFFFFC);
            byArray2[8] = (byte)(byArray[8] & 0xFFFFFFFC);
            byArray2[12] = (byte)(byArray[12] & 0xFFFFFFFC);
            return;
        }
        throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
    }

    public static void checkKey(byte[] byArray) {
        if (byArray.length == 32) {
            byte[] byArray2 = byArray;
            Poly1305KeyGenerator.checkMask(byArray2[3], (byte)15);
            Poly1305KeyGenerator.checkMask(byArray2[7], (byte)15);
            Poly1305KeyGenerator.checkMask(byArray2[11], (byte)15);
            Poly1305KeyGenerator.checkMask(byArray2[15], (byte)15);
            Poly1305KeyGenerator.checkMask(byArray2[4], (byte)-4);
            Poly1305KeyGenerator.checkMask(byArray2[8], (byte)-4);
            Poly1305KeyGenerator.checkMask(byArray[12], (byte)-4);
            return;
        }
        throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
    }

    private static void checkMask(byte by, byte by2) {
        if ((by & ~by2) == 0) {
            return;
        }
        throw new IllegalArgumentException("Invalid format for r portion of Poly1305 key.");
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(new KeyGenerationParameters(keyGenerationParameters.getRandom(), 256));
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = super.generateKey();
        Poly1305KeyGenerator.clamp(byArray);
        return byArray;
    }
}

