/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class OFBBlockCipher
extends StreamBlockCipher {
    private int byteCount;
    private byte[] IV;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private final int blockSize;
    private final BlockCipher cipher;

    public OFBBlockCipher(BlockCipher blockCipher, int n) {
        super(blockCipher);
        if (n <= blockCipher.getBlockSize() * 8 && n >= 8 && n % 8 == 0) {
            this.cipher = blockCipher;
            this.blockSize = n / 8;
            this.IV = new byte[blockCipher.getBlockSize()];
            this.ofbV = new byte[blockCipher.getBlockSize()];
            this.ofbOutV = new byte[blockCipher.getBlockSize()];
            return;
        }
        throw new IllegalArgumentException(f.a("0FB", n, " not supported"));
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                Object object2 = object;
                int n = byArray2.length - ((Object)object).length;
                int n2 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray2, n, n2);
                int n3 = 0;
                while (true) {
                    byte[] byArray3 = this.IV;
                    if (n3 < this.IV.length - ((Object)object).length) {
                        byArray3[n3] = 0;
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else {
                int n = byArray2.length;
                System.arraycopy(object, 0, byArray2, 0, n);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OFB" + this.blockSize * 8;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        OFBBlockCipher oFBBlockCipher = this;
        oFBBlockCipher.processBytes(byArray, n, this.blockSize, byArray2, n2);
        return oFBBlockCipher.blockSize;
    }

    @Override
    public void reset() {
        OFBBlockCipher oFBBlockCipher = object;
        Object object = ((OFBBlockCipher)object).ofbV;
        int n = oFBBlockCipher.IV.length;
        System.arraycopy(oFBBlockCipher.IV, 0, object, 0, n);
        oFBBlockCipher.byteCount = 0;
        oFBBlockCipher.cipher.reset();
    }

    @Override
    public byte calculateByte(byte by) {
        int n;
        byte[] byArray;
        if (this.byteCount == 0) {
            OFBBlockCipher oFBBlockCipher = this;
            byArray = oFBBlockCipher.ofbV;
            byte[] byArray2 = oFBBlockCipher.ofbOutV;
            this.cipher.processBlock(byArray, 0, byArray2, 0);
        }
        OFBBlockCipher oFBBlockCipher = this;
        byArray = oFBBlockCipher.ofbOutV;
        int n2 = oFBBlockCipher.byteCount;
        this.byteCount = n = n2 + 1;
        by = (byte)(byArray[n2] ^ by);
        int n3 = this.blockSize;
        if (n == n3) {
            OFBBlockCipher oFBBlockCipher2 = this;
            oFBBlockCipher2.byteCount = 0;
            byte[] byArray3 = oFBBlockCipher2.ofbV;
            int n4 = n3;
            n3 = byArray3.length - n3;
            System.arraycopy(oFBBlockCipher2.ofbV, n4, byArray3, 0, n3);
            byte[] byArray4 = this.ofbV;
            int n5 = this.blockSize;
            int n6 = this.ofbV.length - n5;
            System.arraycopy(oFBBlockCipher2.ofbOutV, 0, byArray4, n6, n5);
        }
        return by;
    }
}

