/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class SkeinParameters
implements CipherParameters {
    public static final int PARAM_TYPE_KEY = 0;
    public static final int PARAM_TYPE_CONFIG = 4;
    public static final int PARAM_TYPE_PERSONALISATION = 8;
    public static final int PARAM_TYPE_PUBLIC_KEY = 12;
    public static final int PARAM_TYPE_KEY_IDENTIFIER = 16;
    public static final int PARAM_TYPE_NONCE = 20;
    public static final int PARAM_TYPE_MESSAGE = 48;
    public static final int PARAM_TYPE_OUTPUT = 63;
    private Hashtable parameters;

    public SkeinParameters() {
        Hashtable hashtable;
        SkeinParameters skeinParameters = hashtable2;
        Hashtable hashtable2 = hashtable;
        hashtable = new Hashtable();
        skeinParameters(hashtable2);
    }

    private SkeinParameters(Hashtable hashtable) {
        this.parameters = hashtable;
    }

    public /* synthetic */ SkeinParameters(Hashtable hashtable, 1 var2_2) {
        this(hashtable);
    }

    public Hashtable getParameters() {
        return this.parameters;
    }

    public byte[] getKey() {
        return (byte[])this.parameters.get(Integers.valueOf(0));
    }

    public byte[] getPersonalisation() {
        return (byte[])this.parameters.get(Integers.valueOf(8));
    }

    public byte[] getPublicKey() {
        return (byte[])this.parameters.get(Integers.valueOf(12));
    }

    public byte[] getKeyIdentifier() {
        return (byte[])this.parameters.get(Integers.valueOf(16));
    }

    public byte[] getNonce() {
        return (byte[])this.parameters.get(Integers.valueOf(20));
    }

    public static class Builder {
        private Hashtable parameters;

        public Builder() {
            Hashtable hashtable;
            Hashtable hashtable2 = hashtable;
            hashtable = new Hashtable();
            v1.parameters = hashtable2;
        }

        public Builder(Hashtable hashtable) {
            Hashtable hashtable2;
            Object object = hashtable2;
            hashtable2 = new Hashtable();
            this.parameters = object;
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                Integer n = (Integer)object.nextElement();
                this.parameters.put(n, hashtable.get(n));
            }
        }

        public Builder(SkeinParameters skeinParameters) {
            this.parameters = new Hashtable();
            Enumeration enumeration = skeinParameters.parameters.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                this.parameters.put(n, skeinParameters.parameters.get(n));
            }
        }

        public Builder set(int n, byte[] byArray) {
            if (byArray != null) {
                if (n != 0 && (n < 4 || n >= 63 || n == 48)) {
                    throw new IllegalArgumentException("Parameter types must be in the range 0,5..47,49..62.");
                }
                if (n != 4) {
                    Builder builder = this;
                    builder.parameters.put(Integers.valueOf(n), byArray);
                    return builder;
                }
                throw new IllegalArgumentException("Parameter type 4 is reserved for internal use.");
            }
            throw new IllegalArgumentException("Parameter value must not be null.");
        }

        public Builder setKey(byte[] byArray) {
            return this.set(0, byArray);
        }

        public Builder setPersonalisation(byte[] byArray) {
            return this.set(8, byArray);
        }

        public Builder setPersonalisation(Date date, String string, String string2) {
            OutputStreamWriter outputStreamWriter;
            ByteArrayOutputStream byteArrayOutputStream;
            Builder builder;
            try {
                builder = byteArrayOutputStream2;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(j.a("Byte I/O failed: ", iOException));
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
            String string3 = string2;
            OutputStreamWriter outputStreamWriter3 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter4 = outputStreamWriter3;
            OutputStreamWriter outputStreamWriter5 = outputStreamWriter3;
            String string4 = string;
            OutputStreamWriter outputStreamWriter6 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter7 = outputStreamWriter6;
            OutputStreamWriter outputStreamWriter8 = outputStreamWriter6;
            outputStreamWriter6((OutputStream)byteArrayOutputStream2, "UTF-8");
            outputStreamWriter8.write(new SimpleDateFormat("YYYYMMDD").format(date));
            outputStreamWriter7.write(" ");
            outputStreamWriter4.write(string4);
            outputStreamWriter5.write(" ");
            outputStreamWriter.write(string3);
            outputStreamWriter.close();
            int n = 8;
            return builder.set(n, byteArrayOutputStream.toByteArray());
        }

        public Builder setPersonalisation(Date date, Locale locale, String string, String string2) {
            OutputStreamWriter outputStreamWriter;
            ByteArrayOutputStream byteArrayOutputStream;
            Builder builder;
            try {
                builder = byteArrayOutputStream2;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(j.a("Byte I/O failed: ", iOException));
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
            String string3 = string2;
            OutputStreamWriter outputStreamWriter3 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter4 = outputStreamWriter3;
            OutputStreamWriter outputStreamWriter5 = outputStreamWriter3;
            String string4 = string;
            OutputStreamWriter outputStreamWriter6 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter7 = outputStreamWriter6;
            OutputStreamWriter outputStreamWriter8 = outputStreamWriter6;
            outputStreamWriter6((OutputStream)byteArrayOutputStream2, "UTF-8");
            outputStreamWriter8.write(new SimpleDateFormat("YYYYMMDD", locale).format(date));
            outputStreamWriter7.write(" ");
            outputStreamWriter4.write(string4);
            outputStreamWriter5.write(" ");
            outputStreamWriter.write(string3);
            outputStreamWriter.close();
            int n = 8;
            return builder.set(n, byteArrayOutputStream.toByteArray());
        }

        public Builder setPublicKey(byte[] byArray) {
            return this.set(12, byArray);
        }

        public Builder setKeyIdentifier(byte[] byArray) {
            return this.set(16, byArray);
        }

        public Builder setNonce(byte[] byArray) {
            return this.set(20, byArray);
        }

        public SkeinParameters build() {
            return new SkeinParameters(this.parameters, null);
        }
    }
}

