/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSTU4145Signer
implements DSAExt {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private ECKeyParameters key;
    private SecureRandom random;

    private static BigInteger generateRandomInteger(BigInteger bigInteger, SecureRandom secureRandom) {
        return BigIntegers.createRandomBigInteger(bigInteger.bitLength() - 1, secureRandom);
    }

    private static ECFieldElement hash2FieldElement(ECCurve eCCurve, byte[] byArray) {
        byArray = Arrays.reverse(byArray);
        return eCCurve.fromBigInteger(DSTU4145Signer.truncate(new BigInteger(1, byArray), eCCurve.getFieldSize()));
    }

    private static BigInteger fieldElement2Integer(BigInteger bigInteger, ECFieldElement eCFieldElement) {
        return DSTU4145Signer.truncate(eCFieldElement.toBigInteger(), bigInteger.bitLength() - 1);
    }

    private static BigInteger truncate(BigInteger bigInteger, int n) {
        if (bigInteger.bitLength() > n) {
            bigInteger = bigInteger.mod(ONE.shiftLeft(n));
        }
        return bigInteger;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                cipherParameters = parametersWithRandom.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.key = (ECPrivateKeyParameters)cipherParameters;
        } else {
            this.key = (ECPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] object) {
        BigInteger bigInteger;
        Object object2;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        Object object3 = eCDomainParameters.getCurve();
        ECFieldElement eCFieldElement = DSTU4145Signer.hash2FieldElement((ECCurve)object3, (byte[])object);
        object = eCFieldElement;
        if (eCFieldElement.isZero()) {
            object = ((ECCurve)object3).fromBigInteger(ONE);
        }
        DSTU4145Signer dSTU4145Signer = this;
        object3 = eCDomainParameters.getN();
        BigInteger bigInteger2 = ((ECPrivateKeyParameters)dSTU4145Signer.key).getD();
        ECMultiplier eCMultiplier = dSTU4145Signer.createBasePointMultiplier();
        do {
            bigInteger = DSTU4145Signer.generateRandomInteger((BigInteger)object3, this.random);
        } while (((ECFieldElement)(object2 = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger).normalize().getAffineXCoord())).isZero() || ((BigInteger)(object2 = DSTU4145Signer.fieldElement2Integer((BigInteger)object3, ((ECFieldElement)object).multiply((ECFieldElement)object2)))).signum() == 0 || (bigInteger = ((BigInteger)object2).multiply(bigInteger2).add(bigInteger).mod((BigInteger)object3)).signum() == 0);
        return new BigInteger[]{object2, bigInteger};
    }

    @Override
    public boolean verifySignature(byte[] object, BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.signum() > 0 && bigInteger2.signum() > 0) {
            ECDomainParameters eCDomainParameters = ((DSTU4145Signer)this).key.getParameters();
            BigInteger bigInteger3 = eCDomainParameters.getN();
            if (bigInteger.compareTo(bigInteger3) < 0 && bigInteger2.compareTo(bigInteger3) < 0) {
                ECCurve eCCurve = eCDomainParameters.getCurve();
                ECFieldElement eCFieldElement = DSTU4145Signer.hash2FieldElement(eCCurve, (byte[])object);
                object = eCFieldElement;
                if (eCFieldElement.isZero()) {
                    object = eCCurve.fromBigInteger(ONE);
                }
                if (((ECPoint)(this = ECAlgorithms.sumOfTwoMultiplies(eCDomainParameters.getG(), bigInteger2, ((ECPublicKeyParameters)((DSTU4145Signer)this).key).getQ(), bigInteger).normalize())).isInfinity()) {
                    return false;
                }
                return DSTU4145Signer.fieldElement2Integer(bigInteger3, ((ECFieldElement)object).multiply(((ECPoint)this).getAffineXCoord())).compareTo(bigInteger) == 0;
            }
            return false;
        }
        return false;
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

