/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.math.BigInteger;

class SSHBuffer {
    private final byte[] buffer;
    private int pos = 0;

    public SSHBuffer(byte[] byArray, byte[] byArray2) {
        this.buffer = byArray2;
        for (int k = 0; k != byArray.length; ++k) {
            if (byArray[k] == byArray2[k]) {
                continue;
            }
            throw new IllegalArgumentException("magic-number incorrect");
        }
        this.pos += byArray.length;
    }

    public SSHBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public int readU32() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        if (n <= this.buffer.length - 4) {
            int n2 = n++;
            int n3 = n++;
            int n4 = n++;
            this.pos = n + 1;
            return (byArray[n2] & 0xFF) << 24 | (byArray[n3] & 0xFF) << 16 | (byArray[n4] & 0xFF) << 8 | byArray[n] & 0xFF;
        }
        throw new IllegalArgumentException("4 bytes for U32 exceeds buffer.");
    }

    public String readString() {
        return Strings.fromByteArray(this.readBlock());
    }

    public byte[] readBlock() {
        int n = this.readU32();
        if (n == 0) {
            return new byte[0];
        }
        int n2 = this.pos;
        byte[] byArray = this.buffer;
        if (n2 <= this.buffer.length - n) {
            int n3;
            this.pos = n3 = n2 + n;
            return Arrays.copyOfRange(byArray, n2, n3);
        }
        throw new IllegalArgumentException("not enough data for block");
    }

    public void skipBlock() {
        SSHBuffer sSHBuffer = this;
        int n = sSHBuffer.pos;
        int n2 = sSHBuffer.readU32();
        if (n <= this.buffer.length - n2) {
            this.pos = n + n2;
            return;
        }
        throw new IllegalArgumentException("not enough data for block");
    }

    public byte[] readPaddedBlock() {
        return this.readPaddedBlock(8);
    }

    public byte[] readPaddedBlock(int n) {
        int n2 = this.readU32();
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = this.pos;
        byte[] byArray = this.buffer;
        if (n3 <= this.buffer.length - n2) {
            if (n2 % n == 0) {
                int n4;
                int n5 = n2;
                this.pos = n2 = n3 + n2;
                if (n5 > 0 && (n4 = byArray[n2 - 1] & 0xFF) > 0 && n4 < n) {
                    n = 1;
                    int n6 = n2 -= n4;
                    while (n <= n4) {
                        if (n == (this.buffer[n6] & 0xFF)) {
                            ++n;
                            ++n6;
                            continue;
                        }
                        throw new IllegalArgumentException("incorrect padding");
                    }
                }
                return Arrays.copyOfRange(this.buffer, n3, n2);
            }
            throw new IllegalArgumentException("missing padding");
        }
        throw new IllegalArgumentException("not enough data for block");
    }

    public BigInteger readBigNumPositive() {
        SSHBuffer sSHBuffer = this;
        int n = sSHBuffer.readU32();
        int n2 = sSHBuffer.pos;
        byte[] byArray = this.buffer;
        if (n2 + n <= this.buffer.length) {
            int n3;
            this.pos = n3 = n2 + n;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n2, n3);
            return new BigInteger(1, byArray2);
        }
        throw new IllegalArgumentException("not enough data for big num");
    }

    public byte[] getBuffer() {
        return Arrays.clone(this.buffer);
    }

    public boolean hasRemaining() {
        return this.pos < this.buffer.length;
    }
}

