/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GOST3411Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ECGOST3410Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.GOST3410Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.GOST3410Key;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSAExt signer;

    public SignatureSpi() {
        ECGOST3410Signer eCGOST3410Signer;
        GOST3411Digest gOST3411Digest;
        Object object = gOST3411Digest;
        gOST3411Digest = new GOST3411Digest();
        v1.digest = object;
        object = eCGOST3410Signer;
        eCGOST3410Signer = new ECGOST3410Signer();
        v1.signer = object;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) {
        return publicKey instanceof BCECGOST3410PublicKey ? ((BCECGOST3410PublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void engineInitVerify(PublicKey object) {
        if (object instanceof ECPublicKey) {
            object = SignatureSpi.generatePublicKeyParameter((PublicKey)object);
        } else if (object instanceof GOST3410Key) {
            object = GOST3410Util.generatePublicKeyParameter((PublicKey)object);
        } else {
            try {
                object = ECUtil.generatePublicKeyParameter(BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(object.getEncoded())));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        SignatureSpi signatureSpi = this;
        signatureSpi.digest.reset();
        signatureSpi.signer.init(false, (CipherParameters)object);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        object = object instanceof ECKey ? ECUtil.generatePrivateKeyParameter((PrivateKey)object) : GOST3410Util.generatePrivateKeyParameter((PrivateKey)object);
        SignatureSpi signatureSpi = parametersWithRandom2;
        signatureSpi.digest.reset();
        SecureRandom secureRandom = signatureSpi.appRandom;
        if (secureRandom != null) {
            ParametersWithRandom parametersWithRandom;
            ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
            parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
            ((SignatureSpi)((Object)parametersWithRandom2)).signer.init(true, parametersWithRandom2);
        } else {
            ((SignatureSpi)((Object)parametersWithRandom2)).signer.init(true, (CipherParameters)object);
        }
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] engineSign() {
        block19: {
            block18: {
                block17: {
                    v0 = this;
                    this = new byte[v0.digest.getDigestSize()];
                    v0.digest.doFinal((byte[])this, 0);
                    try {
                        var1_4 = new byte[64];
                    }
                    catch (Exception var0_3) {
                        throw new SignatureException(var0_3.toString());
                    }
                    v1 = v0.signer.generateSignature((byte[])this);
                    v2 = v1;
                    this = v1[0].toByteArray();
                    var2_5 = v2[1].toByteArray();
                    if (var2_5[0] == 0) break block17;
                    var3_7 = 0;
                    var2_6 = 32 - var2_5.length;
                    var4_8 = var2_5.length;
                    System.arraycopy(var2_5, var3_7, var1_4, var2_6, var4_8);
                    ** GOTO lbl32
                }
                var2_6 = 32 - (var2_5.length - 1);
                v3 = var2_5.length;
                System.arraycopy(var2_5, 1, var1_4, var2_6, v3 - 1);
lbl32:
                // 2 sources

                if (this[0] == false) break block18;
                v4 = this;
                var2_6 = 0;
                var0_1 = 64 - ((Object)this).length;
                var3_7 = ((Object)v4).length;
                System.arraycopy(v4, var2_6, var1_4, var0_1, var3_7);
                break block19;
            }
            var0_2 = 64 - (((Object)this).length - 1);
            v5 = ((Object)this).length;
            System.arraycopy(this, 1, var1_4, var0_2, v5 - 1);
        }
        return var1_4;
    }

    @Override
    public boolean engineVerify(byte[] object) {
        BigInteger bigInteger;
        SignatureSpi signatureSpi = object2;
        SignatureSpi signatureSpi2 = object2;
        Object object2 = new byte[signatureSpi2.digest.getDigestSize()];
        signatureSpi2.digest.doFinal((byte[])object2, 0);
        try {
            object = new byte[32];
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        byte[] byArray = new byte[32];
        System.arraycopy(object, 0, byArray, 0, 32);
        System.arraycopy(object, 32, object, 0, 32);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        bigIntegerArray[0] = new BigInteger(1, (byte[])object);
        object = bigInteger;
        bigInteger = new BigInteger(1, byArray);
        bigIntegerArray[1] = bigInteger;
        return signatureSpi.signer.verifySignature((byte[])object2, bigIntegerArray2[0], (BigInteger)object);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }
}

