/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.FiniteField;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.PolynomialExtensionField;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.HashMap;
import java.util.Map;

public class EC5Util {
    private static Map customCurves;

    public static ECCurve getCurve(ProviderConfiguration object, X962Parameters aSN1Object) {
        block8: {
            block6: {
                Object object2;
                block7: {
                    block5: {
                        object2 = object.getAcceptableNamedCurves();
                        if (!((X962Parameters)aSN1Object).isNamedCurve()) break block5;
                        aSN1Object = ASN1ObjectIdentifier.getInstance(((X962Parameters)aSN1Object).getParameters());
                        if (!object2.isEmpty() && !object2.contains(aSN1Object)) {
                            throw new IllegalStateException("named curve not acceptable");
                        }
                        object2 = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1Object);
                        if (object2 == null) {
                            object2 = (X9ECParameters)object.getAdditionalECParameters().get(aSN1Object);
                        }
                        object = ((X9ECParameters)object2).getCurve();
                        break block6;
                    }
                    if (!((X962Parameters)aSN1Object).isImplicitlyCA()) break block7;
                    object = object.getEcImplicitlyCa().getCurve();
                    break block6;
                }
                object = ASN1Sequence.getInstance(((X962Parameters)aSN1Object).getParameters());
                if (!object2.isEmpty()) break block8;
                object = ((ASN1Sequence)object).size() > 3 ? X9ECParameters.getInstance(object).getCurve() : ECGOST3410NamedCurves.getByOIDX9(ASN1ObjectIdentifier.getInstance(((ASN1Sequence)object).getObjectAt(0))).getCurve();
            }
            return object;
        }
        throw new IllegalStateException("encoded parameters not acceptable");
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration object, ECParameterSpec object2) {
        if (object2 == null) {
            ECDomainParameters eCDomainParameters;
            object = object.getEcImplicitlyCa();
            object2 = eCDomainParameters;
            Object object3 = object;
            object = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object3).getCurve();
            ECPoint eCPoint = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object3).getG();
            BigInteger bigInteger = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object3).getN();
            BigInteger bigInteger2 = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object3).getH();
            byte[] byArray = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object3).getSeed();
            eCDomainParameters = new ECDomainParameters((ECCurve)object, eCPoint, bigInteger, bigInteger2, byArray);
        } else {
            object2 = ECUtil.getDomainParameters((ProviderConfiguration)object, EC5Util.convertSpec((ECParameterSpec)object2));
        }
        return object2;
    }

    public static ECParameterSpec convertToSpec(X962Parameters object, ECCurve object2) {
        Object object3;
        if (((X962Parameters)object).isNamedCurve()) {
            ECNamedCurveSpec eCNamedCurveSpec;
            Object object4 = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)(object = (ASN1ObjectIdentifier)((X962Parameters)object).getParameters()));
            if (object4 == null && !(object3 = BouncyCastleProvider.CONFIGURATION.getAdditionalECParameters()).isEmpty()) {
                object4 = (X9ECParameters)object3.get(object);
            }
            object2 = EC5Util.convertCurve((ECCurve)object2, ((X9ECParameters)object4).getSeed());
            object3 = eCNamedCurveSpec;
            X9ECParameters x9ECParameters = object4;
            object = ECUtil.getCurveName((ASN1ObjectIdentifier)object);
            object4 = EC5Util.convertPoint(x9ECParameters.getG());
            BigInteger bigInteger = x9ECParameters.getN();
            BigInteger bigInteger2 = x9ECParameters.getH();
            eCNamedCurveSpec = new ECNamedCurveSpec((String)object, (EllipticCurve)object2, (java.security.spec.ECPoint)object4, bigInteger, bigInteger2);
        } else if (((X962Parameters)object).isImplicitlyCA()) {
            object3 = null;
        } else if (((ASN1Sequence)(object = ASN1Sequence.getInstance(((X962Parameters)object).getParameters()))).size() > 3) {
            object = X9ECParameters.getInstance(object);
            object2 = EC5Util.convertCurve((ECCurve)object2, ((X9ECParameters)object).getSeed());
            if (((X9ECParameters)object).getH() != null) {
                ECParameterSpec eCParameterSpec;
                ECParameterSpec eCParameterSpec2 = eCParameterSpec;
                Object object5 = object2;
                Object object6 = object;
                object = EC5Util.convertPoint(((X9ECParameters)object6).getG());
                object2 = ((X9ECParameters)object6).getN();
                int n = ((X9ECParameters)object6).getH().intValue();
                eCParameterSpec = new ECParameterSpec((EllipticCurve)object5, (java.security.spec.ECPoint)object, (BigInteger)object2, n);
                object3 = eCParameterSpec2;
            } else {
                ECParameterSpec eCParameterSpec;
                ECParameterSpec eCParameterSpec3 = eCParameterSpec;
                Object object7 = object;
                object = EC5Util.convertPoint(((X9ECParameters)object7).getG());
                eCParameterSpec = new ECParameterSpec((EllipticCurve)object2, (java.security.spec.ECPoint)object, ((X9ECParameters)object7).getN(), 1);
                object3 = eCParameterSpec3;
            }
        } else {
            ECNamedCurveSpec eCNamedCurveSpec;
            object = GOST3410PublicKeyAlgParameters.getInstance(object);
            object2 = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(((GOST3410PublicKeyAlgParameters)object).getPublicKeyParamSet()));
            EllipticCurve ellipticCurve = EC5Util.convertCurve(((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object2).getCurve(), ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object2).getSeed());
            object3 = eCNamedCurveSpec;
            Object object8 = object2;
            object = ECGOST3410NamedCurves.getName(((GOST3410PublicKeyAlgParameters)object).getPublicKeyParamSet());
            object2 = EC5Util.convertPoint(((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object8).getG());
            BigInteger bigInteger = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object8).getN();
            BigInteger bigInteger3 = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object8).getH();
            eCNamedCurveSpec = new ECNamedCurveSpec((String)object, ellipticCurve, (java.security.spec.ECPoint)object2, bigInteger, bigInteger3);
        }
        return object3;
    }

    public static ECParameterSpec convertToSpec(X9ECParameters x9ECParameters) {
        X9ECParameters x9ECParameters2 = x9ECParameters;
        EllipticCurve ellipticCurve = EC5Util.convertCurve(x9ECParameters2.getCurve(), null);
        java.security.spec.ECPoint eCPoint = EC5Util.convertPoint(x9ECParameters2.getG());
        BigInteger bigInteger = x9ECParameters2.getN();
        int n = x9ECParameters.getH().intValue();
        return new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n);
    }

    public static ECParameterSpec convertToSpec(ECDomainParameters eCDomainParameters) {
        ECDomainParameters eCDomainParameters2 = eCDomainParameters;
        EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters2.getCurve(), null);
        java.security.spec.ECPoint eCPoint = EC5Util.convertPoint(eCDomainParameters2.getG());
        BigInteger bigInteger = eCDomainParameters2.getN();
        int n = eCDomainParameters.getH().intValue();
        return new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n);
    }

    public static EllipticCurve convertCurve(ECCurve object, byte[] object2) {
        ECCurve eCCurve = object;
        object = EC5Util.convertField(eCCurve.getField());
        object2 = eCCurve.getA().toBigInteger();
        BigInteger bigInteger = eCCurve.getB().toBigInteger();
        return new EllipticCurve((ECField)object, (BigInteger)object2, bigInteger, null);
    }

    public static ECCurve convertCurve(EllipticCurve object) {
        EllipticCurve ellipticCurve = object;
        object = ellipticCurve.getField();
        BigInteger bigInteger = ellipticCurve.getA();
        BigInteger bigInteger2 = ellipticCurve.getB();
        if (object instanceof ECFieldFp) {
            ECCurve.Fp fp;
            ECCurve.Fp fp2 = fp;
            fp = new ECCurve.Fp(((ECFieldFp)object).getP(), bigInteger, bigInteger2);
            if (customCurves.containsKey(fp2)) {
                return (ECCurve)customCurves.get(fp2);
            }
            return fp2;
        }
        ECFieldF2m eCFieldF2m = (ECFieldF2m)object;
        int n = eCFieldF2m.getM();
        int[] nArray = ECUtil.convertMidTerms(eCFieldF2m.getMidTermsOfReductionPolynomial());
        int n2 = n;
        n = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        return new ECCurve.F2m(n2, n, n3, n4, bigInteger, bigInteger2);
    }

    public static ECField convertField(FiniteField object) {
        if (ECAlgorithms.isFpField((FiniteField)object)) {
            return new ECFieldFp(object.getCharacteristic());
        }
        object = ((PolynomialExtensionField)object).getMinimalPolynomial();
        int[] nArray = object.getExponentsPresent();
        int[] nArray2 = Arrays.reverse(Arrays.copyOfRange(nArray, 1, nArray.length - 1));
        return new ECFieldF2m(object.getDegree(), nArray2);
    }

    public static ECParameterSpec convertSpec(EllipticCurve object, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec object2) {
        com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = object2;
        java.security.spec.ECPoint eCPoint = EC5Util.convertPoint(eCParameterSpec.getG());
        if (eCParameterSpec instanceof ECNamedCurveParameterSpec) {
            Object object3 = ((ECNamedCurveParameterSpec)object2).getName();
            String string = object3;
            com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec2 = object2;
            object2 = eCParameterSpec2.getN();
            object3 = eCParameterSpec2.getH();
            return new ECNamedCurveSpec(string, (EllipticCurve)object, eCPoint, (BigInteger)object2, (BigInteger)object3);
        }
        EllipticCurve ellipticCurve = object;
        com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec3 = object2;
        object = eCParameterSpec3.getN();
        int n = eCParameterSpec3.getH().intValue();
        return new ECParameterSpec(ellipticCurve, eCPoint, (BigInteger)object, n);
    }

    public static com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec convertSpec(ECParameterSpec eCParameterSpec) {
        ECParameterSpec eCParameterSpec2 = eCParameterSpec;
        ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec2.getCurve());
        ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator());
        BigInteger bigInteger = eCParameterSpec2.getOrder();
        BigInteger bigInteger2 = BigInteger.valueOf(eCParameterSpec2.getCofactor());
        byte[] byArray = eCParameterSpec2.getCurve().getSeed();
        if (eCParameterSpec2 instanceof ECNamedCurveSpec) {
            return new ECNamedCurveParameterSpec(((ECNamedCurveSpec)eCParameterSpec).getName(), eCCurve, eCPoint, bigInteger, bigInteger2, byArray);
        }
        return new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec(eCCurve, eCPoint, bigInteger, bigInteger2, byArray);
    }

    public static ECPoint convertPoint(ECParameterSpec eCParameterSpec, java.security.spec.ECPoint eCPoint) {
        return EC5Util.convertPoint(EC5Util.convertCurve(eCParameterSpec.getCurve()), eCPoint);
    }

    public static ECPoint convertPoint(ECCurve object, java.security.spec.ECPoint eCPoint) {
        ECCurve eCCurve = object;
        java.security.spec.ECPoint eCPoint2 = eCPoint;
        object = eCPoint2.getAffineX();
        return eCCurve.createPoint((BigInteger)object, eCPoint2.getAffineY());
    }

    public static java.security.spec.ECPoint convertPoint(ECPoint eCPoint) {
        eCPoint = eCPoint.normalize();
        return new java.security.spec.ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger());
    }

    static {
        Object object;
        Object object2;
        customCurves = new HashMap();
        Object object3 = CustomNamedCurves.getNames();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object = ECNamedCurveTable.getByName((String)object2);
            if (object == null) continue;
            customCurves.put(((X9ECParameters)object).getCurve(), CustomNamedCurves.getByName((String)object2).getCurve());
        }
        Object object4 = object3 = CustomNamedCurves.getByName("Curve25519").getCurve();
        object2 = ((ECCurve)object4).getField().getCharacteristic();
        object = ((ECCurve)object4).getA().toBigInteger();
        BigInteger bigInteger = ((ECCurve)object4).getB().toBigInteger();
        BigInteger bigInteger2 = ((ECCurve)object4).getOrder();
        BigInteger bigInteger3 = ((ECCurve)object4).getCofactor();
        customCurves.put(new ECCurve.Fp((BigInteger)object2, (BigInteger)object, bigInteger, bigInteger2, bigInteger3), object3);
    }
}

