/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLDistPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DistributionPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DistributionPointName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TargetInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCRLStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertRevocationCheckerParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertStoreSelector;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXExtendedParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.exception.ExtCertPathValidatorException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.AnnotatedException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.CertPathValidatorUtilities;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.CertStatus;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PrincipalUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.ReasonsMask;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.PKIXAttrCertChecker;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509CertStoreSelector;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class RFC3281CertPathUtilities {
    private static final String TARGET_INFORMATION = Extension.targetInformation.getId();
    private static final String NO_REV_AVAIL = Extension.noRevAvail.getId();
    private static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    private static final String AUTHORITY_INFO_ACCESS = Extension.authorityInfoAccess.getId();

    public static void processAttrCert7(X509AttributeCertificate x509AttributeCertificate, CertPath certPath, CertPath certPath2, PKIXExtendedParameters set, Set object) {
        String string;
        set = x509AttributeCertificate.getCriticalExtensionOIDs();
        if (set.contains(string = TARGET_INFORMATION)) {
            try {
                TargetInformation.getInstance(CertPathValidatorUtilities.getExtensionValue(x509AttributeCertificate, string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", illegalArgumentException);
            }
            catch (AnnotatedException annotatedException) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", annotatedException);
            }
        }
        set.remove(string);
        object = object.iterator();
        while (object.hasNext()) {
            ((PKIXAttrCertChecker)object.next()).check(x509AttributeCertificate, certPath, certPath2, set);
        }
        if (set.isEmpty()) {
            return;
        }
        throw new CertPathValidatorException("Attribute certificate contains unsupported critical extensions: " + set);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkCRLs(X509AttributeCertificate object, PKIXExtendedParameters object2, X509Certificate x509Certificate, Date date, List list, JcaJceHelper jcaJceHelper) {
        boolean bl;
        AnnotatedException annotatedException;
        Object object3;
        Object object4;
        block23: {
            Object object52;
            block21: {
                ReasonsMask reasonsMask;
                CertStatus certStatus;
                PKIXExtendedParameters.Builder builder;
                ArrayList<PKIXCRLStore> arrayList;
                if (!((PKIXExtendedParameters)object2).isRevocationEnabled()) return;
                if (object.getExtensionValue(NO_REV_AVAIL) != null) {
                    if (object.getExtensionValue(CRL_DISTRIBUTION_POINTS) != null) throw new CertPathValidatorException("No rev avail extension is set, but also an AC revocation pointer.");
                    if (object.getExtensionValue(AUTHORITY_INFO_ACCESS) != null) throw new CertPathValidatorException("No rev avail extension is set, but also an AC revocation pointer.");
                    return;
                }
                try {
                    object52 = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue((X509Extension)object, CRL_DISTRIBUTION_POINTS));
                }
                catch (AnnotatedException annotatedException22) {
                    throw new CertPathValidatorException("CRL distribution point extension could not be read.", annotatedException22);
                }
                object4 = arrayList;
                ((ArrayList)object4)();
                try {
                    arrayList.addAll(CertPathValidatorUtilities.getAdditionalStoresFromCRLDistributionPoint((CRLDistPoint)object52, ((PKIXExtendedParameters)object2).getNamedCRLStoreMap(), date, jcaJceHelper));
                }
                catch (AnnotatedException annotatedException3) {
                    throw new CertPathValidatorException("No additional CRL locations could be decoded from CRL distribution point extension.", annotatedException3);
                }
                object3 = builder;
                builder = new PKIXExtendedParameters.Builder((PKIXExtendedParameters)object2);
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    ((PKIXExtendedParameters.Builder)object3).addCRLStore((PKIXCRLStore)object4);
                }
                object2 = ((PKIXExtendedParameters.Builder)object3).build();
                object4 = certStatus;
                certStatus = new CertStatus();
                object3 = reasonsMask;
                reasonsMask = new ReasonsMask();
                annotatedException = null;
                bl = false;
                if (object52 != null) {
                    object52 = object52.getDistributionPoints();
                    try {
                        for (int k = 0; k < ((DistributionPoint[])object52).length && ((CertStatus)object4).getCertStatus() == 11 && !((ReasonsMask)object3).isAllReasons(); ++k) {
                            PKIXExtendedParameters pKIXExtendedParameters = (PKIXExtendedParameters)((PKIXExtendedParameters)object2).clone();
                            RFC3281CertPathUtilities.checkCRL(object52[k], (X509AttributeCertificate)object, pKIXExtendedParameters, date, x509Certificate, (CertStatus)object4, (ReasonsMask)object3, list, jcaJceHelper);
                            bl = true;
                        }
                    }
                    catch (AnnotatedException annotatedException4) {
                        AnnotatedException annotatedException5;
                        annotatedException = annotatedException5;
                        annotatedException5 = new AnnotatedException("No valid CRL for distribution point found.", annotatedException4);
                    }
                    break block21;
                    catch (Exception exception) {
                        throw new ExtCertPathValidatorException("Distribution points could not be read.", exception);
                    }
                }
            }
            if (((CertStatus)object4).getCertStatus() == 11 && !((ReasonsMask)object3).isAllReasons()) {
                AnnotatedException annotatedException6;
                AnnotatedException annotatedException72222;
                block22: {
                    object52 = PrincipalUtils.getEncodedIssuerPrincipal(object);
                    {
                        DistributionPoint distributionPoint;
                        Object object6;
                        X509AttributeCertificate x509AttributeCertificate;
                        DistributionPoint distributionPoint2;
                        catch (Exception exception) {
                            throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", exception);
                        }
                        DistributionPoint distributionPoint3 = distributionPoint2;
                        try {
                            x509AttributeCertificate = object;
                            object6 = object2;
                            distributionPoint = distributionPoint3;
                        }
                        catch (AnnotatedException annotatedException72222) {
                            break block22;
                        }
                        distributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, (ASN1Encodable)object52))), null, null);
                        RFC3281CertPathUtilities.checkCRL(distributionPoint2, x509AttributeCertificate, (PKIXExtendedParameters)((PKIXExtendedParameters)object6).clone(), date, x509Certificate, (CertStatus)object4, (ReasonsMask)object3, list, jcaJceHelper);
                        bl = true;
                        break block23;
                    }
                }
                annotatedException = annotatedException6;
                annotatedException6 = new AnnotatedException("No valid CRL for distribution point found.", annotatedException72222);
            }
        }
        if (!bl) throw new ExtCertPathValidatorException("No valid CRL found.", annotatedException);
        if (((CertStatus)object4).getCertStatus() != 11) {
            object = e.a(b.a("Attribute certificate revocation after ").append(((CertStatus)object4).getRevocationDate()).toString(), ", reason: ").append(RFC3280CertPathUtilities.crlReasons[((CertStatus)object4).getCertStatus()]).toString();
            throw new CertPathValidatorException((String)object);
        }
        if (!((ReasonsMask)object3).isAllReasons() && ((CertStatus)object4).getCertStatus() == 11) {
            ((CertStatus)object4).setCertStatus(12);
        }
        if (((CertStatus)object4).getCertStatus() == 12) throw new CertPathValidatorException("Attribute certificate status could not be determined.");
    }

    public static void additionalChecks(X509AttributeCertificate x509AttributeCertificate, Set iterator, Set object) {
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (x509AttributeCertificate.getAttributes(string) == null) continue;
            throw new CertPathValidatorException(g.a("Attribute certificate contains prohibited attribute: ", string, "."));
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (x509AttributeCertificate.getAttributes((String)object) != null) continue;
            throw new CertPathValidatorException(g.a("Attribute certificate does not contain necessary attribute: ", (String)object, "."));
        }
    }

    public static void processAttrCert5(X509AttributeCertificate x509AttributeCertificate, PKIXExtendedParameters pKIXExtendedParameters) {
        try {
            x509AttributeCertificate.checkValidity(CertPathValidatorUtilities.getValidDate(pKIXExtendedParameters));
            return;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", certificateNotYetValidException);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", certificateExpiredException);
        }
    }

    public static void processAttrCert4(X509Certificate x509Certificate, Set set) {
        boolean bl = false;
        for (TrustAnchor trustAnchor : set) {
            if (!x509Certificate.getSubjectX500Principal().getName("RFC2253").equals(trustAnchor.getCAName()) && !((Object)x509Certificate).equals(trustAnchor.getTrustedCert())) continue;
            bl = true;
        }
        if (bl) {
            return;
        }
        throw new CertPathValidatorException("Attribute certificate issuer is not directly trusted.");
    }

    public static void processAttrCert3(X509Certificate x509Certificate, PKIXExtendedParameters object) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        object = blArray;
        if (!(blArray == null || ((Object)object).length > 0 && object[0] != false || ((Object)object).length > 1 && object[1] != false)) {
            throw new CertPathValidatorException("Attribute certificate issuer public key cannot be used to validate digital signatures.");
        }
        if (x509Certificate.getBasicConstraints() == -1) {
            return;
        }
        throw new CertPathValidatorException("Attribute certificate issuer is also a public key certificate issuer.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CertPathValidatorResult processAttrCert2(CertPath certPath, PKIXExtendedParameters pKIXExtendedParameters) {
        CertPathValidator certPathValidator;
        try {
            certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ExtCertPathValidatorException("Support class could not be created.", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ExtCertPathValidatorException("Support class could not be created.", noSuchProviderException);
        }
        try {
            return certPathValidator.validate(certPath, pKIXExtendedParameters);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new ExtCertPathValidatorException("Certification path for issuer certificate of attribute certificate could not be validated.", certPathValidatorException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CertPath processAttrCert1(X509AttributeCertificate object, PKIXExtendedParameters object2) {
        PKIXExtendedParameters.Builder builder;
        Object object3;
        HashSet hashSet;
        CertPathBuilderResult certPathBuilderResult = null;
        Object object4 = hashSet;
        hashSet = new HashSet();
        if (object.getHolder().getIssuer() != null) {
            Principal[] principalArray;
            object3 = principalArray;
            ((X509CertSelector)object3)();
            principalArray.setSerialNumber(object.getHolder().getSerialNumber());
            Principal[] principalArray2 = object.getHolder().getIssuer();
            for (int k = 0; k < principalArray2.length; ++k) {
                Principal principal;
                try {
                    principal = principalArray2[k];
                }
                catch (IOException iOException) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", iOException);
                }
                catch (AnnotatedException annotatedException) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", annotatedException);
                }
                {
                    if (principal instanceof X500Principal) {
                        ((X509CertSelector)object3).setIssuer(((X500Principal)principal).getEncoded());
                    }
                    object4.addAll(CertPathValidatorUtilities.findCertificates(new PKIXCertStoreSelector.Builder((CertSelector)object3).build(), ((PKIXExtendedParameters)object2).getCertStores()));
                }
            }
            if (((HashSet)object4).isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in base certificate ID for attribute certificate cannot be found.");
            }
        }
        if (object.getHolder().getEntityNames() != null) {
            X509CertStoreSelector x509CertStoreSelector;
            Object object5 = object;
            object = x509CertStoreSelector;
            x509CertStoreSelector = new X509CertStoreSelector();
            object3 = object5.getHolder().getEntityNames();
            for (int k = 0; k < ((Principal[])object3).length; ++k) {
                Principal principal;
                try {
                    principal = object3[k];
                }
                catch (IOException iOException) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", iOException);
                }
                catch (AnnotatedException annotatedException) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", annotatedException);
                }
                {
                    if (principal instanceof X500Principal) {
                        ((X509CertSelector)object).setIssuer(((X500Principal)principal).getEncoded());
                    }
                    object4.addAll(CertPathValidatorUtilities.findCertificates(new PKIXCertStoreSelector.Builder((CertSelector)object).build(), ((PKIXExtendedParameters)object2).getCertStores()));
                }
            }
            if (((HashSet)object4).isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in entity name for attribute certificate cannot be found.");
            }
        }
        object = builder;
        builder = new PKIXExtendedParameters.Builder((PKIXExtendedParameters)object2);
        object2 = null;
        object4 = ((HashSet)object4).iterator();
        while (object4.hasNext()) {
            CertPathBuilder certPathBuilder;
            X509CertStoreSelector x509CertStoreSelector;
            object3 = x509CertStoreSelector;
            ((X509CertStoreSelector)object3)();
            x509CertStoreSelector.setCertificate((X509Certificate)object4.next());
            ((PKIXExtendedParameters.Builder)object).setTargetConstraints(new PKIXCertStoreSelector.Builder((CertSelector)object3).build());
            try {
                certPathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ExtCertPathValidatorException("Support class could not be created.", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new ExtCertPathValidatorException("Support class could not be created.", noSuchProviderException);
            }
            try {
                certPathBuilderResult = certPathBuilder.build(new PKIXExtendedBuilderParameters.Builder(((PKIXExtendedParameters.Builder)object).build()).build());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
            }
            catch (CertPathBuilderException certPathBuilderException) {
                ExtCertPathValidatorException extCertPathValidatorException;
                object3 = extCertPathValidatorException;
                extCertPathValidatorException = new ExtCertPathValidatorException("Certification path for public key certificate of attribute certificate could not be build.", certPathBuilderException);
                object2 = object3;
            }
        }
        if (object2 == null) {
            return certPathBuilderResult.getCertPath();
        }
        throw object2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkCRL(DistributionPoint distributionPoint, X509AttributeCertificate x509AttributeCertificate, PKIXExtendedParameters pKIXExtendedParameters, Date date, X509Certificate x509Certificate, CertStatus certStatus, ReasonsMask reasonsMask, List list, JcaJceHelper jcaJceHelper) {
        Date date2;
        if (x509AttributeCertificate.getExtensionValue(X509Extensions.NoRevAvail.getId()) != null) {
            return;
        }
        Date date3 = date2;
        date2 = new Date(System.currentTimeMillis());
        if (date.getTime() > date3.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        boolean bl = false;
        Object var10_11 = null;
        Iterator iterator = CertPathValidatorUtilities.getCompleteCRLs(new PKIXCertRevocationCheckerParameters(pKIXExtendedParameters, date, null, -1, x509Certificate, null), distributionPoint, x509AttributeCertificate, date3, pKIXExtendedParameters).iterator();
        while (iterator.hasNext() && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            ReasonsMask reasonsMask2;
            X509CRL x509CRL;
            try {
                x509CRL = (X509CRL)iterator.next();
            }
            catch (AnnotatedException annotatedException) {
            }
            {
                reasonsMask2 = RFC3280CertPathUtilities.processCRLD(x509CRL, distributionPoint);
            }
            {
                if (!reasonsMask2.hasNewReasons(reasonsMask)) continue;
                X509CRL x509CRL2 = x509CRL;
                PublicKey publicKey = RFC3280CertPathUtilities.processCRLG(x509CRL2, RFC3280CertPathUtilities.processCRLF(x509CRL2, x509AttributeCertificate, null, null, pKIXExtendedParameters, list, jcaJceHelper));
                Object object = null;
                if (pKIXExtendedParameters.isUseDeltasEnabled()) {
                    PKIXExtendedParameters pKIXExtendedParameters2 = pKIXExtendedParameters;
                    object = pKIXExtendedParameters2.getCertStores();
                    object = RFC3280CertPathUtilities.processCRLH(CertPathValidatorUtilities.getDeltaCRLs(date3, x509CRL, object, pKIXExtendedParameters2.getCRLStores(), jcaJceHelper), publicKey);
                }
                if (pKIXExtendedParameters.getValidityModel() != 1 && x509AttributeCertificate.getNotAfter().getTime() < x509CRL.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                List<CertStore> list2 = object;
                RFC3280CertPathUtilities.processCRLB1(distributionPoint, x509AttributeCertificate, x509CRL);
                RFC3280CertPathUtilities.processCRLB2(distributionPoint, x509AttributeCertificate, x509CRL);
                RFC3280CertPathUtilities.processCRLC(list2, x509CRL, pKIXExtendedParameters);
                RFC3280CertPathUtilities.processCRLI(date, list2, x509AttributeCertificate, certStatus, pKIXExtendedParameters);
                RFC3280CertPathUtilities.processCRLJ(date, x509CRL, x509AttributeCertificate, certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonsMask.addReasons(reasonsMask2);
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        throw var10_11;
    }
}

