/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public class ECParameterSpec
implements AlgorithmParameterSpec {
    private ECCurve curve;
    private byte[] seed;
    private ECPoint G;
    private BigInteger n;
    private BigInteger h;

    public ECParameterSpec(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        ECParameterSpec eCParameterSpec = this;
        this.curve = eCCurve;
        this.G = eCPoint.normalize();
        eCParameterSpec.n = bigInteger;
        eCParameterSpec.h = BigInteger.valueOf(1L);
        eCParameterSpec.seed = null;
    }

    public ECParameterSpec(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        ECParameterSpec eCParameterSpec = this;
        this.curve = eCCurve;
        this.G = eCPoint.normalize();
        this.n = bigInteger;
        eCParameterSpec.h = bigInteger2;
        eCParameterSpec.seed = null;
    }

    public ECParameterSpec(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.curve = eCCurve;
        this.G = eCPoint.normalize();
        this.n = bigInteger;
        this.h = bigInteger2;
        this.seed = byArray;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.G;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ECParameterSpec)) {
            return false;
        }
        object = (ECParameterSpec)object;
        return this.getCurve().equals(((ECParameterSpec)object).getCurve()) && this.getG().equals(((ECParameterSpec)object).getG());
    }

    public int hashCode() {
        return this.getCurve().hashCode() ^ this.getG().hashCode();
    }
}

