/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.BENES;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.BENES12;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.BENES13;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.GF;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.GF12;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.GF13;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

class CMCEEngine {
    private int SYS_N;
    private int SYS_T;
    private int GFBITS;
    private int IRR_BYTES;
    private int COND_BYTES;
    private int PK_NROWS;
    private int PK_NCOLS;
    private int PK_ROW_BYTES;
    private int SYND_BYTES;
    private int GFMASK;
    private int[] poly;
    private final int defaultKeySize;
    private GF gf;
    private BENES benes;
    private boolean usePadding;
    private boolean countErrorIndices;
    private boolean usePivots;

    public CMCEEngine(int n, int n2, int n3, int[] nArray, boolean bl, int n4) {
        BENES bENES;
        CMCEEngine cMCEEngine = this;
        int n5 = n3;
        int n6 = n;
        this.usePivots = bl;
        this.SYS_N = n2;
        this.SYS_T = n3;
        this.GFBITS = n;
        this.poly = nArray;
        this.defaultKeySize = n4;
        this.IRR_BYTES = n3 * 2;
        n3 = 1 << n6 - 4;
        this.COND_BYTES = (n6 * 2 - 1) * n3;
        this.PK_NROWS = n3 = n5 * n;
        this.PK_NCOLS = n2 - n3;
        this.PK_ROW_BYTES = (this.PK_NCOLS + 7) / 8;
        cMCEEngine.SYND_BYTES = (n3 + 7) / 8;
        cMCEEngine.GFMASK = (1 << n) - 1;
        if (n == 12) {
            BENES12 bENES12;
            GF12 gF12;
            CMCEEngine cMCEEngine2 = this;
            GF12 gF122 = gF12;
            gF12 = new GF12(n);
            cMCEEngine2.gf = gF122;
            bENES = bENES12;
            CMCEEngine cMCEEngine3 = this;
            int n7 = cMCEEngine3.SYS_N;
            n3 = cMCEEngine3.SYS_T;
            int n8 = cMCEEngine3.GFBITS;
            bENES12 = new BENES12(n7, n3, n8);
            cMCEEngine2.benes = bENES;
        } else {
            BENES13 bENES13;
            GF13 gF13;
            CMCEEngine cMCEEngine4 = this;
            GF13 gF132 = gF13;
            gF13 = new GF13(n);
            cMCEEngine4.gf = gF132;
            bENES = bENES13;
            CMCEEngine cMCEEngine5 = this;
            int n9 = cMCEEngine5.SYS_N;
            n3 = cMCEEngine5.SYS_T;
            int n10 = cMCEEngine5.GFBITS;
            bENES13 = new BENES13(n9, n3, n10);
            cMCEEngine4.benes = bENES;
        }
        boolean bl2 = this.SYS_T % 8 != 0;
        this.usePadding = bl2;
        bl2 = 1 << this.GFBITS > this.SYS_N;
        this.countErrorIndices = bl2;
    }

    private void syndrome(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        CMCEEngine cMCEEngine = this;
        short[] sArray = new short[cMCEEngine.SYS_N / 8];
        int n2 = 0;
        int n3 = cMCEEngine.PK_NROWS % 8;
        for (n = 0; n < this.SYND_BYTES; ++n) {
            byArray[n] = 0;
        }
        for (n = 0; n < this.PK_NROWS; ++n) {
            int n4;
            int n5;
            for (n5 = 0; n5 < this.SYS_N / 8; ++n5) {
                sArray[n5] = 0;
            }
            for (n5 = 0; n5 < (n4 = this.PK_ROW_BYTES); ++n5) {
                n4 = this.SYS_N / 8 - n4 + n5;
                sArray[n4] = byArray2[n2 + n5];
            }
            if (this.usePadding) {
                for (n5 = this.SYS_N / 8 - 1; n5 >= this.SYS_N / 8 - this.PK_ROW_BYTES; --n5) {
                    sArray[n5] = (short)(((sArray[n5] & 0xFF) << n3 | (sArray[n5 - 1] & 0xFF) >>> 8 - n3) & 0xFF);
                }
            }
            n5 = n / 8;
            n4 = n % 8;
            sArray[n5] = (short)(sArray[n5] | 1 << n4);
            int n6 = 0;
            for (int k = 0; k < this.SYS_N / 8; ++k) {
                n6 = (byte)(n6 ^ sArray[k] & byArray3[k]);
            }
            int n7 = n2;
            int n8 = n6;
            byte by = (byte)(n8 ^ n8 >>> 4);
            byte by2 = (byte)(by ^ by >>> 2);
            n2 = (byte)((byte)(by2 ^ by2 >>> 1) & 1);
            byArray[n5] = (byte)(byArray[n5] | n2 << n4);
            n2 = n7 + this.PK_ROW_BYTES;
        }
    }

    private void generate_error_vector(byte[] byArray, SecureRandom secureRandom) {
        short s;
        int n;
        int n2 = this.SYS_T;
        short[] sArray = new short[n2 * 2];
        short[] sArray2 = new short[n2];
        byte[] byArray2 = new byte[n2];
        while (true) {
            int n3;
            int n4;
            if (this.countErrorIndices) {
                byte[] byArray3 = new byte[this.SYS_T * 4];
                secureRandom.nextBytes(byArray3);
                for (n4 = 0; n4 < this.SYS_T * 2; ++n4) {
                    n3 = n4 * 2;
                    sArray[n4] = Utils.load_gf(byArray3, n3, this.GFMASK);
                }
                n = 0;
                for (n4 = 0; n4 < (n3 = this.SYS_T) * 2 && n < n3; ++n4) {
                    n3 = sArray[n4];
                    if (n3 >= this.SYS_N) continue;
                    int n5 = n + 1;
                    sArray2[n] = n3;
                    n = n5;
                }
                if (n < n3) {
                    continue;
                }
            } else {
                byte[] byArray4 = new byte[this.SYS_T * 2];
                secureRandom.nextBytes(byArray4);
                for (n4 = 0; n4 < this.SYS_T; ++n4) {
                    n3 = n4 * 2;
                    sArray2[n4] = Utils.load_gf(byArray4, n3, this.GFMASK);
                }
            }
            n = 0;
            block4: for (n4 = 1; n4 < this.SYS_T && n != 1; ++n4) {
                for (n3 = 0; n3 < n4; ++n3) {
                    if (sArray2[n4] != sArray2[n3]) continue;
                    n = 1;
                    continue block4;
                }
            }
            if (n == 0) break;
        }
        for (s = 0; s < this.SYS_T; ++s) {
            byArray2[s] = (byte)(1 << (sArray2[s] & 7));
        }
        for (s = 0; s < this.SYS_N / 8; s = (short)((short)(s + 1))) {
            byArray[s] = 0;
            for (int k = 0; k < this.SYS_T; ++k) {
                short s2 = s;
                n = (short)((short)CMCEEngine.same_mask32(s2, (short)(sArray2[k] >> 3)) & 0xFF);
                byArray[s] = (byte)(byArray[s2] | byArray2[k] & n);
            }
        }
    }

    private void encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom secureRandom) {
        CMCEEngine cMCEEngine = this;
        cMCEEngine.generate_error_vector(byArray3, secureRandom);
        cMCEEngine.syndrome(byArray, byArray2, byArray3);
    }

    private int decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        CMCEEngine cMCEEngine = this;
        int n5 = cMCEEngine.SYS_T;
        short[] sArray = new short[n5 + 1];
        int n6 = cMCEEngine.SYS_N;
        int n7 = n5;
        short[] sArray2 = new short[n6];
        short[] sArray3 = new short[n7 * 2];
        short[] sArray4 = new short[n7 * 2];
        short[] sArray5 = new short[n7 + 1];
        short[] sArray6 = new short[n6];
        byte[] byArray4 = new byte[n6 / 8];
        for (n4 = 0; n4 < (n3 = this.SYND_BYTES); ++n4) {
            byArray4[n4] = byArray3[n4];
        }
        while (n3 < this.SYS_N / 8) {
            byArray4[n3] = 0;
            ++n3;
        }
        for (n2 = 0; n2 < (n4 = this.SYS_T); ++n2) {
            n4 = n2 * 2 + 40;
            sArray[n2] = Utils.load_gf(byArray2, n4, this.GFMASK);
        }
        sArray[n4] = 1;
        this.benes.support_gen(sArray2, byArray2);
        this.synd(sArray3, sArray, sArray2, byArray4);
        this.bm(sArray5, sArray3);
        this.root(sArray6, sArray5, sArray2);
        for (n = 0; n < this.SYS_N / 8; ++n) {
            byArray[n] = 0;
        }
        n = 0;
        for (n2 = 0; n2 < this.SYS_N; ++n2) {
            int n8 = n;
            n = (short)(this.gf.gf_iszero(sArray6[n2]) & 1);
            int n9 = n2 / 8;
            byArray[n9] = (byte)(byArray[n9] | n << n2 % 8);
            n = n8 + n;
        }
        CMCEEngine cMCEEngine2 = this;
        cMCEEngine2.synd(sArray4, sArray, sArray2, byArray);
        int n10 = n ^ cMCEEngine2.SYS_T;
        for (n = 0; n < this.SYS_T * 2; ++n) {
            n10 |= sArray3[n] ^ sArray4[n];
        }
        return n10 + -1 >> 15 & 1 ^ 1;
    }

    private static int min(short s, int n) {
        if (s < n) {
            return s;
        }
        return n;
    }

    private void bm(short[] sArray, short[] sArray2) {
        int n;
        int n2 = 0;
        int n3 = this.SYS_T;
        short[] sArray3 = new short[n3 + 1];
        short[] sArray4 = new short[n3 + 1];
        short[] sArray5 = new short[n3 + 1];
        short s = 1;
        for (n = 0; n < this.SYS_T + 1; ++n) {
            sArray5[n] = 0;
            sArray4[n] = 0;
        }
        sArray4[0] = 1;
        sArray5[1] = 1;
        n = 0;
        while (n < this.SYS_T * 2) {
            int n4;
            int n5;
            int n6;
            short s2 = 0;
            for (n6 = 0; n6 <= CMCEEngine.min((short)n, this.SYS_T); ++n6) {
                short s3 = s2;
                s2 = sArray4[n6];
                s2 = (short)(s3 ^ this.gf.gf_mul(s2, sArray2[n - n6]));
            }
            n6 = (short)((short)((short)((short)(s2 - 1) >> 15) & 1) - 1);
            short s4 = (short)((short)((short)((short)((short)(n - n2 * 2) >> 15) & 1) - 1) & n6);
            for (n5 = 0; n5 <= this.SYS_T; ++n5) {
                sArray3[n5] = sArray4[n5];
            }
            n5 = this.gf.gf_frac(s, s2);
            for (n4 = 0; n4 <= this.SYS_T; ++n4) {
                sArray4[n4] = (short)(sArray4[n4] ^ this.gf.gf_mul((short)n5, sArray5[n4]) & n6);
            }
            n6 = ~s4;
            n2 = (short)(n2 & n6 | ++n - n2 & s4);
            for (n5 = 0; n5 <= (n4 = this.SYS_T); ++n5) {
                sArray5[n5] = (short)(sArray5[n5] & n6 | sArray3[n5] & s4);
            }
            s = (short)(s & n6 | s2 & s4);
            while (n4 >= 1) {
                sArray5[n4] = sArray5[n4 - 1];
                --n4;
            }
            sArray5[0] = 0;
            n = (short)n;
        }
        for (int k = 0; k <= (n2 = this.SYS_T); ++k) {
            sArray[k] = sArray4[n2 - k];
        }
    }

    private void synd(short[] sArray, short[] sArray2, short[] sArray3, byte[] byArray) {
        int n;
        for (n = 0; n < this.SYS_T * 2; ++n) {
            sArray[n] = 0;
        }
        for (n = 0; n < this.SYS_N; ++n) {
            CMCEEngine cMCEEngine = this;
            short s = (short)(byArray[n / 8] >> n % 8 & 1);
            short s2 = cMCEEngine.eval(sArray2, sArray3[n]);
            GF gF = cMCEEngine.gf;
            short s3 = s2;
            s2 = gF.gf_inv(gF.gf_mul(s3, s3));
            for (int k = 0; k < this.SYS_T * 2; ++k) {
                GF gF2 = this.gf;
                short s4 = sArray[k];
                sArray[k] = gF2.gf_add(s4, gF2.gf_mul(s2, s));
                s2 = this.gf.gf_mul(s2, sArray3[n]);
            }
        }
    }

    private int mov_columns(byte[][] byArray, short[] sArray, long[] lArray) {
        int n;
        CMCEEngine cMCEEngine = this;
        long[] lArray2 = new long[64];
        long[] lArray3 = new long[32];
        long l = 1L;
        byte[] byArray2 = new byte[9];
        int n2 = cMCEEngine.PK_NROWS - 32;
        int n3 = n2 / 8;
        int n4 = n2 % 8;
        if (cMCEEngine.usePadding) {
            for (n = 0; n < 32; ++n) {
                long l2;
                int n5;
                for (n5 = 0; n5 < 9; ++n5) {
                    byArray2[n5] = byArray[n2 + n][n3 + n5];
                }
                n5 = 0;
                while (n5 < 8) {
                    byArray2[n5] = (byte)((byArray2[n5] & 0xFF) >> n4 | byArray2[++n5] << 8 - n4);
                }
                lArray2[n] = l2 = Utils.load8(byArray2, 0);
            }
        } else {
            for (n = 0; n < 32; ++n) {
                lArray2[n] = Utils.load8(byArray[n2 + n], n3);
            }
        }
        lArray[0] = 0L;
        n = 0;
        while (n < 32) {
            int n6;
            long l3;
            int n7;
            long l4 = lArray2[n];
            for (int k = n7 = n + 1; k < 32; ++k) {
                l4 |= lArray2[k];
            }
            if (l4 == 0L) {
                return -1;
            }
            int n8 = CMCEEngine.ctz(l4);
            lArray3[n] = l3 = (long)n8;
            lArray[0] = l3 = lArray[0] | l << (int)l3;
            for (n6 = n7; n6 < 32; ++n6) {
                long l5 = lArray2[n];
                l3 = l5;
                l3 = (l3 >> n8 & 1L) - 1L;
                lArray2[n] = l5 ^ lArray2[n6] & l3;
            }
            for (n6 = n7; n6 < 32; ++n6) {
                long l6 = lArray2[n6];
                l3 = l6;
                l3 = -(l3 >> n8 & 1L);
                lArray2[n6] = l6 ^ lArray2[n] & l3;
            }
            n = n7;
        }
        int n9 = 0;
        while (n9 < 32) {
            int n10;
            for (int k = n10 = n9 + 1; k < 64; ++k) {
                short[] sArray2 = sArray;
                int n11 = n2 + n9;
                n = n2 + k;
                long l7 = (long)(sArray2[n11] ^ sArray[n]) & CMCEEngine.same_mask64((short)k, (short)lArray3[n9]);
                sArray2[n11] = (short)((long)sArray2[n11] ^ l7);
                sArray[n] = (short)((long)sArray2[n] ^ l7);
            }
            n9 = n10;
        }
        for (int k = 0; k < this.PK_NROWS; ++k) {
            if (this.usePadding) {
                for (n9 = 0; n9 < 9; ++n9) {
                    byArray2[n9] = byArray[k][n3 + n9];
                }
                n9 = 0;
                while (n9 < 8) {
                    byArray2[n9] = (byte)((byArray2[n9] & 0xFF) >> n4 | byArray2[++n9] << 8 - n4);
                }
                l = Utils.load8(byArray2, 0);
            } else {
                l = Utils.load8(byArray[k], n3);
            }
            for (n9 = 0; n9 < 32; ++n9) {
                long l8 = l;
                long l9 = l;
                l = lArray3[n9];
                long l10 = (l8 >> n9 ^ l9 >> (int)l) & 1L;
                l = l8 ^ l10 << (int)l ^ l10 << n9;
            }
            if (this.usePadding) {
                Utils.store8(byArray2, 0, l);
                byte[] byArray3 = byArray[k];
                byte[] byArray4 = byArray3;
                int n12 = n3 + 8;
                int n13 = 8 - n4;
                byArray4[n12] = (byte)((byArray4[n12] & 0xFF) >>> n4 << n4 | (byArray2[7] & 0xFF) >>> n13);
                n12 = n3 + 0;
                byArray3[n12] = (byte)((byArray2[0] & 0xFF) << n4 | (byArray4[n3] & 0xFF) << n13 >>> n13);
                for (n9 = 7; n9 >= 1; --n9) {
                    n12 = n3 + n9;
                    byArray[k][n12] = (byte)((byArray2[n9] & 0xFF) << n4 | (byArray2[n9 - 1] & 0xFF) >>> n13);
                }
                continue;
            }
            Utils.store8(byArray[k], n3, l);
        }
        return 0;
    }

    private static int ctz(long l) {
        int n = 0;
        int n2 = 0;
        for (int k = 0; k < 64; ++k) {
            int n3 = n2;
            int n4 = n;
            n = (int)(l >> k & 1L);
            n2 = n4 | n;
            n = n3 + ((n2 ^ 1) & (n ^ 1));
            int n5 = n;
            n = n2;
            n2 = n5;
        }
        return n2;
    }

    private static long same_mask64(short s, short s2) {
        return -((long)(s ^ s2) - 1L >>> 63);
    }

    private static byte same_mask32(short s, short s2) {
        return (byte)(-((s ^ s2) + -1 >>> 31) & 0xFF);
    }

    private static void layer(short[] sArray, byte[] byArray, int n, int n2, int n3) {
        n2 = 1 << n2;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            for (int k = 0; k < n2; ++k) {
                short[] sArray2 = sArray;
                int n6 = n5 + k;
                short s = sArray[n6];
                int n7 = (s ^ sArray[n6 += n2]) & -(byArray[n + (n4 >> 3)] >> (n4 & 7) & 1);
                sArray2[n6] = (short)(s ^ n7);
                sArray2[n6] = (short)(sArray[n6] ^ n7);
                ++n4;
            }
            n5 = n2 * 2 + n5;
        }
    }

    private static void controlbitsfrompermutation(byte[] byArray, short[] sArray, long l, long l2) {
        int n;
        long l3 = l2;
        int[] nArray = new int[(int)(l3 * 2L)];
        int n2 = (int)l3;
        short[] sArray2 = new short[n2];
        do {
            n = 0;
            while ((long)n < ((l * 2L - 1L) * l2 / 2L + 7L) / 8L) {
                byArray[n] = 0;
                ++n;
            }
            CMCEEngine.cbrecursion(byArray, 0L, 1L, sArray, 0, l, l2, nArray);
            n = 0;
            while ((long)n < l2) {
                sArray2[n] = (short)n;
                ++n;
            }
            n = 0;
            int n3 = 0;
            while ((long)n3 < l) {
                CMCEEngine.layer(sArray2, byArray, n, n3, n2);
                n = (int)((long)n + (l2 >> 4));
                ++n3;
            }
            for (n3 = (int)(l - 2L); n3 >= 0; --n3) {
                CMCEEngine.layer(sArray2, byArray, n, n3, n2);
                n = (int)((long)n + (l2 >> 4));
            }
            n = 0;
            n3 = 0;
            while ((long)n3 < l2) {
                n = (short)(n | sArray[n3] ^ sArray2[n3]);
                ++n3;
            }
        } while (n != 0);
    }

    public static short get_q_short(int[] nArray, int n) {
        int n2 = n;
        n = n2 / 2;
        if (n2 % 2 == 0) {
            return (short)nArray[n];
        }
        return (short)((nArray[n] & 0xFFFF0000) >> 16);
    }

    public static void cbrecursion(byte[] byArray, long l, long l2, short[] sArray, int n, long l3, long l4, int[] nArray) {
        int n2;
        int n3;
        int n4;
        long l5;
        int n5;
        long l6;
        if (l3 == 1L) {
            int n6 = (int)(l >> 3);
            byArray[n6] = (byte)(byArray[n6] ^ CMCEEngine.get_q_short(nArray, n) << (int)(l & 7L));
            return;
        }
        if (sArray != null) {
            for (l6 = 0L; l6 < l4; ++l6) {
                n5 = (int)l6;
                nArray[n5] = (sArray[n5] ^ 1) << 16 | sArray[(int)(l6 ^ 1L)];
            }
        } else {
            for (l6 = 0L; l6 < l4; ++l6) {
                n5 = (int)l6;
                long l7 = n;
                nArray[n5] = (CMCEEngine.get_q_short(nArray, (int)(l7 + l6)) ^ 1) << 16 | CMCEEngine.get_q_short(nArray, (int)(l7 + (l6 ^ 1L)));
            }
        }
        int n7 = (int)l4;
        CMCEEngine.sort32(nArray, 0, n7);
        for (l5 = 0L; l5 < l4; ++l5) {
            int n8 = (int)l5;
            int n9 = nArray[n8] & 0xFFFF;
            if (l5 >= (long)n9) {
                n8 = n9;
            }
            int n10 = (int)(l4 + l5);
            nArray[n10] = n9 << 16 | n8;
        }
        for (l5 = 0L; l5 < l4; ++l5) {
            int n11 = (int)l5;
            nArray[n11] = (int)((long)(nArray[n11] << 16) | l5);
        }
        CMCEEngine.sort32(nArray, 0, n7);
        for (l5 = 0L; l5 < l4; ++l5) {
            int n12 = (int)l5;
            nArray[n12] = (nArray[n12] << 16) + (nArray[(int)(l4 + l5)] >> 16);
        }
        CMCEEngine.sort32(nArray, 0, n7);
        if (l3 <= 10L) {
            for (l5 = 0L; l5 < l4; ++l5) {
                int n13 = (int)(l4 + l5);
                nArray[n13] = (nArray[(int)l5] & 0xFFFF) << 10 | nArray[n13] & 0x3FF;
            }
            for (l5 = 1L; l5 < l3 - 1L; ++l5) {
                long l8;
                for (l8 = 0L; l8 < l4; ++l8) {
                    long l9 = l8;
                    n4 = (int)l9;
                    nArray[n4] = (int)((long)((nArray[(int)(l4 + l9)] & 0xFFFFFC00) << 6) | l8);
                }
                CMCEEngine.sort32(nArray, 0, n7);
                for (l8 = 0L; l8 < l4; ++l8) {
                    n4 = (int)l8;
                    nArray[n4] = nArray[n4] << 20 | nArray[(int)(l4 + l8)];
                }
                CMCEEngine.sort32(nArray, 0, n7);
                for (l8 = 0L; l8 < l4; ++l8) {
                    n4 = nArray[(int)l8];
                    n3 = n4 & 0xFFFFF;
                    n2 = n4 & 0xFFC00 | nArray[n4 = (int)(l4 + l8)] & 0x3FF;
                    if (n3 >= n2) {
                        n3 = n2;
                    }
                    nArray[n4] = n3;
                }
            }
            for (l5 = 0L; l5 < l4; ++l5) {
                int n14 = (int)(l4 + l5);
                nArray[n14] = nArray[n14] & 0x3FF;
            }
        } else {
            for (l5 = 0L; l5 < l4; ++l5) {
                int n15 = (int)(l4 + l5);
                nArray[n15] = nArray[(int)l5] << 16 | nArray[n15] & 0xFFFF;
            }
            for (l5 = 1L; l5 < l3 - 1L; ++l5) {
                long l10;
                for (l10 = 0L; l10 < l4; ++l10) {
                    long l11 = l10;
                    n4 = (int)l11;
                    nArray[n4] = (int)((long)(nArray[(int)(l4 + l11)] & 0xFFFF0000) | l10);
                }
                CMCEEngine.sort32(nArray, 0, n7);
                for (l10 = 0L; l10 < l4; ++l10) {
                    n4 = (int)l10;
                    nArray[n4] = nArray[n4] << 16 | nArray[(int)(l4 + l10)] & 0xFFFF;
                }
                if (l5 < l3 - 2L) {
                    for (l10 = 0L; l10 < l4; ++l10) {
                        int n16 = (int)(l4 + l10);
                        nArray[n16] = nArray[(int)l10] & 0xFFFF0000 | nArray[n16] >> 16;
                    }
                    CMCEEngine.sort32(nArray, n7, (int)(l4 * 2L));
                    for (l10 = 0L; l10 < l4; ++l10) {
                        n4 = (int)(l4 + l10);
                        nArray[n4] = nArray[n4] << 16 | nArray[(int)l10] & 0xFFFF;
                    }
                }
                CMCEEngine.sort32(nArray, 0, n7);
                for (l10 = 0L; l10 < l4; ++l10) {
                    n4 = (int)(l4 + l10);
                    n3 = nArray[n4];
                    n2 = n3 & 0xFFFF0000 | nArray[(int)l10] & 0xFFFF;
                    if (n2 >= n3) continue;
                    nArray[n4] = n2;
                }
            }
            for (l5 = 0L; l5 < l4; ++l5) {
                int n17 = (int)(l4 + l5);
                nArray[n17] = nArray[n17] & 0xFFFF;
            }
        }
        if (sArray != null) {
            for (l5 = 0L; l5 < l4; ++l5) {
                n = (int)l5;
                nArray[n] = (int)((long)(sArray[n] << 16) + l5);
            }
        } else {
            for (l5 = 0L; l5 < l4; ++l5) {
                int n18 = (int)l5;
                nArray[n18] = (int)((long)(CMCEEngine.get_q_short(nArray, (int)((long)n + l5)) << 16) + l5);
            }
        }
        CMCEEngine.sort32(nArray, 0, n7);
        long l12 = 0L;
        while (l12 < (l5 = l4 / 2L)) {
            long l13 = l12;
            l5 = l4 + (l12 *= 2L);
            int n19 = (int)l5;
            n = nArray[n19] & 1;
            int n20 = (int)(l12 + (long)n);
            n5 = n20 ^ 1;
            int n21 = (int)(l >> 3);
            byArray[n21] = (byte)(byArray[n21] ^ n << (int)(l & 7L));
            l += l2;
            nArray[n19] = nArray[(int)l12] << 16 | n20;
            n19 = (int)(l5 + 1L);
            nArray[n19] = nArray[(int)(l12 + 1L)] << 16 | n5;
            l12 = l13 + 1L;
        }
        l12 = l4 * 2L;
        CMCEEngine.sort32(nArray, n7, (int)l12);
        long l14 = l3 * 2L;
        l = (l14 - 3L) * l2 * l5 + l;
        long l15 = 0L;
        while (l15 < l5) {
            long l16 = l15;
            long l17 = l4 + (l15 *= 2L);
            int n22 = nArray[(int)l17];
            int n23 = n22 & 1;
            int n24 = (int)(l15 + (long)n23);
            int n25 = (int)(l >> 3);
            byArray[n25] = (byte)(byArray[n25] ^ n23 << (int)(l & 7L));
            l += l2;
            n25 = (int)l15;
            nArray[n25] = n24 << 16 | n22 & 0xFFFF;
            n25 = (int)(l15 + 1L);
            nArray[n25] = (n24 ^ 1) << 16 | nArray[(int)(l17 + 1L)] & 0xFFFF;
            l15 = l16 + 1L;
        }
        CMCEEngine.sort32(nArray, 0, n7);
        l -= (l14 - 2L) * l2 * l5;
        short[] sArray2 = new short[n7 * 4];
        l14 = 0L;
        while (l14 < l12) {
            long l18 = l14;
            long l19 = l14;
            l14 = l19 * 2L;
            int n26 = (int)(l14 + 0L);
            n3 = nArray[(int)l19];
            sArray2[n26] = (short)n3;
            int n27 = (int)(l14 + 1L);
            sArray2[n27] = (short)((n3 & 0xFFFF0000) >> 16);
            l14 = l18 + 1L;
        }
        for (l12 = 0L; l12 < l5; ++l12) {
            long l20 = l12;
            int n28 = (int)l20;
            long l21 = l20 * 2L;
            sArray2[n28] = (short)((nArray[(int)l21] & 0xFFFF) >>> 1);
            int n29 = (int)(l12 + l5);
            sArray2[n29] = (short)((nArray[(int)(l21 + 1L)] & 0xFFFF) >>> 1);
        }
        for (l12 = 0L; l12 < l5; ++l12) {
            int n30 = (int)(l4 / 4L + l4 + l12);
            long l22 = l12 * 2L;
            nArray[n30] = sArray2[(int)(l22 + 1L)] << 16 | sArray2[(int)l22];
        }
        l12 = l2 * 2L;
        l4 = l4 / 4L + l4;
        long l23 = l;
        long l24 = l;
        int n31 = (int)l4 * 2;
        l = l3 - 1L;
        CMCEEngine.cbrecursion(byArray, l24, l12, null, n31, l, l5, nArray);
        l2 = l23 + l2;
        n31 = (int)(l4 * 2L + l5);
        CMCEEngine.cbrecursion(byArray, l2, l12, null, n31, l, l5, nArray);
    }

    private int pk_gen(byte[] byArray, byte[] byArray2, int[] nArray, short[] sArray, long[] lArray) {
        block26: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = this.SYS_T;
            short[] sArray2 = new short[n8 + 1];
            short[] sArray3 = sArray2;
            sArray2[n8] = 1;
            for (n8 = 0; n8 < this.SYS_T; ++n8) {
                n7 = n8 * 2 + 40;
                sArray3[n8] = Utils.load_gf(byArray2, n7, this.GFMASK);
            }
            int n9 = 1 << this.GFBITS;
            long[] lArray2 = new long[n9];
            for (n7 = 0; n7 < 1 << this.GFBITS; ++n7) {
                long l;
                lArray2[n7] = l = (long)nArray[n7];
                lArray2[n7] = l <<= 31;
                lArray2[n7] = l |= (long)n7;
                lArray2[n7] = l & Long.MAX_VALUE;
            }
            CMCEEngine.sort64(lArray2, 0, n9);
            for (n9 = 1; n9 < 1 << this.GFBITS; ++n9) {
                if (lArray2[n9 - 1] >> 31 != lArray2[n9] >> 31) continue;
                return -1;
            }
            short[] sArray4 = new short[this.SYS_N];
            for (n6 = 0; n6 < 1 << this.GFBITS; ++n6) {
                sArray[n6] = (short)(lArray2[n6] & (long)this.GFMASK);
            }
            for (n6 = 0; n6 < (n5 = this.SYS_N); ++n6) {
                sArray4[n6] = Utils.bitrev(sArray[n6], this.GFBITS);
            }
            short[] sArray5 = new short[n5];
            this.root(sArray5, sArray3, sArray4);
            for (n5 = 0; n5 < (n4 = this.SYS_N); ++n5) {
                sArray5[n5] = this.gf.gf_inv(sArray5[n5]);
            }
            byte[][] byArray3 = new byte[this.PK_NROWS][n4 / 8];
            for (n4 = 0; n4 < this.PK_NROWS; ++n4) {
                for (n7 = 0; n7 < this.SYS_N / 8; ++n7) {
                    byArray3[n4][n7] = 0;
                }
            }
            for (n4 = 0; n4 < this.SYS_T; ++n4) {
                int n10;
                for (n7 = 0; n7 < this.SYS_N; n7 += 8) {
                    for (n10 = 0; n10 < (n3 = this.GFBITS); ++n10) {
                        byArray3[n4 * n3 + n10][n7 / 8] = n3 = (int)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)((byte)(sArray5[n7 + 7] >>> n10 & 1) << 1) | sArray5[n7 + 6] >>> n10 & 1) << 1) | sArray5[n7 + 5] >>> n10 & 1) << 1) | sArray5[n7 + 4] >>> n10 & 1) << 1) | sArray5[n7 + 3] >>> n10 & 1) << 1) | sArray5[n7 + 2] >>> n10 & 1) << 1) | sArray5[n7 + 1] >>> n10 & 1) << 1) | sArray5[n7 + 0] >>> n10 & 1));
                    }
                }
                for (n7 = 0; n7 < this.SYS_N; ++n7) {
                    n10 = sArray5[n7];
                    sArray5[n7] = this.gf.gf_mul((short)n10, sArray4[n7]);
                }
            }
            for (n2 = 0; n2 < ((n = this.PK_NROWS) + 7) / 8; ++n2) {
                for (n = 0; n < 8 && (n4 = n2 * 8 + n) < (n7 = this.PK_NROWS); ++n) {
                    byte by;
                    if (this.usePivots && n4 == n7 - 32 && this.mov_columns(byArray3, sArray, lArray) != 0) {
                        return -1;
                    }
                    for (n7 = n4 + 1; n7 < this.PK_NROWS; ++n7) {
                        by = -((byte)((byte)((byte)(byArray3[n4][n2] ^ byArray3[n7][n2]) >> n) & 1));
                        for (n3 = 0; n3 < this.SYS_N / 8; ++n3) {
                            byte[] byArray4 = byArray3[n4];
                            byArray4[n3] = (byte)(byArray4[n3] ^ byArray3[n7][n3] & by);
                        }
                    }
                    if ((byArray3[n4][n2] >> n & 1) == 0) {
                        return -1;
                    }
                    for (n7 = 0; n7 < this.PK_NROWS; ++n7) {
                        if (n7 == n4) continue;
                        by = -((byte)((byte)(byArray3[n7][n2] >> n) & 1));
                        for (n3 = 0; n3 < this.SYS_N / 8; ++n3) {
                            byte[] byArray5 = byArray3[n7];
                            byArray5[n3] = (byte)(byArray5[n3] ^ byArray3[n4][n3] & by);
                        }
                    }
                }
            }
            if (byArray == null) break block26;
            if (this.usePadding) {
                int n11;
                n2 = 0;
                n %= 8;
                for (int k = 0; k < (n11 = this.PK_NROWS); ++k) {
                    n11 = (n11 - 1) / 8;
                    while (n11 < this.SYS_N / 8 - 1) {
                        int n12 = n2++;
                        byte[] byArray6 = byArray3[k];
                        byArray[n12] = (byte)((byArray6[n11] & 0xFF) >>> n | byArray6[++n11] << 8 - n);
                    }
                    byArray[n2++] = (byte)((byArray3[k][n11] & 0xFF) >>> n);
                }
            } else {
                for (n2 = 0; n2 < this.PK_NROWS; ++n2) {
                    int n13;
                    n = 0;
                    for (int k = 0; k < ((n13 = this.SYS_N) - (n4 = this.PK_NROWS) + 7) / 8; ++k) {
                        n13 = (n13 - n4 + 7) / 8 * n2 + n;
                        byArray[n13] = byArray3[n2][n4 / 8 + k];
                        ++n;
                    }
                }
            }
        }
        return 0;
    }

    private short eval(short[] sArray, short s) {
        short s2 = sArray[this.SYS_T];
        for (int k = (v769427) - 1; k >= 0; --k) {
            CMCEEngine cMCEEngine = this;
            s2 = cMCEEngine.gf.gf_mul(s2, s);
            s2 = cMCEEngine.gf.gf_add(s2, sArray[k]);
        }
        return s2;
    }

    private void root(short[] sArray, short[] sArray2, short[] sArray3) {
        for (int k = 0; k < this.SYS_N; ++k) {
            sArray[k] = this.eval(sArray2, sArray3[k]);
        }
    }

    private int generate_irr_poly(short[] sArray) {
        int n;
        int n2;
        int n3 = this.SYS_T;
        short[][] sArray2 = new short[n3 + 1][n3];
        sArray2[0][0] = 1;
        for (n2 = 1; n2 < this.SYS_T; ++n2) {
            sArray2[0][n2] = 0;
        }
        for (n2 = 0; n2 < this.SYS_T; ++n2) {
            sArray2[1][n2] = sArray[n2];
        }
        for (n2 = 2; n2 <= this.SYS_T; ++n2) {
            short[] sArray3 = sArray2[n2];
            this.GF_mul(sArray3, sArray2[n2 - 1], sArray);
        }
        n2 = 0;
        while (n2 < this.SYS_T) {
            short[] sArray4;
            int n4;
            int n5;
            int n6;
            for (n6 = n5 = n2 + 1; n6 < this.SYS_T; ++n6) {
                n4 = this.gf.gf_iszero(sArray2[n2][n2]);
                for (int k = n2; k < this.SYS_T + 1; ++k) {
                    short[] sArray5 = sArray2[k];
                    sArray4 = sArray5;
                    sArray5[n2] = (short)(sArray4[n2] ^ sArray4[n6] & n4);
                }
            }
            n6 = sArray2[n2][n2];
            if (n6 == 0) {
                return -1;
            }
            n6 = this.gf.gf_inv((short)n6);
            for (n4 = n2; n4 < this.SYS_T + 1; ++n4) {
                short[] sArray6 = sArray2[n4];
                short[] sArray7 = sArray6;
                sArray6[n2] = this.gf.gf_mul(sArray7[n2], (short)n6);
            }
            for (n6 = 0; n6 < this.SYS_T; ++n6) {
                if (n6 == n2) continue;
                n4 = sArray2[n2][n6];
                for (int k = n2; k < this.SYS_T + 1; ++k) {
                    short[] sArray8 = sArray2[k];
                    sArray4 = sArray8;
                    sArray8[n6] = (short)(sArray4[n6] ^ this.gf.gf_mul(sArray4[n2], (short)n4));
                }
            }
            n2 = n5;
        }
        for (n2 = 0; n2 < (n = this.SYS_T); ++n2) {
            sArray[n2] = sArray2[n][n2];
        }
        return 0;
    }

    private void GF_mul(short[] sArray, short[] sArray2, short[] sArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        short[] sArray4 = new short[this.SYS_T * 2 - 1];
        for (n4 = 0; n4 < this.SYS_T * 2 - 1; ++n4) {
            sArray4[n4] = 0;
        }
        for (n4 = 0; n4 < (n3 = this.SYS_T); ++n4) {
            for (n3 = 0; n3 < this.SYS_T; ++n3) {
                short s = sArray2[n4];
                s = this.gf.gf_mul(s, sArray3[n3]);
                int n5 = n4 + n3;
                sArray4[n5] = (short)(sArray4[n5] ^ s);
            }
        }
        block3: for (n2 = (n3 - 1) * 2; n2 >= (n = this.SYS_T); --n2) {
            n = 0;
            while (true) {
                int[] nArray = this.poly;
                if (n == this.poly.length) continue block3;
                int n6 = nArray[n];
                if (n6 == 0 && this.GFBITS == 12) {
                    n6 = n2 - this.SYS_T;
                    sArray4[n6] = (short)(sArray4[n6] ^ this.gf.gf_mul(sArray4[n2], (short)2));
                } else {
                    n6 = n2 - this.SYS_T + n6;
                    sArray4[n6] = (short)(sArray4[n6] ^ sArray4[n2]);
                }
                ++n;
            }
        }
        System.arraycopy(sArray4, 0, sArray, 0, n);
        for (n2 = 0; n2 < this.SYS_T; ++n2) {
            sArray[n2] = sArray4[n2];
        }
    }

    private static void sort32(int[] nArray, int n, int n2) {
        if ((n2 -= n) < 2) {
            return;
        }
        int n3 = 1;
        while (n3 < n2 - n3) {
            int n4 = n3;
            n3 = n4 + n4;
        }
        for (int k = n3; k > 0; k >>>= 1) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            for (n9 = 0; n9 < n2 - k; ++n9) {
                if ((n9 & k) != 0) continue;
                int[] nArray2 = nArray;
                n8 = n + n9;
                n7 = n8 + k;
                n6 = nArray2[n7];
                n5 = nArray2[n8];
                int n10 = n8;
                n8 = n6 ^ n5;
                int n11 = n6 - n5;
                n8 = (n11 ^ n8 & (n11 ^ n6)) >> 31 & n8;
                nArray2[n10] = n5 ^ n8;
                nArray[n7] = nArray2[n7] ^ n8;
            }
            n9 = 0;
            for (n8 = n3; n8 > k; n8 >>>= 1) {
                while (n9 < n2 - n8) {
                    if ((n9 & k) == 0) {
                        n7 = n + n9;
                        n6 = n7 + k;
                        n5 = nArray[n6];
                        int n12 = n8;
                        while (n12 > k) {
                            int n13 = n12;
                            n12 = n7 + n12;
                            int n14 = nArray[n12];
                            int n15 = n12;
                            int n16 = n5;
                            int n17 = n5;
                            n5 = n14 ^ n5;
                            int n18 = n14 - n17;
                            n5 = (n18 ^ n5 & (n18 ^ n14)) >> 31 & n5;
                            n12 = n16 ^ n5;
                            nArray[n15] = n14 ^ n5;
                            int n19 = n5 = n13 >>> 1;
                            n5 = n12;
                            n12 = n19;
                        }
                        nArray[n6] = n5;
                    }
                    ++n9;
                }
            }
        }
    }

    private static void sort64(long[] lArray, int n, int n2) {
        if ((n2 -= n) < 2) {
            return;
        }
        int n3 = 1;
        while (n3 < n2 - n3) {
            int n4 = n3;
            n3 = n4 + n4;
        }
        for (int k = n3; k > 0; k >>>= 1) {
            int n5;
            int n6;
            int n7;
            for (n7 = 0; n7 < n2 - k; ++n7) {
                if ((n7 & k) != 0) continue;
                long[] lArray2 = lArray;
                n6 = n + n7;
                n5 = n6 + k;
                long l = lArray2[n5];
                long l2 = lArray2[n6];
                l = -(l - l2 >>> 63) & (l2 ^ l);
                lArray2[n6] = l2 ^ l;
                lArray[n5] = l = lArray2[n5] ^ l;
            }
            n7 = 0;
            for (n6 = n3; n6 > k; n6 >>>= 1) {
                while (n7 < n2 - n6) {
                    if ((n7 & k) == 0) {
                        n5 = n + n7;
                        int n8 = n5 + k;
                        long l = lArray[n8];
                        int n9 = n6;
                        while (n9 > k) {
                            int n10 = n9;
                            n9 = n5 + n9;
                            long l3 = lArray[n9];
                            long l4 = l;
                            l = -(l3 - l >>> 63) & (l ^ l3);
                            long l5 = l4 ^ l;
                            lArray[n9] = l3 ^ l;
                            int n11 = n10 >>> 1;
                            l = l5;
                            n9 = n11;
                        }
                        lArray[n8] = l;
                    }
                    ++n7;
                }
            }
        }
    }

    public int getIrrBytes() {
        return this.IRR_BYTES;
    }

    public int getCondBytes() {
        return this.COND_BYTES;
    }

    public int getPrivateKeySize() {
        CMCEEngine cMCEEngine = this;
        int n = cMCEEngine.COND_BYTES + this.IRR_BYTES;
        return cMCEEngine.SYS_N / 8 + n + 40;
    }

    public int getPublicKeySize() {
        if (this.usePadding) {
            CMCEEngine cMCEEngine = this;
            int n = cMCEEngine.PK_NROWS;
            return (cMCEEngine.SYS_N / 8 - (n - 1) / 8) * n;
        }
        return this.PK_NROWS * this.PK_NCOLS / 8;
    }

    public int getCipherTextSize() {
        return this.SYND_BYTES + 32;
    }

    public byte[] generate_public_key_from_private_key(byte[] byArray) {
        SHAKEDigest sHAKEDigest;
        SHAKEDigest sHAKEDigest2;
        CMCEEngine cMCEEngine = this;
        byte[] byArray2 = new byte[cMCEEngine.getPublicKeySize()];
        int n = cMCEEngine.GFBITS;
        short[] sArray = new short[1 << n];
        long[] lArray = new long[1];
        long[] lArray2 = lArray;
        lArray[0] = 0L;
        int[] nArray = new int[1 << n];
        int n2 = (1 << n) * 4 + cMCEEngine.SYS_N / 8;
        byte[] byArray3 = new byte[n2];
        n = n2 - 32 - this.IRR_BYTES - (1 << n) * 4;
        SHAKEDigest sHAKEDigest3 = sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest3(256);
        sHAKEDigest3.update((byte)64);
        sHAKEDigest2.update(byArray, 0, 32);
        sHAKEDigest.doFinal(byArray3, 0, n2);
        for (n2 = 0; n2 < 1 << this.GFBITS; ++n2) {
            nArray[n2] = Utils.load4(byArray3, n2 * 4 + n);
        }
        this.pk_gen(byArray2, byArray, nArray, sArray, lArray2);
        return byArray2;
    }

    public byte[] decompress_private_key(byte[] byArray) {
        int n;
        SHAKEDigest sHAKEDigest;
        CMCEEngine cMCEEngine = this;
        byte[] byArray2 = new byte[this.getPrivateKeySize()];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        n2 = cMCEEngine.SYS_N / 8;
        n2 = (1 << cMCEEngine.GFBITS) * 4 + n2 + this.IRR_BYTES + 32;
        byte[] byArray3 = new byte[n2];
        Object object = sHAKEDigest;
        SHAKEDigest sHAKEDigest2 = object;
        sHAKEDigest2(256);
        sHAKEDigest2.update((byte)64);
        object.update(byArray, 0, 32);
        sHAKEDigest.doFinal(byArray3, 0, n2);
        if (byArray.length <= 40) {
            int n3;
            CMCEEngine cMCEEngine2 = this;
            object = new short[cMCEEngine2.SYS_T];
            int n4 = cMCEEngine2.IRR_BYTES;
            byte[] byArray4 = new byte[n4];
            n4 = n2 - 32 - n4;
            for (n3 = 0; n3 < this.SYS_T; ++n3) {
                int n5 = n3 * 2 + n4;
                object[n3] = Utils.load_gf(byArray3, n5, this.GFMASK);
            }
            this.generate_irr_poly((short[])object);
            for (n4 = 0; n4 < this.SYS_T; ++n4) {
                n3 = n4 * 2;
                Utils.store_gf(byArray4, n3, (short)object[n4]);
            }
            int n6 = this.IRR_BYTES;
            System.arraycopy(byArray4, 0, byArray2, 40, n6);
        }
        if (byArray.length <= (n = this.IRR_BYTES) + 40) {
            int n7;
            int n8 = n2;
            n2 = this.GFBITS;
            object = new int[1 << n2];
            short[] sArray = new short[1 << n2];
            n = n8 - 32 - n - (1 << n2) * 4;
            for (n2 = 0; n2 < 1 << (n7 = this.GFBITS); ++n2) {
                object[n2] = Utils.load4(byArray3, n2 * 4 + n);
            }
            if (this.usePivots) {
                long[] lArray = new long[1];
                long[] lArray2 = lArray;
                lArray[0] = 0L;
                this.pk_gen(null, byArray2, (int[])object, sArray, lArray2);
            } else {
                n = 1 << n7;
                long[] lArray = new long[n];
                for (n7 = 0; n7 < 1 << this.GFBITS; ++n7) {
                    long l;
                    lArray[n7] = l = (long)object[n7];
                    lArray[n7] = l <<= 31;
                    lArray[n7] = l |= (long)n7;
                    lArray[n7] = l & Long.MAX_VALUE;
                }
                CMCEEngine.sort64(lArray, 0, n);
                for (n = 0; n < 1 << this.GFBITS; ++n) {
                    sArray[n] = (short)(lArray[n] & (long)this.GFMASK);
                }
            }
            n = this.COND_BYTES;
            byte[] byArray5 = new byte[n];
            int n9 = this.GFBITS;
            long l = n9;
            long l2 = 1 << n9;
            CMCEEngine.controlbitsfrompermutation(byArray5, sArray, l, l2);
            n9 = this.IRR_BYTES + 40;
            System.arraycopy(byArray5, 0, byArray2, n9, n);
        }
        CMCEEngine cMCEEngine3 = this;
        int n10 = cMCEEngine3.getPrivateKeySize();
        int n11 = cMCEEngine3.SYS_N;
        n = n11 / 8;
        System.arraycopy(byArray3, 0, byArray2, n10 -= n11 / 8, n);
        return byArray2;
    }

    public void kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        short[] sArray;
        int n;
        SHAKEDigest sHAKEDigest;
        CMCEEngine cMCEEngine = this;
        int n2 = 1;
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = byArray3;
        byte[] byArray5 = new byte[32];
        byArray3[0] = 64;
        secureRandom.nextBytes(byArray5);
        int n3 = cMCEEngine.SYS_N / 8;
        n3 = (1 << cMCEEngine.GFBITS) * 4 + n3;
        n3 = cMCEEngine.SYS_T * 2 + n3 + 32;
        byte[] byArray6 = new byte[n3];
        long[] lArray = new long[1];
        long[] lArray2 = lArray;
        lArray[0] = 0L;
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray7 = byArray5;
        while (true) {
            int n4;
            int n5;
            int n6;
            sHAKEDigest2.update(byArray4, 0, n2);
            sHAKEDigest2.update(byArray5, 0, byArray5.length);
            sHAKEDigest2.doFinal(byArray6, 0, n3);
            int n7 = n6 = n3 - 32;
            byArray5 = Arrays.copyOfRange(byArray6, n7, n7 + 32);
            System.arraycopy(byArray7, 0, byArray2, 0, 32);
            byArray7 = Arrays.copyOfRange(byArray5, 0, 32);
            int n8 = this.SYS_T;
            short[] sArray2 = new short[n8];
            int n9 = n6 - n8 * 2;
            for (n5 = 0; n5 < this.SYS_T; ++n5) {
                n4 = n5 * 2 + n9;
                sArray2[n5] = Utils.load_gf(byArray6, n4, this.GFMASK);
            }
            if (this.generate_irr_poly(sArray2) == -1) continue;
            n5 = 40;
            n4 = 0;
            while (n4 < this.SYS_T) {
                int n10 = n4++;
                int n11 = n10 * 2 + n5;
                Utils.store_gf(byArray2, n11, sArray2[n10]);
            }
            n = this.GFBITS;
            int[] nArray = new int[1 << n];
            n = n9 - (1 << n) * 4;
            for (n5 = 0; n5 < 1 << (n4 = this.GFBITS); ++n5) {
                nArray[n5] = Utils.load4(byArray6, n5 * 4 + n);
            }
            sArray = new short[1 << n4];
            if (this.pk_gen(byArray, byArray2, nArray, sArray, lArray2) != -1) break;
        }
        CMCEEngine cMCEEngine2 = this;
        int n12 = cMCEEngine2.COND_BYTES;
        byte[] byArray8 = new byte[n12];
        int n13 = this.GFBITS;
        long l = n13;
        long l2 = 1 << n13;
        CMCEEngine.controlbitsfrompermutation(byArray8, sArray, l, l2);
        n13 = this.IRR_BYTES + 40;
        System.arraycopy(byArray8, 0, byArray2, n13, n12);
        int n14 = cMCEEngine2.SYS_N;
        n13 = n14;
        n12 = n - n13 / 8;
        n13 = byArray2.length - n13 / 8;
        n2 = n14 / 8;
        System.arraycopy(byArray6, n12, byArray2, n13, n2);
        if (!this.usePivots) {
            Utils.store8(byArray2, 32, 0xFFFFFFFFL);
        } else {
            long l3 = lArray2[0];
            Utils.store8(byArray2, 32, l3);
        }
    }

    public int kem_enc(byte[] byArray, byte[] byArray2, byte[] object, SecureRandom secureRandom) {
        SHAKEDigest sHAKEDigest;
        CMCEEngine cMCEEngine = this;
        int n = cMCEEngine.SYS_N / 8;
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        if (cMCEEngine.usePadding) {
            n2 = this.check_pk_padding((byte[])object);
        }
        CMCEEngine cMCEEngine2 = this;
        cMCEEngine2.encrypt(byArray, (byte[])object, byArray3, secureRandom);
        Object object2 = object = (Object)sHAKEDigest;
        Object object3 = object;
        ((SHAKEDigest)object3)(256);
        object3.update((byte)2);
        object.update(byArray3, 0, n);
        object2.doFinal(byArray, this.SYND_BYTES, 32);
        object2.update((byte)1);
        object.update(byArray3, 0, n);
        object.update(byArray, 0, byArray.length);
        sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
        if (cMCEEngine2.usePadding) {
            byte by = (byte)((byte)n2 ^ 0xFF);
            for (int k = 0; k < this.SYND_BYTES + 32; ++k) {
                byArray[k] = (byte)(byArray[k] & by);
            }
            for (int k = 0; k < 32; ++k) {
                byArray2[k] = (byte)(byArray2[k] & by);
            }
            return n2;
        }
        return 0;
    }

    public int kem_dec(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        SHAKEDigest sHAKEDigest;
        int n;
        SHAKEDigest sHAKEDigest2;
        SHAKEDigest sHAKEDigest3;
        CMCEEngine cMCEEngine = sHAKEDigest5;
        byte[] byArray4 = new byte[32];
        int n2 = cMCEEngine.SYS_N / 8;
        byte[] byArray5 = new byte[n2];
        int n3 = 0;
        if (cMCEEngine.usePadding) {
            n3 = ((CMCEEngine)((Object)sHAKEDigest5)).check_c_padding(byArray2);
        }
        byte by = (byte)((CMCEEngine)((Object)sHAKEDigest5)).decrypt(byArray5, byArray3, byArray2);
        SHAKEDigest sHAKEDigest4 = sHAKEDigest3 = sHAKEDigest2;
        sHAKEDigest4(256);
        sHAKEDigest4.update((byte)2);
        sHAKEDigest3.update(byArray5, 0, n2);
        sHAKEDigest2.doFinal(byArray4, 0, 32);
        n2 = 0;
        for (n = 0; n < 32; ++n) {
            n2 = (byte)(n2 | byArray4[n] ^ byArray2[((CMCEEngine)((Object)sHAKEDigest5)).SYND_BYTES + n]);
        }
        CMCEEngine cMCEEngine2 = sHAKEDigest5;
        int n4 = (short)((short)((short)(by | n2) - 1) >> 8) & 0xFF;
        n2 = cMCEEngine2.SYS_N / 8 + 1;
        n2 = cMCEEngine2.SYND_BYTES + 32 + n2;
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = byArray6;
        byArray6[0] = (byte)(n4 & 1);
        n = 0;
        while (n < ((CMCEEngine)((Object)sHAKEDigest5)).SYS_N / 8) {
            int n5 = n + 1;
            byArray7[n5] = (byte)(~n4 & byArray3[n + 40 + ((CMCEEngine)((Object)sHAKEDigest5)).IRR_BYTES + ((CMCEEngine)((Object)sHAKEDigest5)).COND_BYTES] | n4 & byArray5[n]);
            n = n5;
        }
        for (int k = 0; k < ((CMCEEngine)((Object)sHAKEDigest5)).SYND_BYTES + 32; ++k) {
            n4 = ((CMCEEngine)((Object)sHAKEDigest5)).SYS_N / 8 + 1 + k;
            byArray7[n4] = byArray2[k];
        }
        CMCEEngine cMCEEngine3 = sHAKEDigest5;
        SHAKEDigest sHAKEDigest5 = sHAKEDigest;
        sHAKEDigest5(256);
        sHAKEDigest5.update(byArray7, 0, n2);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        if (cMCEEngine3.usePadding) {
            byte by2 = (byte)n3;
            for (int k = 0; k < byArray.length; ++k) {
                byArray[k] = (byte)(byArray[k] | by2);
            }
            return n3;
        }
        return 0;
    }

    public int check_pk_padding(byte[] byArray) {
        int n = 0;
        for (int k = 0; k < this.PK_NROWS; ++k) {
            int n2 = n;
            n = this.PK_ROW_BYTES;
            n = (byte)(n2 | byArray[k * n + n - 1]);
        }
        return (byte)(((byte)((byte)((n & 0xFF) >>> this.PK_NCOLS % 8) - 1) & 0xFF) >>> 7) - 1;
    }

    public int check_c_padding(byte[] byArray) {
        return (byte)(((byte)((byte)((byArray[this.SYND_BYTES - 1] & 0xFF) >>> this.PK_NROWS % 8) - 1) & 0xFF) >>> 7) - 1;
    }

    public int getDefaultSessionKeySize() {
        return this.defaultKeySize;
    }
}

