/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.Layer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import java.security.SecureRandom;

public class RainbowKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private boolean initialized = false;
    private SecureRandom sr;
    private RainbowKeyGenerationParameters rainbowParams;
    private short[][] A1;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2;
    private short[][] A2inv;
    private short[] b2;
    private int numOfLayers;
    private Layer[] layers;
    private int[] vi;
    private short[][] pub_quadratic;
    private short[][] pub_singular;
    private short[] pub_scalar;

    private void initializeDefault() {
        RainbowParameters rainbowParameters;
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = rainbowKeyGenerationParameters2;
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters2 = rainbowKeyGenerationParameters;
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        RainbowParameters rainbowParameters2 = rainbowParameters;
        rainbowParameters = new RainbowParameters();
        rainbowKeyGenerationParameters = new RainbowKeyGenerationParameters(secureRandom, rainbowParameters2);
        rainbowKeyPairGenerator.initialize(rainbowKeyGenerationParameters2);
    }

    private void keygen() {
        RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
        rainbowKeyPairGenerator.generateL1();
        rainbowKeyPairGenerator.generateL2();
        rainbowKeyPairGenerator.generateF();
        rainbowKeyPairGenerator.computePublicKey();
    }

    private void generateL1() {
        ComputeInField computeInField;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
        int[] nArray = rainbowKeyPairGenerator.vi;
        int n = rainbowKeyPairGenerator.vi[nArray.length - 1] - nArray[0];
        rainbowKeyPairGenerator.A1 = new short[n][n];
        rainbowKeyPairGenerator.A1inv = null;
        ComputeInField computeInField2 = computeInField;
        computeInField = new ComputeInField();
        while (this.A1inv == null) {
            for (int k = 0; k < n; ++k) {
                for (int i2 = 0; i2 < n; ++i2) {
                    this.A1[k][i2] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A1inv = computeInField2.inverse(this.A1);
        }
        this.b1 = new short[n];
        for (int k = 0; k < n; ++k) {
            this.b1[k] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateL2() {
        ComputeInField computeInField;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
        int n = rainbowKeyPairGenerator.vi[rainbowKeyPairGenerator.vi.length - 1];
        rainbowKeyPairGenerator.A2 = new short[n][n];
        rainbowKeyPairGenerator.A2inv = null;
        ComputeInField computeInField2 = computeInField;
        computeInField = new ComputeInField();
        while (this.A2inv == null) {
            for (int k = 0; k < n; ++k) {
                for (int i2 = 0; i2 < n; ++i2) {
                    this.A2[k][i2] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A2inv = computeInField2.inverse(this.A2);
        }
        this.b2 = new short[n];
        for (int k = 0; k < n; ++k) {
            this.b2[k] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateF() {
        this.layers = new Layer[this.numOfLayers];
        int n = 0;
        while (n < this.numOfLayers) {
            Layer layer;
            int n2 = n;
            Layer layer2 = layer;
            RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
            int n3 = rainbowKeyPairGenerator.vi[n];
            int n4 = rainbowKeyPairGenerator.vi[++n];
            SecureRandom secureRandom = rainbowKeyPairGenerator.sr;
            layer = new Layer(n3, n4, secureRandom);
            this.layers[n2] = layer2;
        }
    }

    private void computePublicKey() {
        Object object;
        int n;
        ComputeInField computeInField;
        ComputeInField computeInField2 = computeInField;
        computeInField = new ComputeInField();
        int[] nArray = this.vi;
        int n2 = nArray[nArray.length - 1] - nArray[0];
        int n3 = n = this.vi[nArray.length - 1];
        short[][][] sArray = new short[n2][n3][n3];
        this.pub_singular = new short[n2][n];
        this.pub_scalar = new short[n2];
        int n4 = 0;
        short[] cfr_ignored_0 = new short[n];
        int n5 = 0;
        while (true) {
            Object object2 = this.layers;
            if (n5 >= this.layers.length) break;
            object2 = object2[n5].getCoeffAlpha();
            short[][][] sArray2 = this.layers[n5].getCoeffBeta();
            RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
            object = rainbowKeyPairGenerator.layers[n5].getCoeffGamma();
            short[] sArray3 = rainbowKeyPairGenerator.layers[n5].getCoeffEta();
            int n6 = ((Layer)object2[0]).length;
            int n7 = sArray2[0].length;
            for (int k = 0; k < n6; ++k) {
                int n8;
                int n9;
                for (n9 = 0; n9 < n6; ++n9) {
                    for (n8 = 0; n8 < n7; ++n8) {
                        ComputeInField computeInField3 = computeInField2;
                        short s = n9 + n7;
                        short[] sArray4 = computeInField2.multVect((short)object2[k][n9][n8], this.A2[s]);
                        int n10 = n4 + k;
                        short[][] sArray5 = sArray[n10];
                        sArray[n10] = computeInField3.addSquareMatrix(sArray5, computeInField3.multVects(sArray4, this.A2[n8]));
                        sArray4 = computeInField2.multVect(this.b2[n8], sArray4);
                        sArray5 = this.pub_singular;
                        this.pub_singular[n10] = computeInField2.addVect(sArray4, sArray5[n10]);
                        sArray4 = computeInField2.multVect((short)object2[k][n9][n8], this.A2[n8]);
                        sArray4 = computeInField2.multVect(this.b2[s], sArray4);
                        sArray5 = this.pub_singular;
                        this.pub_singular[n10] = computeInField2.addVect(sArray4, sArray5[n10]);
                        s = GF2Field.multElem((short)object2[k][n9][n8], this.b2[s]);
                        this.pub_scalar[n10] = GF2Field.addElem(this.pub_scalar[n10], GF2Field.multElem(s, this.b2[n8]));
                    }
                }
                for (n9 = 0; n9 < n7; ++n9) {
                    for (n8 = 0; n8 < n7; ++n8) {
                        ComputeInField computeInField4 = computeInField2;
                        short[] sArray6 = computeInField2.multVect(sArray2[k][n9][n8], this.A2[n9]);
                        int n11 = n4 + k;
                        short[][] sArray7 = sArray[n11];
                        sArray[n11] = computeInField4.addSquareMatrix(sArray7, computeInField4.multVects(sArray6, this.A2[n8]));
                        sArray6 = computeInField2.multVect(this.b2[n8], sArray6);
                        sArray7 = this.pub_singular;
                        this.pub_singular[n11] = computeInField2.addVect(sArray6, sArray7[n11]);
                        sArray6 = computeInField2.multVect(sArray2[k][n9][n8], this.A2[n8]);
                        sArray6 = computeInField2.multVect(this.b2[n9], sArray6);
                        sArray7 = this.pub_singular;
                        this.pub_singular[n11] = computeInField2.addVect(sArray6, sArray7[n11]);
                        short s = GF2Field.multElem(sArray2[k][n9][n8], this.b2[n9]);
                        this.pub_scalar[n11] = GF2Field.addElem(this.pub_scalar[n11], GF2Field.multElem(s, this.b2[n8]));
                    }
                }
                for (n9 = 0; n9 < n7 + n6; ++n9) {
                    RainbowKeyPairGenerator rainbowKeyPairGenerator2 = this;
                    short[] sArray8 = computeInField2.multVect(object[k][n9], this.A2[n9]);
                    short[][] sArray9 = rainbowKeyPairGenerator2.pub_singular;
                    n8 = n4 + k;
                    rainbowKeyPairGenerator2.pub_singular[n8] = computeInField2.addVect(sArray8, sArray9[n8]);
                    rainbowKeyPairGenerator2.pub_scalar[n8] = GF2Field.addElem(rainbowKeyPairGenerator2.pub_scalar[n8], GF2Field.multElem(object[k][n9], this.b2[n9]));
                }
                n9 = n4 + k;
                this.pub_scalar[n9] = GF2Field.addElem(this.pub_scalar[n9], sArray3[k]);
            }
            n4 += n6;
            ++n5;
        }
        int n12 = n2;
        int n13 = n;
        short[][][] sArray10 = new short[n12][n13][n13];
        short[][] sArray11 = new short[n12][n];
        short[] sArray12 = new short[n12];
        for (int k = 0; k < n2; ++k) {
            int n14 = 0;
            while (true) {
                object = this.A1;
                if (n14 >= this.A1.length) break;
                ComputeInField computeInField5 = computeInField2;
                ComputeInField computeInField6 = computeInField2;
                short[][] sArray13 = object;
                object = sArray10[k];
                short s = sArray13[k][n14];
                sArray10[k] = computeInField6.addSquareMatrix((short[][])object, computeInField6.multMatrix(s, sArray[n14]));
                object = sArray11[k];
                sArray11[k] = computeInField5.addVect((short[])object, computeInField5.multVect(this.A1[k][n14], this.pub_singular[n14]));
                sArray12[k] = GF2Field.addElem(sArray12[k], GF2Field.multElem(this.A1[k][n14], this.pub_scalar[n14]));
                ++n14;
            }
            sArray12[k] = GF2Field.addElem(sArray12[k], this.b1[k]);
        }
        this.pub_singular = sArray11;
        this.pub_scalar = sArray12;
        this.compactPublicKey(sArray10);
    }

    private void compactPublicKey(short[][][] sArray) {
        int n = sArray.length;
        int n2 = sArray[0].length;
        this.pub_quadratic = new short[n][(n2 + 1) * n2 / 2];
        for (int k = 0; k < n; ++k) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = i2; i3 < n2; ++i3) {
                    if (i3 == i2) {
                        this.pub_quadratic[k][n3] = sArray[k][i2][i3];
                    } else {
                        short[][] sArray2 = sArray[k];
                        this.pub_quadratic[k][n3] = GF2Field.addElem(sArray2[i2][i3], sArray2[i3][i2]);
                    }
                    ++n3;
                }
            }
        }
    }

    public AsymmetricCipherKeyPair genKeyPair() {
        RainbowPublicKeyParameters rainbowPublicKeyParameters;
        RainbowPrivateKeyParameters rainbowPrivateKeyParameters;
        if (!((RainbowKeyPairGenerator)object3).initialized) {
            ((RainbowKeyPairGenerator)object3).initializeDefault();
        }
        ((RainbowKeyPairGenerator)object3).keygen();
        RainbowPrivateKeyParameters rainbowPrivateKeyParameters2 = rainbowPrivateKeyParameters;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = object3;
        Object object = rainbowKeyPairGenerator.A1inv;
        Object object2 = rainbowKeyPairGenerator.b1;
        short[][] sArray = rainbowKeyPairGenerator.A2inv;
        short[] sArray2 = rainbowKeyPairGenerator.b2;
        int[] nArray = rainbowKeyPairGenerator.vi;
        Layer[] layerArray = rainbowKeyPairGenerator.layers;
        rainbowPrivateKeyParameters = new RainbowPrivateKeyParameters((short[][])object, (short[])object2, sArray, sArray2, nArray, layerArray);
        object = rainbowPublicKeyParameters;
        RainbowKeyPairGenerator rainbowKeyPairGenerator2 = object3;
        Object object3 = rainbowKeyPairGenerator2.vi;
        int n = rainbowKeyPairGenerator2.vi[rainbowKeyPairGenerator2.vi.length - 1] - object3[0];
        object2 = rainbowKeyPairGenerator2.pub_quadratic;
        sArray = rainbowKeyPairGenerator2.pub_singular;
        sArray2 = rainbowKeyPairGenerator2.pub_scalar;
        rainbowPublicKeyParameters = new RainbowPublicKeyParameters(n, (short[][])object2, sArray, sArray2);
        return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)object, rainbowPrivateKeyParameters2);
    }

    public void initialize(KeyGenerationParameters keyGenerationParameters) {
        RainbowKeyPairGenerator rainbowKeyPairGenerator = rainbowKeyGenerationParameters;
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters = (RainbowKeyGenerationParameters)keyGenerationParameters;
        rainbowKeyPairGenerator.rainbowParams = rainbowKeyGenerationParameters;
        rainbowKeyPairGenerator.sr = rainbowKeyGenerationParameters.getRandom();
        rainbowKeyPairGenerator.vi = rainbowKeyPairGenerator.rainbowParams.getParameters().getVi();
        rainbowKeyPairGenerator.numOfLayers = rainbowKeyPairGenerator.rainbowParams.getParameters().getNumOfLayers();
        rainbowKeyPairGenerator.initialized = true;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

