/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

final class HashTreeAddress
extends XMSSAddress {
    private static final int TYPE = 2;
    private static final int PADDING = 0;
    private final int padding;
    private final int treeHeight;
    private final int treeIndex;

    private HashTreeAddress(Builder builder) {
        super(builder);
        this.padding = 0;
        this.treeHeight = builder.treeHeight;
        this.treeIndex = builder.treeIndex;
    }

    public /* synthetic */ HashTreeAddress(Builder builder, 1 var2_2) {
        this(builder);
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        HashTreeAddress hashTreeAddress = this;
        Pack.intToBigEndian(hashTreeAddress.padding, byArray, 16);
        Pack.intToBigEndian(hashTreeAddress.treeHeight, byArray, 20);
        Pack.intToBigEndian(hashTreeAddress.treeIndex, byArray, 24);
        return byArray;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getTreeHeight() {
        return this.treeHeight;
    }

    public int getTreeIndex() {
        return this.treeIndex;
    }

    public static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int treeHeight = 0;
        private int treeIndex = 0;

        public Builder() {
            super(2);
        }

        public Builder withTreeHeight(int n) {
            this.treeHeight = n;
            return this;
        }

        public Builder withTreeIndex(int n) {
            this.treeIndex = n;
            return this;
        }

        @Override
        public XMSSAddress build() {
            return new HashTreeAddress(this, null);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

