/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;

public final class BigIntUtils {
    private BigIntUtils() {
    }

    public static boolean equals(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n = 0;
        if (bigIntegerArray.length != bigIntegerArray2.length) {
            return false;
        }
        for (int k = 0; k < bigIntegerArray.length; ++k) {
            n |= bigIntegerArray[k].compareTo(bigIntegerArray2[k]);
        }
        return n == 0;
    }

    public static void fill(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        for (int k = bigIntegerArray.length - 1; k >= 0; --k) {
            bigIntegerArray[k] = bigInteger;
        }
    }

    public static BigInteger[] subArray(BigInteger[] bigIntegerArray, int n, int n2) {
        BigInteger[] bigIntegerArray2 = new BigInteger[n2 -= n];
        System.arraycopy(bigIntegerArray, n, bigIntegerArray2, 0, n2);
        return bigIntegerArray2;
    }

    public static int[] toIntArray(BigInteger[] bigIntegerArray) {
        int[] nArray = new int[bigIntegerArray.length];
        for (int k = 0; k < bigIntegerArray.length; ++k) {
            nArray[k] = bigIntegerArray[k].intValue();
        }
        return nArray;
    }

    public static int[] toIntArrayModQ(int n, BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.valueOf(n);
        int[] nArray = new int[bigIntegerArray.length];
        for (int k = 0; k < bigIntegerArray.length; ++k) {
            nArray[k] = bigIntegerArray[k].mod(bigInteger).intValue();
        }
        return nArray;
    }

    public static byte[] toMinimalByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length != 1 && (bigInteger.bitLength() & 7) == 0) {
            int n = bigInteger.bitLength() >> 3;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }
}

