/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.bouncycastle.jce.ECPointUtil;
import com.fis.ekyc.nfc.build_in.cvc.AbstractSequence;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationField;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRole;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleEnum;
import com.fis.ekyc.nfc.build_in.cvc.ByteField;
import com.fis.ekyc.nfc.build_in.cvc.CVCAuthorizationTemplate;
import com.fis.ekyc.nfc.build_in.cvc.CVCObject;
import com.fis.ekyc.nfc.build_in.cvc.CVCPublicKey;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import com.fis.ekyc.nfc.build_in.cvc.CVCertificateBody;
import com.fis.ekyc.nfc.build_in.cvc.GenericPublicKeyField;
import com.fis.ekyc.nfc.build_in.cvc.IntegerField;
import com.fis.ekyc.nfc.build_in.cvc.OIDField;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PublicKeyEC
extends CVCPublicKey
implements ECPublicKey {
    public static final long serialVersionUID = 1L;
    public static final byte UNCOMPRESSED_POINT_TAG = 4;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.MODULUS, CVCTagEnum.COEFFICIENT_A, CVCTagEnum.COEFFICIENT_B, CVCTagEnum.BASE_POINT_G, CVCTagEnum.BASE_POINT_R_ORDER, CVCTagEnum.PUBLIC_POINT_Y, CVCTagEnum.COFACTOR_F};

    public PublicKeyEC(GenericPublicKeyField genericPublicKeyField) {
        this.addSubfield(genericPublicKeyField.getSubfield(CVCTagEnum.OID));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.MODULUS));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.COEFFICIENT_A));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.COEFFICIENT_B));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.BASE_POINT_G));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.BASE_POINT_R_ORDER));
        this.addSubfield(genericPublicKeyField.getSubfield(CVCTagEnum.PUBLIC_POINT_Y));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.COFACTOR_F));
    }

    public PublicKeyEC(OIDField object, ECPublicKey eCPublicKey, AuthorizationRole authorizationRole) {
        PublicKeyEC publicKeyEC = cVCObject;
        publicKeyEC.addSubfield((CVCObject)object);
        object = eCPublicKey.getParams();
        boolean bl = authorizationRole == null || authorizationRole.isCVCA();
        if (bl) {
            ECField eCField = ((ECParameterSpec)object).getCurve().getField();
            if (eCField instanceof ECFieldFp) {
                eCField = (ECFieldFp)eCField;
                cVCObject.addSubfield(new ByteField(CVCTagEnum.MODULUS, CVCObject.trimByteArray(((ECFieldFp)eCField).getP().toByteArray())));
            }
            PublicKeyEC publicKeyEC2 = cVCObject;
            publicKeyEC2.addSubfield(new ByteField(CVCTagEnum.COEFFICIENT_A, CVCObject.trimByteArray(((ECParameterSpec)object).getCurve().getA().toByteArray())));
            publicKeyEC2.addSubfield(new ByteField(CVCTagEnum.COEFFICIENT_B, CVCObject.trimByteArray(((ECParameterSpec)object).getCurve().getB().toByteArray())));
            publicKeyEC2.addSubfield(new ByteField(CVCTagEnum.BASE_POINT_G, PublicKeyEC.encodePoint(((ECParameterSpec)object).getGenerator(), ((ECParameterSpec)object).getCurve())));
            publicKeyEC2.addSubfield(new ByteField(CVCTagEnum.BASE_POINT_R_ORDER, CVCObject.trimByteArray(((ECParameterSpec)object).getOrder().toByteArray())));
        }
        cVCObject.addSubfield(new ByteField(CVCTagEnum.PUBLIC_POINT_Y, PublicKeyEC.encodePoint(eCPublicKey.getW(), ((ECParameterSpec)object).getCurve())));
        if (bl) {
            IntegerField integerField;
            PublicKeyEC publicKeyEC3 = cVCObject;
            CVCObject cVCObject = integerField;
            Object object2 = object;
            object = CVCTagEnum.COFACTOR_F;
            integerField = new IntegerField((CVCTagEnum)((Object)object), ((ECParameterSpec)object2).getCofactor());
            publicKeyEC3.addSubfield(cVCObject);
        }
    }

    public PublicKeyEC(OIDField oIDField, ECPublicKey eCPublicKey, AuthorizationRoleEnum authorizationRoleEnum) {
        this(oIDField, eCPublicKey, (AuthorizationRole)authorizationRoleEnum);
    }

    public static byte[] encodePoint(ECPoint object, EllipticCurve ellipticCurve) {
        ECPoint eCPoint = object;
        object = CVCObject.trimByteArray(eCPoint.getAffineX().toByteArray());
        byte[] byArray = CVCObject.trimByteArray(eCPoint.getAffineY().toByteArray());
        int n = ellipticCurve != null ? ellipticCurve.getField().getFieldSize() + 7 >> 3 : (((Object)object).length > byArray.length ? ((Object)object).length : byArray.length);
        int n2 = 0;
        int n3 = 0;
        if (((Object)object).length < n) {
            n2 = n - ((Object)object).length;
        }
        if (byArray.length < n) {
            n3 = n - byArray.length;
        }
        byte[] byArray2 = new byte[(n << 1) + 1];
        int n4 = n;
        int n5 = n;
        Arrays.fill(byArray2, (byte)0);
        byArray2[0] = 4;
        int n6 = n2 + 1;
        System.arraycopy(object, 0, byArray2, n6, n -= n2);
        n6 = n5 + 1 + n3;
        n = n4 - n3;
        System.arraycopy(byArray, 0, byArray2, n6, n);
        return byArray2;
    }

    public static ECPoint decodePoint(byte[] object) {
        if (object[0] == 4) {
            BigInteger bigInteger;
            int n = (((byte[])object).length - 1) / 2;
            object = new byte[n];
            int n2 = (((byte[])object).length - 1) / 2;
            byte[] byArray = new byte[n2];
            System.arraycopy(object, 1, object, 0, n);
            System.arraycopy(object, n + 1, byArray, 0, n2);
            BigInteger bigInteger2 = new BigInteger(1, (byte[])object);
            object = bigInteger;
            bigInteger = new BigInteger(1, byArray);
            return new ECPoint(bigInteger2, (BigInteger)object);
        }
        throw new IllegalArgumentException("First byte must be 0x4");
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    @Override
    public List<CVCObject> getEncodableFields() {
        boolean bl;
        ECParameterSpec eCParameterSpec;
        boolean bl2;
        ArrayList<CVCObject> arrayList;
        block24: {
            block26: {
                CVCObject cVCObject;
                block25: {
                    block27: {
                        ArrayList<CVCObject> arrayList2;
                        PublicKeyEC publicKeyEC = this;
                        arrayList = arrayList2;
                        arrayList();
                        arrayList2.add(this.getSubfield(CVCTagEnum.OID));
                        bl2 = false;
                        eCParameterSpec = publicKeyEC.getParams();
                        if (eCParameterSpec == null) break block24;
                        cVCObject = this.getParent();
                        if (cVCObject == null) break block25;
                        if (cVCObject.getTag() != CVCTagEnum.CERTIFICATE_BODY) break block25;
                        try {
                            cVCObject = ((CVCertificateBody)cVCObject).getOptionalSubfield(CVCTagEnum.HOLDER_AUTH_TEMPLATE);
                            if (cVCObject == null) break block26;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {}
                        cVCObject = ((CVCAuthorizationTemplate)cVCObject).getAuthorizationField();
                        if (cVCObject == null) break block27;
                        if (((AuthorizationField)cVCObject).getAuthRole().isCVCA()) break block26;
                    }
                    bl2 = false;
                    break block24;
                }
                if (cVCObject != null) break block24;
            }
            bl2 = true;
        }
        if (bl2) {
            block28: {
                if (!(eCParameterSpec.getCurve().getField() instanceof ECFieldFp)) break block28;
                arrayList.add(this.getSubfield(CVCTagEnum.MODULUS));
            }
            ArrayList<CVCObject> arrayList3 = arrayList;
            PublicKeyEC publicKeyEC = this;
            ArrayList<CVCObject> arrayList4 = arrayList;
            PublicKeyEC publicKeyEC2 = this;
            ArrayList<CVCObject> arrayList5 = arrayList;
            PublicKeyEC publicKeyEC3 = this;
            arrayList.add(this.getSubfield(CVCTagEnum.COEFFICIENT_A));
            arrayList5.add(publicKeyEC3.getSubfield(CVCTagEnum.COEFFICIENT_B));
            arrayList4.add(publicKeyEC2.getSubfield(CVCTagEnum.BASE_POINT_G));
            arrayList3.add(publicKeyEC.getSubfield(CVCTagEnum.BASE_POINT_R_ORDER));
        }
        try {
            bl = bl2;
            arrayList.add(this.getSubfield(CVCTagEnum.PUBLIC_POINT_Y));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
        if (bl) {
            arrayList.add(this.getSubfield(CVCTagEnum.COFACTOR_F));
        }
        return arrayList;
    }

    @Override
    public String getAlgorithm() {
        return "ECDSA";
    }

    @Override
    public String getFormat() {
        return "CVC";
    }

    @Override
    public ECParameterSpec getParams() {
        Object object = null;
        Serializable serializable = (ByteField)((AbstractSequence)object2).getOptionalSubfield(CVCTagEnum.MODULUS);
        PublicKeyEC publicKeyEC = object2;
        Object object2 = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.COEFFICIENT_A);
        ByteField byteField = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.COEFFICIENT_B);
        ByteField byteField2 = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.BASE_POINT_G);
        ByteField byteField3 = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.BASE_POINT_R_ORDER);
        IntegerField integerField = (IntegerField)publicKeyEC.getOptionalSubfield(CVCTagEnum.COFACTOR_F);
        if (serializable != null) {
            BigInteger bigInteger;
            ECParameterSpec eCParameterSpec;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            EllipticCurve ellipticCurve;
            object = ellipticCurve;
            ECFieldFp eCFieldFp = new ECFieldFp(new BigInteger(1, serializable.getData()));
            serializable = bigInteger3;
            bigInteger3 = new BigInteger(1, ((ByteField)object2).getData());
            object2 = bigInteger2;
            bigInteger2 = new BigInteger(1, byteField.getData());
            ellipticCurve = new EllipticCurve(eCFieldFp, (BigInteger)serializable, (BigInteger)object2);
            object2 = eCParameterSpec;
            EllipticCurve ellipticCurve2 = object;
            object = ECPointUtil.decodePoint((EllipticCurve)object, byteField2.getData());
            serializable = bigInteger;
            bigInteger = new BigInteger(1, byteField3.getData());
            int n = integerField.getValue();
            eCParameterSpec = new ECParameterSpec(ellipticCurve2, (ECPoint)object, (BigInteger)serializable, n);
            object = object2;
        }
        return object;
    }

    @Override
    public ECPoint getW() {
        try {
            return PublicKeyEC.decodePoint(((ByteField)this.getSubfield(CVCTagEnum.PUBLIC_POINT_Y)).getData());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
    }
}

