/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class FragmentBuffer
implements Serializable {
    private static final long serialVersionUID = -3510872461790499721L;
    private static final int DEFAULT_SIZE = 2000;
    private byte[] buffer;
    private Collection<Fragment> fragments;

    public FragmentBuffer() {
        this(2000);
    }

    public FragmentBuffer(int n) {
        FragmentBuffer fragmentBuffer = this;
        fragmentBuffer.buffer = new byte[n];
        fragmentBuffer.fragments = new HashSet<Fragment>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setLength(int n) {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            byte[] byArray = fragmentBuffer.buffer;
            {
                if (n <= fragmentBuffer.buffer.length) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
                }
                byte[] byArray2 = new byte[n];
                int n2 = 0;
                int n3 = 0;
                int n4 = byArray.length;
                System.arraycopy(byArray, n2, byArray2, n3, n4);
                this.buffer = byArray2;
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
        }
    }

    public synchronized void updateFrom(FragmentBuffer fragmentBuffer) {
        for (Fragment fragment : fragmentBuffer.fragments) {
            int n = fragment.offset;
            byte[] byArray = fragmentBuffer.buffer;
            int n2 = fragment.offset;
            int n3 = fragment.length;
            this.addFragment(n, byArray, n2, n3);
        }
    }

    public synchronized void addFragment(int n, byte by) {
        FragmentBuffer fragmentBuffer = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = by;
        fragmentBuffer.addFragment(n, (byte[])object);
    }

    public synchronized void addFragment(int n, byte[] byArray) {
        int n2 = byArray.length;
        this.addFragment(n, byArray, 0, n2);
    }

    public synchronized void addFragment(int n, byte[] object, int n2, int n3) {
        int n4 = n + n3;
        byte[] byArray = this.buffer;
        if (n4 > this.buffer.length) {
            this.setLength(Math.max(n4, byArray.length) * 2);
        }
        System.arraycopy(object, n2, this.buffer, n, n3);
        object = new ArrayList<Fragment>(this.fragments).iterator();
        while (object.hasNext()) {
            Fragment fragment = (Fragment)object.next();
            if (fragment.getOffset() <= n) {
                Fragment fragment2 = fragment;
                n4 = fragment2.getOffset();
                if (n + n3 <= fragment2.getLength() + n4) {
                    return;
                }
            }
            if (fragment.getOffset() <= n) {
                Fragment fragment3 = fragment;
                n4 = fragment3.getOffset();
                if (n <= fragment3.getLength() + n4) {
                    n3 = n + n3 - fragment.getOffset();
                    n = fragment.getOffset();
                    this.fragments.remove(fragment);
                    continue;
                }
            }
            if (n <= fragment.getOffset()) {
                Fragment fragment4 = fragment;
                n4 = fragment4.getOffset();
                if (fragment4.getLength() + n4 <= n + n3) {
                    this.fragments.remove(fragment);
                    continue;
                }
            }
            if (n > fragment.getOffset() || fragment.getOffset() > n + n3) continue;
            Fragment fragment5 = fragment;
            n3 = fragment5.getOffset();
            n3 = fragment5.getLength() + n3 - n;
            this.fragments.remove(fragment);
        }
        this.fragments.add(Fragment.getInstance(n, n3));
    }

    public synchronized int getPosition() {
        int n = 0;
        for (int k = 0; k < this.buffer.length; ++k) {
            if (!this.isCoveredByFragment(k)) continue;
            n = k + 1;
        }
        return n;
    }

    public synchronized int getBytesBuffered() {
        int n = 0;
        for (int k = 0; k < this.buffer.length; ++k) {
            if (!this.isCoveredByFragment(k)) continue;
            ++n;
        }
        return n;
    }

    public synchronized boolean isCoveredByFragment(int n) {
        return this.isCoveredByFragment(n, 1);
    }

    public synchronized boolean isCoveredByFragment(int n, int n2) {
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        while (iterator.hasNext()) {
            Fragment fragment;
            Fragment fragment2 = fragment = (Fragment)iterator.next();
            int n3 = fragment2.getOffset();
            n3 = fragment2.getLength() + n3;
            if (fragment.getOffset() > n || n + n2 > n3) continue;
            return true;
        }
        return false;
    }

    public synchronized int getBufferedLength(int n) {
        int n2 = 0;
        if (n >= ((FragmentBuffer)((Object)iterator)).buffer.length) {
            return 0;
        }
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        while (iterator.hasNext()) {
            Fragment fragment;
            Fragment fragment2 = fragment = (Fragment)iterator.next();
            int n3 = fragment2.getOffset();
            n3 = fragment2.getLength() + n3;
            if (fragment.getOffset() > n || n >= n3 || (n3 -= n) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public Collection<Fragment> getFragments() {
        return this.fragments;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            // ** MonitorExit[this] (shouldn't be in output)
            return fragmentBuffer.buffer.length;
        }
    }

    public synchronized Fragment getSmallestUnbufferedFragment(int n, int n2) {
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        int n3 = n;
        while (iterator.hasNext()) {
            int n4;
            Fragment fragment = (Fragment)iterator.next();
            if (fragment.getOffset() <= n3) {
                Fragment fragment2 = fragment;
                n4 = fragment2.getOffset();
                if (n3 + n2 <= fragment2.getLength() + n4) {
                    n2 = 0;
                    break;
                }
            }
            if (fragment.getOffset() <= n3) {
                Fragment fragment3 = fragment;
                n4 = fragment3.getOffset();
                if (n3 < fragment3.getLength() + n4) {
                    int n5 = n3;
                    int n6 = n2;
                    Fragment fragment4 = fragment;
                    n2 = fragment4.getOffset();
                    n3 = fragment4.getLength() + n2;
                    n2 = n5 + n6 - n3;
                    continue;
                }
            }
            if (n3 <= fragment.getOffset()) {
                Fragment fragment5 = fragment;
                n4 = fragment5.getOffset();
                if (fragment5.getLength() + n4 <= n3 + n2) continue;
            }
            if (n > fragment.getOffset() || fragment.getOffset() >= n3 + n2) continue;
            n2 = fragment.getOffset() - n3;
        }
        return Fragment.getInstance(n3, n2);
    }

    public synchronized String toString() {
        return b.b.a("FragmentBuffer [").append(this.buffer.length).append(", ").append(this.fragments).append("]").toString();
    }

    public synchronized boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!object.getClass().equals(FragmentBuffer.class)) {
            return false;
        }
        object = (FragmentBuffer)object;
        byte[] byArray = ((FragmentBuffer)object).buffer;
        if (((FragmentBuffer)object).buffer == null && this.buffer != null) {
            return false;
        }
        if (byArray != null && this.buffer == null) {
            return false;
        }
        Collection<Fragment> collection = ((FragmentBuffer)object).fragments;
        if (collection == null && this.fragments != null) {
            return false;
        }
        if (collection != null && this.fragments == null) {
            return false;
        }
        return Arrays.equals(byArray, this.buffer) && ((FragmentBuffer)object).fragments.equals(this.fragments);
    }

    public int hashCode() {
        FragmentBuffer fragmentBuffer = this;
        int n = Arrays.hashCode(fragmentBuffer.buffer) * 3;
        return fragmentBuffer.fragments.hashCode() * 2 + n + 7;
    }

    public static class Fragment
    implements Serializable {
        private static final long serialVersionUID = -3795931618553980328L;
        private int offset;
        private int length;

        private Fragment(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }

        public static Fragment getInstance(int n, int n2) {
            return new Fragment(n, n2);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return b.a(b.b.a("[").append(this.offset).append(" .. ").append(this.offset + this.length - 1).append(" ("), this.length, ")]");
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!object.getClass().equals(Fragment.class)) {
                return false;
            }
            object = (Fragment)object;
            return ((Fragment)object).offset == this.offset && ((Fragment)object).length == this.length;
        }

        public int hashCode() {
            Fragment fragment = this;
            int n = fragment.offset * 2;
            return fragment.length * 3 + n + 5;
        }
    }
}

