package vn.kalapa.ekyc.iproov

import android.app.Dialog
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.DialogFragment
import vn.kalapa.R
import vn.kalapa.databinding.FragmentIProovProgressDialogBinding

class IProovProgressDialog : DialogFragment() {
    private var _binding: FragmentIProovProgressDialogBinding? = null
    private val binding get() = _binding!!

    private var currentProgress: Double = 0.0
    private var currentContent: String = ""

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentIProovProgressDialogBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog = super.onCreateDialog(savedInstanceState)
        dialog.setCancelable(false)
        return dialog
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        updateProgressView()
    }

    fun setProgress(value: Double, content: String) {
        currentProgress = value
        currentContent = content

        updateProgressView()
    }

    private fun updateProgressView() {
        view?.let {
            binding.run {
                progressTtv.text = currentContent
                progressView.setProgressAnimated(currentProgress)
            }
        }
    }

    override fun onStart() {
        super.onStart()
        dialog?.window?.setLayout(
            (resources.displayMetrics.widthPixels * 0.6).toInt(),
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
    }

    override fun getTheme(): Int = R.style.CustomDialogTheme

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

    companion object {
        fun newInstance(): IProovProgressDialog {
            return IProovProgressDialog()
        }
    }
}