package vn.kalapa.ekyc.models

import com.google.gson.Gson

data class KalapaCDNObj(val error: KalapaError, val data: KalapaCDNData) {
    companion object {
        fun fromJson(json: String): KalapaCDNObj = Gson().fromJson(json, KalapaCDNObj::class.java)
    }
}

data class KalapaCDNData(val language: Array<KalapaCDNLanguage>, val sdk_model: Array<KalapaCDNModel>) {
    companion object {
        fun fromJson(json: String): KalapaCDNData = Gson().fromJson(json, KalapaCDNData::class.java)
    }
}

data class KalapaCDNLanguage(val code: String, val created_time: String, val version: String) {
    companion object {
        fun fromJson(json: String): KalapaCDNLanguage = Gson().fromJson(json, KalapaCDNLanguage::class.java)
    }
}

data class KalapaCDNModel(val name: String, val created_time: String, val os: String, val version: String) {
    companion object {
        fun fromJson(json: String): KalapaCDNModel = Gson().fromJson(json, KalapaCDNModel::class.java)
    }
}