/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ASN1Enumerated
extends ASN1Primitive {
    private static ASN1Enumerated[] cache = new ASN1Enumerated[12];
    private final byte[] bytes;
    private final int start;

    public static ASN1Enumerated getInstance(Object object) {
        if (object != null && !(object instanceof ASN1Enumerated)) {
            if (object instanceof byte[]) {
                try {
                    return (ASN1Enumerated)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, b.a("encoding error in getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (ASN1Enumerated)object;
    }

    public static ASN1Enumerated getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof ASN1Enumerated)) {
            return ASN1Enumerated.fromOctetString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return ASN1Enumerated.getInstance(aSN1Primitive);
    }

    public ASN1Enumerated(int n) {
        if (n >= 0) {
            ASN1Enumerated aSN1Enumerated = this;
            aSN1Enumerated.bytes = BigInteger.valueOf(n).toByteArray();
            aSN1Enumerated.start = 0;
            return;
        }
        throw new IllegalArgumentException("enumerated must be non-negative");
    }

    public ASN1Enumerated(BigInteger bigInteger) {
        if (bigInteger.signum() >= 0) {
            ASN1Enumerated aSN1Enumerated = this;
            aSN1Enumerated.bytes = bigInteger.toByteArray();
            aSN1Enumerated.start = 0;
            return;
        }
        throw new IllegalArgumentException("enumerated must be non-negative");
    }

    public ASN1Enumerated(byte[] byArray) {
        if (!ASN1Integer.isMalformed(byArray)) {
            if ((byArray[0] & 0x80) == 0) {
                this.bytes = Arrays.clone(byArray);
                this.start = ASN1Integer.signBytesToSkip(byArray);
                return;
            }
            throw new IllegalArgumentException("enumerated must be non-negative");
        }
        throw new IllegalArgumentException("malformed enumerated");
    }

    public static ASN1Enumerated fromOctetString(byte[] byArray) {
        if (byArray.length > 1) {
            return new ASN1Enumerated(byArray);
        }
        if (byArray.length != 0) {
            int n = byArray[0] & 0xFF;
            ASN1Enumerated[] aSN1EnumeratedArray = cache;
            if (n >= cache.length) {
                return new ASN1Enumerated(byArray);
            }
            ASN1Enumerated aSN1Enumerated = aSN1EnumeratedArray[n];
            if (aSN1Enumerated == null) {
                ASN1Enumerated aSN1Enumerated2;
                aSN1Enumerated = aSN1Enumerated2;
                aSN1Enumerated2 = new ASN1Enumerated(byArray);
                aSN1EnumeratedArray[n] = aSN1Enumerated;
            }
            return aSN1Enumerated;
        }
        throw new IllegalArgumentException("ENUMERATED has zero length");
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public boolean hasValue(BigInteger bigInteger) {
        return bigInteger != null && ASN1Integer.intValue(this.bytes, this.start, -1) == bigInteger.intValue() && this.getValue().equals(bigInteger);
    }

    public int intValueExact() {
        byte[] byArray = this.bytes;
        int n = this.start;
        if (this.bytes.length - n <= 4) {
            return ASN1Integer.intValue(byArray, n, -1);
        }
        throw new ArithmeticException("ASN.1 Enumerated out of int range");
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        return StreamUtil.calculateBodyLength(this.bytes.length) + 1 + this.bytes.length;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((ASN1Enumerated)object).bytes;
        aSN1OutputStream.writeEncoded(bl, 10, (byte[])object);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Enumerated)) {
            return false;
        }
        ASN1Enumerated aSN1Enumerated = aSN1Enumerated2;
        ASN1Enumerated aSN1Enumerated2 = (ASN1Enumerated)aSN1Primitive;
        return Arrays.areEqual(aSN1Enumerated.bytes, aSN1Enumerated2.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

