/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;

public class DERSequence
extends ASN1Sequence {
    private int bodyLength = -1;

    public static DERSequence convert(ASN1Sequence aSN1Sequence) {
        return (DERSequence)aSN1Sequence.toDERObject();
    }

    public DERSequence() {
    }

    public DERSequence(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DERSequence(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector);
    }

    public DERSequence(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray);
    }

    public DERSequence(ASN1Encodable[] aSN1EncodableArray, boolean bl) {
        super(aSN1EncodableArray, bl);
    }

    private int getBodyLength() {
        if (this.bodyLength < 0) {
            int n = this.elements.length;
            int n2 = 0;
            for (int k = 0; k < n; ++k) {
                n2 = this.elements[k].toASN1Primitive().toDERObject().encodedLength() + n2;
            }
            this.bodyLength = n2;
        }
        return this.bodyLength;
    }

    @Override
    public int encodedLength() {
        int n = this.getBodyLength();
        return StreamUtil.calculateBodyLength(n) + 1 + n;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        if (bl) {
            aSN1OutputStream.write(48);
        }
        DERSequence dERSequence = this;
        DEROutputStream dEROutputStream = aSN1OutputStream.getDERSubStream();
        int n = dERSequence.elements.length;
        if (dERSequence.bodyLength < 0 && n <= 16) {
            int n2 = 0;
            ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[n];
            for (int k = 0; k < n; ++k) {
                ASN1Primitive aSN1Primitive;
                aSN1PrimitiveArray[k] = aSN1Primitive = this.elements[k].toASN1Primitive().toDERObject();
                n2 = aSN1Primitive.encodedLength() + n2;
            }
            this.bodyLength = n2;
            aSN1OutputStream.writeLength(n2);
            for (int k = 0; k < n; ++k) {
                aSN1PrimitiveArray[k].encode(dEROutputStream, true);
            }
        } else {
            aSN1OutputStream.writeLength(this.getBodyLength());
            for (int k = 0; k < n; ++k) {
                this.elements[k].toASN1Primitive().toDERObject().encode(dEROutputStream, true);
            }
        }
    }

    @Override
    public ASN1Primitive toDERObject() {
        return this;
    }

    @Override
    public ASN1Primitive toDLObject() {
        return this;
    }
}

