/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;

public class DERUniversalString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] string;

    public static DERUniversalString getInstance(Object object) {
        if (object != null && !(object instanceof DERUniversalString)) {
            if (object instanceof byte[]) {
                try {
                    return (DERUniversalString)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, b.a("encoding error getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (DERUniversalString)object;
    }

    public static DERUniversalString getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof DERUniversalString)) {
            return new DERUniversalString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return DERUniversalString.getInstance(aSN1Primitive);
    }

    public DERUniversalString(byte[] byArray) {
        this.string = Arrays.clone(byArray);
    }

    @Override
    public String getString() {
        byte[] byArray;
        StringBuffer stringBuffer;
        DERUniversalString dERUniversalString = stringBuffer2;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer("#");
        try {
            byArray = dERUniversalString.getEncoded();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("internal error encoding UniversalString");
        }
        for (int k = 0; k != byArray.length; ++k) {
            char[] cArray = table;
            stringBuffer2.append(cArray[byArray[k] >>> 4 & 0xF]);
            stringBuffer2.append(table[byArray[k] & 0xF]);
        }
        return stringBuffer2.toString();
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        return StreamUtil.calculateBodyLength(this.string.length) + 1 + this.string.length;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((DERUniversalString)object).string;
        aSN1OutputStream.writeEncoded(bl, 28, (byte[])object);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERUniversalString)) {
            return false;
        }
        return Arrays.areEqual(this.string, ((DERUniversalString)aSN1Primitive).string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }
}

