/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DigestInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;

public class LinkedCertificate
extends ASN1Object {
    private final DigestInfo digest;
    private final GeneralName certLocation;
    private X500Name certIssuer;
    private GeneralNames cACerts;

    public LinkedCertificate(DigestInfo digestInfo, GeneralName generalName) {
        this(digestInfo, generalName, null, null);
    }

    public LinkedCertificate(DigestInfo digestInfo, GeneralName generalName, X500Name x500Name, GeneralNames generalNames) {
        this.digest = digestInfo;
        this.certLocation = generalName;
        this.certIssuer = x500Name;
        this.cACerts = generalNames;
    }

    private LinkedCertificate(ASN1Sequence aSN1Sequence) {
        this.digest = DigestInfo.getInstance(aSN1Sequence.getObjectAt(0));
        this.certLocation = GeneralName.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() > 2) {
            for (int k = 2; k != aSN1Sequence.size(); ++k) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(k));
                int n = aSN1TaggedObject.getTagNo();
                if (n != 0) {
                    if (n == 1) {
                        this.cACerts = GeneralNames.getInstance(aSN1TaggedObject, false);
                        continue;
                    }
                    throw new IllegalArgumentException("unknown tag in tagged field");
                }
                this.certIssuer = X500Name.getInstance(aSN1TaggedObject, false);
            }
        }
    }

    public static LinkedCertificate getInstance(Object object) {
        if (object instanceof LinkedCertificate) {
            return (LinkedCertificate)object;
        }
        if (object != null) {
            return new LinkedCertificate(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DigestInfo getDigest() {
        return this.digest;
    }

    public GeneralName getCertLocation() {
        return this.certLocation;
    }

    public X500Name getCertIssuer() {
        return this.certIssuer;
    }

    public GeneralNames getCACerts() {
        return this.cACerts;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        GeneralNames generalNames;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector2.add(this.digest);
        aSN1EncodableVector.add(this.certLocation);
        ASN1Object aSN1Object = this.certIssuer;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        if ((generalNames = this.cACerts) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 1, generalNames);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

