/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1BitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class SignatureCheck
extends ASN1Object {
    private final AlgorithmIdentifier signatureAlgorithm;
    private final ASN1Sequence certificates;
    private final ASN1BitString signatureValue;

    public SignatureCheck(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        SignatureCheck signatureCheck = this;
        signatureCheck.signatureAlgorithm = algorithmIdentifier;
        signatureCheck.certificates = null;
        signatureCheck.signatureValue = new DERBitString(Arrays.clone(byArray));
    }

    public SignatureCheck(AlgorithmIdentifier algorithmIdentifier, Certificate[] certificateArray, byte[] byArray) {
        SignatureCheck signatureCheck = this;
        signatureCheck.signatureAlgorithm = algorithmIdentifier;
        signatureCheck.certificates = new DERSequence(certificateArray);
        signatureCheck.signatureValue = new DERBitString(Arrays.clone(byArray));
    }

    private SignatureCheck(ASN1Sequence aSN1Sequence) {
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        int n = 1;
        if (aSN1Sequence.getObjectAt(1) instanceof ASN1TaggedObject) {
            int n2 = n;
            n = 2;
            this.certificates = ASN1Sequence.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(n2)).getObject());
        } else {
            this.certificates = null;
        }
        this.signatureValue = DERBitString.getInstance(aSN1Sequence.getObjectAt(n));
    }

    public static SignatureCheck getInstance(Object object) {
        if (object instanceof SignatureCheck) {
            return (SignatureCheck)object;
        }
        if (object != null) {
            return new SignatureCheck(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1BitString getSignature() {
        return new DERBitString(this.signatureValue.getBytes(), this.signatureValue.getPadBits());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Certificate[] getCertificates() {
        ASN1Sequence aSN1Sequence = this.certificates;
        if (aSN1Sequence == null) {
            return null;
        }
        int n = aSN1Sequence.size();
        Certificate[] certificateArray = new Certificate[n];
        for (int k = 0; k != n; ++k) {
            certificateArray[k] = Certificate.getInstance(this.certificates.getObjectAt(k));
        }
        return certificateArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.signatureAlgorithm);
        ASN1Sequence aSN1Sequence = this.certificates;
        if (aSN1Sequence != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(0, aSN1Sequence);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        aSN1EncodableVector2.add(this.signatureValue);
        return new DERSequence(aSN1EncodableVector2);
    }
}

