/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;

public class CertificationRequest
extends ASN1Object {
    private static final ASN1Integer ZERO = new ASN1Integer(0L);
    private final CertificationRequestInfo certificationRequestInfo;
    private final AlgorithmIdentifier signatureAlgorithm;
    private final DERBitString signature;

    public CertificationRequest(X500Name x500Name, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier2, DERBitString dERBitString2) {
        CertificationRequestInfo certificationRequestInfo;
        CertificationRequestInfo certificationRequestInfo2 = certificationRequestInfo;
        certificationRequestInfo = new CertificationRequestInfo(this, x500Name, algorithmIdentifier, dERBitString, aSN1Set, null);
        this.certificationRequestInfo = certificationRequestInfo2;
        this.signatureAlgorithm = algorithmIdentifier2;
        this.signature = dERBitString2;
    }

    private CertificationRequest(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 3) {
            this.certificationRequestInfo = new CertificationRequestInfo(this, ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0)), null);
            this.signatureAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            this.signature = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
            return;
        }
        throw new IllegalArgumentException("incorrect sequence size");
    }

    public static CertificationRequest getInstance(Object object) {
        if (object instanceof CertificationRequest) {
            return (CertificationRequest)object;
        }
        if (object != null) {
            return new CertificationRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public BigInteger getVersion() {
        return this.certificationRequestInfo.getVersion().getValue();
    }

    public X500Name getSubject() {
        return this.certificationRequestInfo.getSubject();
    }

    public ASN1Set getAttributes() {
        return this.certificationRequestInfo.getAttributes();
    }

    public AlgorithmIdentifier getSubjectPublicKeyAlgorithm() {
        return AlgorithmIdentifier.getInstance(this.certificationRequestInfo.getSubjectPublicKeyInfo().getObjectAt(0));
    }

    public DERBitString getSubjectPublicKey() {
        return DERBitString.getInstance(this.certificationRequestInfo.getSubjectPublicKeyInfo().getObjectAt(1));
    }

    public ASN1Primitive parsePublicKey() {
        return ASN1Primitive.fromByteArray(this.getSubjectPublicKey().getOctets());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DERBitString getSignature() {
        return this.signature;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(this.certificationRequestInfo);
        aSN1EncodableVector2.add(this.signatureAlgorithm);
        aSN1EncodableVector.add(this.signature);
        return new DERSequence(aSN1EncodableVector2);
    }

    public class CertificationRequestInfo
    extends ASN1Object {
        private final ASN1Integer version;
        private final X500Name subject;
        private final ASN1Sequence subjectPublicKeyInfo;
        private final ASN1Set attributes;
        public final /* synthetic */ CertificationRequest this$0;

        private CertificationRequestInfo(CertificationRequest aSN1Object, ASN1Sequence aSN1Sequence) {
            this.this$0 = aSN1Object;
            if (aSN1Sequence.size() == 4) {
                this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
                this.subject = X500Name.getInstance(aSN1Sequence.getObjectAt(1));
                aSN1Object = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(2));
                this.subjectPublicKeyInfo = aSN1Object;
                if (((ASN1Sequence)aSN1Object).size() == 2) {
                    aSN1Object = (ASN1TaggedObject)aSN1Sequence.getObjectAt(3);
                    if (((ASN1TaggedObject)aSN1Object).getTagNo() == 0) {
                        this.attributes = ASN1Set.getInstance((ASN1TaggedObject)aSN1Object, false);
                        return;
                    }
                    throw new IllegalArgumentException("incorrect tag number on attributes for CertificationRequestInfo");
                }
                throw new IllegalArgumentException("incorrect subjectPublicKeyInfo size for CertificationRequestInfo");
            }
            throw new IllegalArgumentException("incorrect sequence size for CertificationRequestInfo");
        }

        private CertificationRequestInfo(CertificationRequest certificationRequest, X500Name x500Name, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Set aSN1Set) {
            CertificationRequestInfo certificationRequestInfo = this;
            this.this$0 = certificationRequest;
            this.version = ZERO;
            certificationRequestInfo.subject = x500Name;
            certificationRequestInfo.subjectPublicKeyInfo = new DERSequence(new ASN1Encodable[]{algorithmIdentifier, dERBitString});
            this.attributes = aSN1Set;
        }

        private ASN1Integer getVersion() {
            return this.version;
        }

        private X500Name getSubject() {
            return this.subject;
        }

        private ASN1Sequence getSubjectPublicKeyInfo() {
            return this.subjectPublicKeyInfo;
        }

        private ASN1Set getAttributes() {
            return this.attributes;
        }

        public /* synthetic */ CertificationRequestInfo(CertificationRequest certificationRequest, X500Name x500Name, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Set aSN1Set, 1 var6_6) {
            this(certificationRequest, x500Name, algorithmIdentifier, dERBitString, aSN1Set);
        }

        public /* synthetic */ CertificationRequestInfo(CertificationRequest certificationRequest, ASN1Sequence aSN1Sequence, 1 var3_3) {
            this(certificationRequest, aSN1Sequence);
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
            aSN1EncodableVector2(4);
            aSN1EncodableVector2.add(aSN1Object.version);
            aSN1EncodableVector2.add(aSN1Object.subject);
            aSN1EncodableVector.add(aSN1Object.subjectPublicKeyInfo);
            ASN1Object aSN1Object = aSN1Object.attributes;
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, aSN1Object));
            return new DERSequence(aSN1EncodableVector2);
        }
    }
}

