/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.ReasonFlags;

public class GetCRL
extends ASN1Object {
    private final X500Name issuerName;
    private GeneralName cRLName;
    private ASN1GeneralizedTime time;
    private ReasonFlags reasons;

    public GetCRL(X500Name x500Name, GeneralName generalName, ASN1GeneralizedTime aSN1GeneralizedTime, ReasonFlags reasonFlags) {
        this.issuerName = x500Name;
        this.cRLName = generalName;
        this.time = aSN1GeneralizedTime;
        this.reasons = reasonFlags;
    }

    private GetCRL(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 1 && aSN1Sequence.size() <= 4) {
            this.issuerName = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
            int n = 1;
            if (aSN1Sequence.size() > n && aSN1Sequence.getObjectAt(n).toASN1Primitive() instanceof ASN1TaggedObject) {
                int n2 = n;
                n = 2;
                this.cRLName = GeneralName.getInstance(aSN1Sequence.getObjectAt(n2));
            }
            if (aSN1Sequence.size() > n && aSN1Sequence.getObjectAt(n).toASN1Primitive() instanceof ASN1GeneralizedTime) {
                this.time = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(n++));
            }
            if (aSN1Sequence.size() > n && aSN1Sequence.getObjectAt(n).toASN1Primitive() instanceof DERBitString) {
                this.reasons = new ReasonFlags(DERBitString.getInstance(aSN1Sequence.getObjectAt(n)));
            }
            return;
        }
        throw new IllegalArgumentException("incorrect sequence size");
    }

    public static GetCRL getInstance(Object object) {
        if (object instanceof GetCRL) {
            return (GetCRL)object;
        }
        if (object != null) {
            return new GetCRL(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public GeneralName getcRLName() {
        return this.cRLName;
    }

    public ASN1GeneralizedTime getTime() {
        return this.time;
    }

    public ReasonFlags getReasons() {
        return this.reasons;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ReasonFlags reasonFlags;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector.add(this.issuerName);
        ASN1Object aSN1Object = this.cRLName;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.time) != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((reasonFlags = this.reasons) != null) {
            aSN1EncodableVector2.add(reasonFlags);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

