/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIFailureInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIFreeText;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIStatus;
import java.math.BigInteger;

public class PKIStatusInfo
extends ASN1Object {
    public ASN1Integer status;
    public PKIFreeText statusString;
    public DERBitString failInfo;

    public static PKIStatusInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return PKIStatusInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static PKIStatusInfo getInstance(Object object) {
        if (object instanceof PKIStatusInfo) {
            return (PKIStatusInfo)object;
        }
        if (object != null) {
            return new PKIStatusInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private PKIStatusInfo(ASN1Sequence aSN1Encodable) {
        PKIStatusInfo pKIStatusInfo = this;
        pKIStatusInfo.status = ASN1Integer.getInstance(aSN1Encodable.getObjectAt(0));
        pKIStatusInfo.statusString = null;
        pKIStatusInfo.failInfo = null;
        if (aSN1Encodable.size() > 2) {
            this.statusString = PKIFreeText.getInstance(aSN1Encodable.getObjectAt(1));
            this.failInfo = DERBitString.getInstance(aSN1Encodable.getObjectAt(2));
        } else if (aSN1Encodable.size() > 1) {
            if ((aSN1Encodable = aSN1Encodable.getObjectAt(1)) instanceof DERBitString) {
                this.failInfo = DERBitString.getInstance(aSN1Encodable);
            } else {
                this.statusString = PKIFreeText.getInstance(aSN1Encodable);
            }
        }
    }

    public PKIStatusInfo(PKIStatus pKIStatus) {
        this.status = ASN1Integer.getInstance(pKIStatus.toASN1Primitive());
    }

    public PKIStatusInfo(PKIStatus pKIStatus, PKIFreeText pKIFreeText) {
        this.status = ASN1Integer.getInstance(pKIStatus.toASN1Primitive());
        this.statusString = pKIFreeText;
    }

    public PKIStatusInfo(PKIStatus pKIStatus, PKIFreeText pKIFreeText, PKIFailureInfo pKIFailureInfo) {
        this.status = ASN1Integer.getInstance(pKIStatus.toASN1Primitive());
        this.statusString = pKIFreeText;
        this.failInfo = pKIFailureInfo;
    }

    public BigInteger getStatus() {
        return this.status.getValue();
    }

    public PKIFreeText getStatusString() {
        return this.statusString;
    }

    public DERBitString getFailInfo() {
        return this.failInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERBitString dERBitString;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.status);
        PKIFreeText pKIFreeText = this.statusString;
        if (pKIFreeText != null) {
            aSN1EncodableVector2.add(pKIFreeText);
        }
        if ((dERBitString = this.failInfo) != null) {
            aSN1EncodableVector2.add(dERBitString);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

