/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private ASN1OctetString encryptedContent;

    public EncryptedContentInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        this.contentType = aSN1ObjectIdentifier;
        this.contentEncryptionAlgorithm = algorithmIdentifier;
        this.encryptedContent = aSN1OctetString;
    }

    private EncryptedContentInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 2) {
            this.contentType = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
            this.contentEncryptionAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() > 2) {
                this.encryptedContent = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(2), false);
            }
            return;
        }
        throw new IllegalArgumentException("Truncated Sequence Found");
    }

    public static EncryptedContentInfo getInstance(Object object) {
        if (object instanceof EncryptedContentInfo) {
            return (EncryptedContentInfo)object;
        }
        if (object != null) {
            return new EncryptedContentInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public ASN1OctetString getEncryptedContent() {
        return this.encryptedContent;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(aSN1Object.contentType);
        aSN1EncodableVector.add(aSN1Object.contentEncryptionAlgorithm);
        ASN1Object aSN1Object = aSN1Object.encryptedContent;
        if (aSN1Object != null) {
            BERTaggedObject bERTaggedObject;
            BERTaggedObject bERTaggedObject2 = bERTaggedObject;
            bERTaggedObject = new BERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(bERTaggedObject2);
        }
        return new BERSequence(aSN1EncodableVector2);
    }
}

