/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro;

import c.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class GostR3410TransportParameters
extends ASN1Object {
    private final ASN1ObjectIdentifier encryptionParamSet;
    private final SubjectPublicKeyInfo ephemeralPublicKey;
    private final byte[] ukm;

    public GostR3410TransportParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, SubjectPublicKeyInfo subjectPublicKeyInfo, byte[] byArray) {
        this.encryptionParamSet = aSN1ObjectIdentifier;
        this.ephemeralPublicKey = subjectPublicKeyInfo;
        this.ukm = Arrays.clone(byArray);
    }

    private GostR3410TransportParameters(ASN1Sequence aSN1Sequence) {
        block4: {
            block3: {
                block2: {
                    if (aSN1Sequence.size() != 2) break block2;
                    GostR3410TransportParameters gostR3410TransportParameters = this;
                    this.encryptionParamSet = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
                    gostR3410TransportParameters.ukm = a.a(aSN1Sequence, 1);
                    gostR3410TransportParameters.ephemeralPublicKey = null;
                    break block3;
                }
                if (aSN1Sequence.size() != 3) break block4;
                this.encryptionParamSet = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
                this.ephemeralPublicKey = SubjectPublicKeyInfo.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(1)), false);
                this.ukm = a.a(aSN1Sequence, 2);
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("unknown sequence length: ")));
    }

    public static GostR3410TransportParameters getInstance(Object object) {
        if (object instanceof GostR3410TransportParameters) {
            return (GostR3410TransportParameters)object;
        }
        if (object != null) {
            return new GostR3410TransportParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static GostR3410TransportParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new GostR3410TransportParameters(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.encryptionParamSet;
    }

    public SubjectPublicKeyInfo getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public byte[] getUkm() {
        return Arrays.clone(this.ukm);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.encryptionParamSet);
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.ephemeralPublicKey;
        if (subjectPublicKeyInfo != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 0, subjectPublicKeyInfo);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        aSN1EncodableVector2.add(new DEROctetString(this.ukm));
        return new DERSequence(aSN1EncodableVector2);
    }
}

