/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ess;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ess.ESSCertIDv2;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificateV2
extends ASN1Object {
    public ASN1Sequence certs;
    public ASN1Sequence policies;

    public static SigningCertificateV2 getInstance(Object object) {
        if (object != null && !(object instanceof SigningCertificateV2)) {
            if (object instanceof ASN1Sequence) {
                return new SigningCertificateV2((ASN1Sequence)object);
            }
            return null;
        }
        return (SigningCertificateV2)object;
    }

    private SigningCertificateV2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 1 && aSN1Sequence.size() <= 2) {
            this.certs = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0));
            if (aSN1Sequence.size() > 1) {
                this.policies = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public SigningCertificateV2(ESSCertIDv2 eSSCertIDv2) {
        DERSequence dERSequence;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(eSSCertIDv2);
        v1.certs = aSN1Object;
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array) {
        DERSequence dERSequence;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(eSSCertIDv2Array);
        v1.certs = aSN1Object;
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array, PolicyInformation[] policyInformationArray) {
        DERSequence dERSequence;
        DERSequence dERSequence2 = dERSequence;
        dERSequence = new DERSequence(eSSCertIDv2Array);
        aSN1Object.certs = dERSequence2;
        if (policyInformationArray != null) {
            DERSequence dERSequence3;
            SigningCertificateV2 signingCertificateV2 = aSN1Object;
            ASN1Object aSN1Object = dERSequence3;
            dERSequence3 = new DERSequence(policyInformationArray);
            signingCertificateV2.policies = aSN1Object;
        }
    }

    public ESSCertIDv2[] getCerts() {
        ESSCertIDv2[] eSSCertIDv2Array = new ESSCertIDv2[this.certs.size()];
        for (int k = 0; k != this.certs.size(); ++k) {
            eSSCertIDv2Array[k] = ESSCertIDv2.getInstance(this.certs.getObjectAt(k));
        }
        return eSSCertIDv2Array;
    }

    public PolicyInformation[] getPolicies() {
        PolicyInformation[] policyInformationArray = this.policies;
        if (this.policies == null) {
            return null;
        }
        policyInformationArray = new PolicyInformation[policyInformationArray.size()];
        for (int k = 0; k != this.policies.size(); ++k) {
            policyInformationArray[k] = PolicyInformation.getInstance(this.policies.getObjectAt(k));
        }
        return policyInformationArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector.add(aSN1Object.certs);
        ASN1Object aSN1Object = aSN1Object.policies;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

