/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao.DataGroupHash;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao.ICAOObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao.LDSVersionInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class LDSSecurityObject
extends ASN1Object
implements ICAOObjectIdentifiers {
    public static final int ub_DataGroups = 16;
    private ASN1Integer version;
    private AlgorithmIdentifier digestAlgorithmIdentifier;
    private DataGroupHash[] datagroupHash;
    private LDSVersionInfo versionInfo;

    public static LDSSecurityObject getInstance(Object object) {
        if (object instanceof LDSSecurityObject) {
            return (LDSSecurityObject)object;
        }
        if (object != null) {
            return new LDSSecurityObject(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private LDSSecurityObject(ASN1Sequence object) {
        ASN1Integer aSN1Integer;
        ASN1Primitive aSN1Primitive = aSN1Integer;
        aSN1Integer = new ASN1Integer(0L);
        this.version = aSN1Primitive;
        if (object != null && ((ASN1Sequence)object).size() != 0) {
            object = ((ASN1Sequence)object).getObjects();
            this.version = ASN1Integer.getInstance(object.nextElement());
            this.digestAlgorithmIdentifier = AlgorithmIdentifier.getInstance(object.nextElement());
            aSN1Primitive = ASN1Sequence.getInstance(object.nextElement());
            if (this.version.intValueExact() == 1) {
                this.versionInfo = LDSVersionInfo.getInstance(object.nextElement());
            }
            this.checkDatagroupHashSeqSize(((ASN1Sequence)aSN1Primitive).size());
            this.datagroupHash = new DataGroupHash[((ASN1Sequence)aSN1Primitive).size()];
            for (int k = 0; k < ((ASN1Sequence)aSN1Primitive).size(); ++k) {
                this.datagroupHash[k] = DataGroupHash.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(k));
            }
            return;
        }
        throw new IllegalArgumentException("null or empty sequence passed.");
    }

    public LDSSecurityObject(AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray) {
        this.version = new ASN1Integer(0L);
        this.version = new ASN1Integer(0L);
        this.digestAlgorithmIdentifier = algorithmIdentifier;
        this.datagroupHash = this.copy(dataGroupHashArray);
        this.checkDatagroupHashSeqSize(dataGroupHashArray.length);
    }

    public LDSSecurityObject(AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray, LDSVersionInfo lDSVersionInfo) {
        this.version = new ASN1Integer(0L);
        this.version = new ASN1Integer(1L);
        this.digestAlgorithmIdentifier = algorithmIdentifier;
        this.datagroupHash = this.copy(dataGroupHashArray);
        this.versionInfo = lDSVersionInfo;
        this.checkDatagroupHashSeqSize(dataGroupHashArray.length);
    }

    private void checkDatagroupHashSeqSize(int n) {
        if (n >= 2 && n <= 16) {
            return;
        }
        throw new IllegalArgumentException("wrong size in DataGroupHashValues : not in (2..16)");
    }

    private DataGroupHash[] copy(DataGroupHash[] dataGroupHashArray) {
        int n = dataGroupHashArray.length;
        DataGroupHash[] dataGroupHashArray2 = new DataGroupHash[n];
        System.arraycopy(dataGroupHashArray, 0, dataGroupHashArray2, 0, n);
        return dataGroupHashArray2;
    }

    public int getVersion() {
        return this.version.intValueExact();
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.digestAlgorithmIdentifier;
    }

    public DataGroupHash[] getDatagroupHash() {
        LDSSecurityObject lDSSecurityObject = this;
        return lDSSecurityObject.copy(lDSSecurityObject.datagroupHash);
    }

    public LDSVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector2.add(aSN1Object.version);
        aSN1EncodableVector.add(aSN1Object.digestAlgorithmIdentifier);
        aSN1EncodableVector.add(new DERSequence(aSN1Object.datagroupHash));
        ASN1Object aSN1Object = aSN1Object.versionInfo;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

