/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.ocsp;

import c.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class CertHash
extends ASN1Object {
    private AlgorithmIdentifier hashAlgorithm;
    private byte[] certificateHash;

    public static CertHash getInstance(Object object) {
        if (object != null && !(object instanceof CertHash)) {
            if (object instanceof ASN1Sequence) {
                return new CertHash((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("illegal object in getInstance: ")));
        }
        return (CertHash)object;
    }

    private CertHash(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            this.hashAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.certificateHash = a.a(aSN1Sequence, 1);
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public CertHash(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        CertHash certHash = object;
        ((CertHash)object).hashAlgorithm = algorithmIdentifier;
        byte[] byArray2 = new byte[byArray.length];
        Object object = byArray2;
        certHash.certificateHash = byArray2;
        int n = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getCertificateHash() {
        return Arrays.clone(this.certificateHash);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector.add(this.hashAlgorithm);
        aSN1EncodableVector.add(new DEROctetString(this.certificateHash));
        return new DERSequence(aSN1EncodableVector2);
    }
}

