/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.MacData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class Pfx
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ContentInfo contentInfo;
    private MacData macData;

    private Pfx(ASN1Sequence aSN1Sequence) {
        this.macData = null;
        if (ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).intValueExact() == 3) {
            this.contentInfo = ContentInfo.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() == 3) {
                this.macData = MacData.getInstance(aSN1Sequence.getObjectAt(2));
            }
            return;
        }
        throw new IllegalArgumentException("wrong version for PFX PDU");
    }

    public static Pfx getInstance(Object object) {
        if (object instanceof Pfx) {
            return (Pfx)object;
        }
        if (object != null) {
            return new Pfx(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Pfx(ContentInfo contentInfo, MacData macData) {
        this.contentInfo = contentInfo;
        this.macData = macData;
    }

    public ContentInfo getAuthSafe() {
        return this.contentInfo;
    }

    public MacData getMacData() {
        return this.macData;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector3(3);
        aSN1EncodableVector3.add(new ASN1Integer(3L));
        aSN1EncodableVector.add(aSN1Object.contentInfo);
        ASN1Object aSN1Object = aSN1Object.macData;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new BERSequence(aSN1EncodableVector2);
    }
}

