/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPublicKey
extends ASN1Object {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public static RSAPublicKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RSAPublicKey.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RSAPublicKey getInstance(Object object) {
        if (object instanceof RSAPublicKey) {
            return (RSAPublicKey)object;
        }
        if (object != null) {
            return new RSAPublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
    }

    private RSAPublicKey(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            RSAPublicKey rSAPublicKey = enumeration;
            Enumeration enumeration = aSN1Sequence.getObjects();
            rSAPublicKey.modulus = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
            rSAPublicKey.publicExponent = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(2).add(new ASN1Integer(this.getModulus()));
        aSN1EncodableVector2.add(new ASN1Integer(this.getPublicExponent()));
        return new DERSequence(aSN1EncodableVector2);
    }
}

