/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.PolynomialExtensionField;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class DSTU4145ECBinary
extends ASN1Object {
    public BigInteger version;
    public DSTU4145BinaryField f;
    public ASN1Integer a;
    public ASN1OctetString b;
    public ASN1Integer n;
    public ASN1OctetString bp;

    public DSTU4145ECBinary(ECDomainParameters eCDomainParameters) {
        block2: {
            block5: {
                ECCurve eCCurve;
                block4: {
                    DSTU4145BinaryField dSTU4145BinaryField;
                    int[] nArray;
                    block3: {
                        DSTU4145BinaryField dSTU4145BinaryField2;
                        this.version = BigInteger.valueOf(0L);
                        eCCurve = eCDomainParameters.getCurve();
                        if (!ECAlgorithms.isF2mCurve(eCCurve)) break block2;
                        nArray = ((PolynomialExtensionField)eCCurve.getField()).getMinimalPolynomial().getExponentsPresent();
                        if (nArray.length != 3) break block3;
                        DSTU4145BinaryField dSTU4145BinaryField3 = dSTU4145BinaryField2;
                        int n = nArray[2];
                        dSTU4145BinaryField2 = new DSTU4145BinaryField(n, nArray[1]);
                        this.f = dSTU4145BinaryField3;
                        break block4;
                    }
                    if (nArray.length != 5) break block5;
                    DSTU4145BinaryField dSTU4145BinaryField4 = dSTU4145BinaryField;
                    int n = nArray[4];
                    int n2 = nArray[1];
                    int n3 = nArray[2];
                    int n4 = nArray[3];
                    dSTU4145BinaryField = new DSTU4145BinaryField(n, n2, n3, n4);
                    this.f = dSTU4145BinaryField4;
                }
                DSTU4145ECBinary dSTU4145ECBinary = this;
                dSTU4145ECBinary.a = new ASN1Integer(eCCurve.getA().toBigInteger());
                dSTU4145ECBinary.b = new DEROctetString(eCCurve.getB().getEncoded());
                dSTU4145ECBinary.n = new ASN1Integer(eCDomainParameters.getN());
                dSTU4145ECBinary.bp = new DEROctetString(DSTU4145PointEncoder.encodePoint(eCDomainParameters.getG()));
                return;
            }
            throw new IllegalArgumentException("curve must have a trinomial or pentanomial basis");
        }
        throw new IllegalArgumentException("only binary domain is possible");
    }

    private DSTU4145ECBinary(ASN1Sequence aSN1Sequence) {
        this.version = BigInteger.valueOf(0L);
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n);
            if (aSN1TaggedObject.isExplicit() && aSN1TaggedObject.getTagNo() == 0) {
                this.version = ASN1Integer.getInstance(aSN1TaggedObject.getLoadedObject()).getValue();
                n = 1;
            } else {
                throw new IllegalArgumentException("object parse error");
            }
        }
        this.f = DSTU4145BinaryField.getInstance(aSN1Sequence.getObjectAt(n));
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(++n));
        this.b = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(++n));
        this.n = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(++n));
        this.bp = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n + 1));
    }

    public static DSTU4145ECBinary getInstance(Object object) {
        if (object instanceof DSTU4145ECBinary) {
            return (DSTU4145ECBinary)object;
        }
        if (object != null) {
            return new DSTU4145ECBinary(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DSTU4145BinaryField getField() {
        return this.f;
    }

    public BigInteger getA() {
        return this.a.getValue();
    }

    public byte[] getB() {
        return Arrays.clone(this.b.getOctets());
    }

    public BigInteger getN() {
        return this.n.getValue();
    }

    public byte[] getG() {
        return Arrays.clone(this.bp.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(6);
        if (this.version.compareTo(BigInteger.valueOf(0L)) != 0) {
            ASN1Integer aSN1Integer;
            ASN1Integer aSN1Integer2 = aSN1Integer;
            aSN1Integer = new ASN1Integer(this.version);
            aSN1EncodableVector2.add(new DERTaggedObject(true, 0, aSN1Integer2));
        }
        aSN1EncodableVector2.add(this.f);
        aSN1EncodableVector2.add(this.a);
        aSN1EncodableVector2.add(this.b);
        aSN1EncodableVector2.add(this.n);
        aSN1EncodableVector2.add(this.bp);
        return new DERSequence(aSN1EncodableVector2);
    }
}

