/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.util.Random;

public abstract class DSTU4145PointEncoder {
    private static ECFieldElement trace(ECFieldElement eCFieldElement) {
        ECFieldElement eCFieldElement2 = eCFieldElement;
        for (int k = 1; k < eCFieldElement.getFieldSize(); ++k) {
            eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement);
        }
        return eCFieldElement2;
    }

    private static ECFieldElement solveQuadraticEquation(ECCurve eCCurve, ECFieldElement eCFieldElement) {
        ECFieldElement eCFieldElement2;
        Random random;
        if (eCFieldElement.isZero()) {
            return eCFieldElement;
        }
        ECFieldElement eCFieldElement3 = eCCurve.fromBigInteger(ECConstants.ZERO);
        Random random2 = random;
        random = new Random();
        int n = eCFieldElement.getFieldSize();
        do {
            BigInteger bigInteger;
            Object object = bigInteger;
            bigInteger = new BigInteger(n, random2);
            object = eCCurve.fromBigInteger((BigInteger)object);
            eCFieldElement2 = eCFieldElement3;
            ECFieldElement eCFieldElement4 = eCFieldElement;
            for (int k = 1; k <= n - 1; ++k) {
                ECFieldElement eCFieldElement5 = eCFieldElement4.square();
                eCFieldElement4 = eCFieldElement5;
                eCFieldElement4 = eCFieldElement2.square().add(eCFieldElement4.multiply((ECFieldElement)object));
                eCFieldElement2 = eCFieldElement5.add(eCFieldElement);
                ECFieldElement eCFieldElement6 = eCFieldElement2;
                eCFieldElement2 = eCFieldElement4;
                eCFieldElement4 = eCFieldElement6;
            }
            if (eCFieldElement4.isZero()) continue;
            return null;
        } while (eCFieldElement2.square().add(eCFieldElement2).isZero());
        return eCFieldElement2;
    }

    public static byte[] encodePoint(ECPoint eCPoint) {
        eCPoint = eCPoint.normalize();
        ECFieldElement eCFieldElement = eCPoint.getAffineXCoord();
        byte[] byArray = eCFieldElement.getEncoded();
        if (!eCFieldElement.isZero()) {
            if (DSTU4145PointEncoder.trace(eCPoint.getAffineYCoord().divide(eCFieldElement)).isOne()) {
                int n = byArray.length - 1;
                byArray[n] = (byte)(byArray[n] | 1);
            } else {
                int n = byArray.length - 1;
                byArray[n] = (byte)(byArray[n] & 0xFE);
            }
        }
        return byArray;
    }

    public static ECPoint decodePoint(ECCurve object, byte[] object2) {
        ECCurve eCCurve = object;
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(BigInteger.valueOf(object2[((byte[])object2).length - 1] & 1));
        ECFieldElement eCFieldElement2 = eCCurve.fromBigInteger(new BigInteger(1, (byte[])object2));
        object2 = eCFieldElement2;
        if (!DSTU4145PointEncoder.trace(eCFieldElement2).equals(((ECCurve)object).getA())) {
            object2 = ((ECFieldElement)object2).addOne();
        }
        ECFieldElement eCFieldElement3 = null;
        if (((ECFieldElement)object2).isZero()) {
            eCFieldElement3 = ((ECCurve)object).getB().sqrt();
        } else {
            ECFieldElement eCFieldElement4 = DSTU4145PointEncoder.solveQuadraticEquation((ECCurve)object, ((ECFieldElement)object2).square().invert().multiply(((ECCurve)object).getB()).add(((ECCurve)object).getA()).add((ECFieldElement)object2));
            if (eCFieldElement4 != null) {
                if (!DSTU4145PointEncoder.trace(eCFieldElement4).equals(eCFieldElement)) {
                    eCFieldElement4 = eCFieldElement4.addOne();
                }
                eCFieldElement3 = ((ECFieldElement)object2).multiply(eCFieldElement4);
            }
        }
        if (eCFieldElement3 != null) {
            ECCurve eCCurve2 = object;
            object = ((ECFieldElement)object2).toBigInteger();
            return eCCurve2.validatePoint((BigInteger)object, eCFieldElement3.toBigInteger());
        }
        throw new IllegalArgumentException("Invalid point compression");
    }
}

