/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.RDN;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.BCStyle;
import java.util.Enumeration;

public class X500Name
extends ASN1Object
implements ASN1Choice {
    private static X500NameStyle defaultStyle = BCStyle.INSTANCE;
    private boolean isHashCodeCalculated;
    private int hashCodeValue;
    private X500NameStyle style;
    private RDN[] rdns;
    private DERSequence rdnSeq;

    public X500Name(X500NameStyle x500NameStyle, X500Name x500Name) {
        this.style = x500NameStyle;
        this.rdns = x500Name.rdns;
        this.rdnSeq = x500Name.rdnSeq;
    }

    public static X500Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X500Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
    }

    public static X500Name getInstance(Object object) {
        if (object instanceof X500Name) {
            return (X500Name)object;
        }
        if (object != null) {
            return new X500Name(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static X500Name getInstance(X500NameStyle x500NameStyle, Object object) {
        if (object instanceof X500Name) {
            return new X500Name(x500NameStyle, (X500Name)object);
        }
        if (object != null) {
            return new X500Name(x500NameStyle, ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private X500Name(ASN1Sequence aSN1Sequence) {
        this(defaultStyle, aSN1Sequence);
    }

    private X500Name(X500NameStyle x500NameStyle, ASN1Sequence aSN1Sequence) {
        this.style = x500NameStyle;
        this.rdns = new RDN[aSN1Sequence.size()];
        boolean bl = true;
        int n = 0;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            RDN rDN = RDN.getInstance(e2);
            boolean bl2 = rDN == e2;
            bl &= bl2;
            this.rdns[n++] = rDN;
        }
        this.rdnSeq = bl ? DERSequence.convert(aSN1Sequence) : new DERSequence(this.rdns);
    }

    public X500Name(RDN[] rDNArray) {
        this(defaultStyle, rDNArray);
    }

    public X500Name(X500NameStyle x500NameStyle, RDN[] rDNArray) {
        aSN1EncodableArray.style = x500NameStyle;
        ASN1Encodable[] aSN1EncodableArray = (RDN[])rDNArray.clone();
        aSN1EncodableArray.rdns = aSN1EncodableArray;
        aSN1EncodableArray.rdnSeq = new DERSequence(aSN1EncodableArray);
    }

    public X500Name(String string) {
        this(defaultStyle, string);
    }

    public X500Name(X500NameStyle x500NameStyle, String string) {
        this(x500NameStyle.fromString(string));
        this.style = x500NameStyle;
    }

    public static void setDefaultStyle(X500NameStyle x500NameStyle) {
        if (x500NameStyle != null) {
            defaultStyle = x500NameStyle;
            return;
        }
        throw new NullPointerException("cannot set style to null");
    }

    public static X500NameStyle getDefaultStyle() {
        return defaultStyle;
    }

    public RDN[] getRDNs() {
        return (RDN[])this.rdns.clone();
    }

    public ASN1ObjectIdentifier[] getAttributeTypes() {
        int n;
        int n2 = this.rdns.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 = this.rdns[n].size() + n3;
        }
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[n3];
        n = 0;
        for (int k = 0; k < n2; ++k) {
            n += this.rdns[k].collectAttributeTypes(aSN1ObjectIdentifierArray, n);
        }
        return aSN1ObjectIdentifierArray;
    }

    public RDN[] getRDNs(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        int n = this.rdns.length;
        RDN[] rDNArray = new RDN[n];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            Object object = this.rdns;
            if (n3 == this.rdns.length) break;
            if ((object = object[n3]).containsAttributeType(aSN1ObjectIdentifier)) {
                int n4 = n2 + 1;
                rDNArray[n2] = object;
                n2 = n4;
            }
            ++n3;
        }
        if (n2 < n) {
            RDN[] rDNArray2 = rDNArray;
            rDNArray = new RDN[n2];
            System.arraycopy(rDNArray2, 0, rDNArray, 0, n2);
        }
        return rDNArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.rdnSeq;
    }

    @Override
    public int hashCode() {
        if (this.isHashCodeCalculated) {
            return this.hashCodeValue;
        }
        this.isHashCodeCalculated = true;
        this.hashCodeValue = this.style.calculateHashCode(this);
        return this.hashCodeValue;
    }

    @Override
    public boolean equals(Object object) {
        X500Name x500Name;
        X500Name x500Name2;
        X500NameStyle x500NameStyle;
        if (object == x500Name3) {
            return true;
        }
        if (!(object instanceof X500Name) && !(object instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        if (x500Name3.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            x500NameStyle = x500Name3.style;
            x500Name2 = x500Name3;
        }
        catch (Exception exception) {
            return false;
        }
        X500Name x500Name3 = x500Name;
        x500Name = new X500Name(ASN1Sequence.getInstance(((ASN1Encodable)object).toASN1Primitive()));
        return x500NameStyle.areEqual(x500Name2, x500Name3);
    }

    public String toString() {
        return this.style.toString(this);
    }
}

