/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;

public class CertificatePolicies
extends ASN1Object {
    private final PolicyInformation[] policyInformation;

    private static PolicyInformation[] copy(PolicyInformation[] policyInformationArray) {
        PolicyInformation[] policyInformationArray2 = new PolicyInformation[policyInformationArray.length];
        int n = policyInformationArray.length;
        System.arraycopy(policyInformationArray, 0, policyInformationArray2, 0, n);
        return policyInformationArray2;
    }

    public static CertificatePolicies getInstance(Object object) {
        if (object instanceof CertificatePolicies) {
            return (CertificatePolicies)object;
        }
        if (object != null) {
            return new CertificatePolicies(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static CertificatePolicies getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static CertificatePolicies fromExtensions(Extensions extensions) {
        return CertificatePolicies.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.certificatePolicies));
    }

    public CertificatePolicies(PolicyInformation policyInformation) {
        PolicyInformation[] policyInformationArray = new PolicyInformation[1];
        PolicyInformation[] policyInformationArray2 = policyInformationArray;
        policyInformationArray[0] = policyInformation;
        policyInformationArray2.policyInformation = policyInformationArray2;
    }

    public CertificatePolicies(PolicyInformation[] policyInformationArray) {
        this.policyInformation = CertificatePolicies.copy(policyInformationArray);
    }

    private CertificatePolicies(ASN1Sequence aSN1Sequence) {
        this.policyInformation = new PolicyInformation[aSN1Sequence.size()];
        for (int k = 0; k != aSN1Sequence.size(); ++k) {
            this.policyInformation[k] = PolicyInformation.getInstance(aSN1Sequence.getObjectAt(k));
        }
    }

    public PolicyInformation[] getPolicyInformation() {
        return CertificatePolicies.copy(this.policyInformation);
    }

    public PolicyInformation getPolicyInformation(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        int n = 0;
        while (true) {
            PolicyInformation[] policyInformationArray = this.policyInformation;
            if (n == this.policyInformation.length) break;
            if (aSN1ObjectIdentifier.equals(policyInformationArray[n].getPolicyIdentifier())) {
                return this.policyInformation[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.policyInformation);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int k = 0; k < this.policyInformation.length; ++k) {
            if (stringBuffer2.length() != 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append(this.policyInformation[k]);
        }
        return "CertificatePolicies: [" + stringBuffer2 + "]";
    }
}

