/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class GeneralNames
extends ASN1Object {
    private final GeneralName[] names;

    private static GeneralName[] copy(GeneralName[] generalNameArray) {
        GeneralName[] generalNameArray2 = new GeneralName[generalNameArray.length];
        int n = generalNameArray.length;
        System.arraycopy(generalNameArray, 0, generalNameArray2, 0, n);
        return generalNameArray2;
    }

    public static GeneralNames getInstance(Object object) {
        if (object instanceof GeneralNames) {
            return (GeneralNames)object;
        }
        if (object != null) {
            return new GeneralNames(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static GeneralNames getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new GeneralNames(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static GeneralNames fromExtensions(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return GeneralNames.getInstance(Extensions.getExtensionParsedValue(extensions, aSN1ObjectIdentifier));
    }

    public GeneralNames(GeneralName generalName) {
        GeneralName[] generalNameArray = new GeneralName[1];
        GeneralName[] generalNameArray2 = generalNameArray;
        generalNameArray[0] = generalName;
        generalNameArray2.names = generalNameArray2;
    }

    public GeneralNames(GeneralName[] generalNameArray) {
        this.names = GeneralNames.copy(generalNameArray);
    }

    private GeneralNames(ASN1Sequence aSN1Sequence) {
        this.names = new GeneralName[aSN1Sequence.size()];
        for (int k = 0; k != aSN1Sequence.size(); ++k) {
            this.names[k] = GeneralName.getInstance(aSN1Sequence.getObjectAt(k));
        }
    }

    public GeneralName[] getNames() {
        return GeneralNames.copy(this.names);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.names);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        String string = Strings.lineSeparator();
        new StringBuffer().append("GeneralNames:");
        stringBuffer2.append(string);
        for (int k = 0; k != this.names.length; ++k) {
            stringBuffer2.append("    ");
            stringBuffer2.append(this.names[k]);
            stringBuffer2.append(string);
        }
        return stringBuffer2.toString();
    }
}

