/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;

public class KeyUsage
extends ASN1Object {
    public static final int digitalSignature = 128;
    public static final int nonRepudiation = 64;
    public static final int keyEncipherment = 32;
    public static final int dataEncipherment = 16;
    public static final int keyAgreement = 8;
    public static final int keyCertSign = 4;
    public static final int cRLSign = 2;
    public static final int encipherOnly = 1;
    public static final int decipherOnly = 32768;
    private DERBitString bitString;

    public static KeyUsage getInstance(Object object) {
        if (object instanceof KeyUsage) {
            return (KeyUsage)object;
        }
        if (object != null) {
            return new KeyUsage(DERBitString.getInstance(object));
        }
        return null;
    }

    public static KeyUsage fromExtensions(Extensions extensions) {
        return KeyUsage.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.keyUsage));
    }

    public KeyUsage(int n) {
        DERBitString dERBitString;
        ASN1Object aSN1Object = dERBitString;
        dERBitString = new DERBitString(n);
        v1.bitString = aSN1Object;
    }

    private KeyUsage(DERBitString dERBitString) {
        this.bitString = dERBitString;
    }

    public boolean hasUsages(int n) {
        return (this.bitString.intValue() & n) == n;
    }

    public byte[] getBytes() {
        return this.bitString.getBytes();
    }

    public int getPadBits() {
        return this.bitString.getPadBits();
    }

    public String toString() {
        byte[] byArray = ((KeyUsage)object).bitString.getBytes();
        Object object = byArray;
        if (byArray.length == 1) {
            Object object2 = object;
            object = b.a("KeyUsage: 0x");
            return h.a(object2[0] & 0xFF, (StringBuilder)object);
        }
        StringBuilder stringBuilder = b.a("KeyUsage: 0x");
        return h.a((object[1] & 0xFF) << 8 | object[0] & 0xFF, stringBuilder);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.bitString;
    }
}

