/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Enumerated;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ObjectDigestInfo
extends ASN1Object {
    public static final int publicKey = 0;
    public static final int publicKeyCert = 1;
    public static final int otherObjectDigest = 2;
    public ASN1Enumerated digestedObjectType;
    public ASN1ObjectIdentifier otherObjectTypeID;
    public AlgorithmIdentifier digestAlgorithm;
    public DERBitString objectDigest;

    public static ObjectDigestInfo getInstance(Object object) {
        if (object instanceof ObjectDigestInfo) {
            return (ObjectDigestInfo)object;
        }
        if (object != null) {
            return new ObjectDigestInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static ObjectDigestInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ObjectDigestInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public ObjectDigestInfo(int n, ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        DERBitString dERBitString;
        ASN1Enumerated aSN1Enumerated;
        ASN1Enumerated aSN1Enumerated2 = aSN1Enumerated;
        aSN1Enumerated = new ASN1Enumerated(n);
        aSN1Object.digestedObjectType = aSN1Enumerated2;
        if (n == 2) {
            aSN1Object.otherObjectTypeID = aSN1ObjectIdentifier;
        }
        ObjectDigestInfo objectDigestInfo = aSN1Object;
        objectDigestInfo.digestAlgorithm = algorithmIdentifier;
        ASN1Object aSN1Object = dERBitString;
        dERBitString = new DERBitString(byArray);
        objectDigestInfo.objectDigest = aSN1Object;
    }

    private ObjectDigestInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() <= 4 && aSN1Sequence.size() >= 3) {
            this.digestedObjectType = ASN1Enumerated.getInstance(aSN1Sequence.getObjectAt(0));
            int n = 0;
            if (aSN1Sequence.size() == 4) {
                this.otherObjectTypeID = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
                n = 1;
            }
            this.digestAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n + 1));
            this.objectDigest = DERBitString.getInstance(aSN1Sequence.getObjectAt(n + 2));
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public ASN1Enumerated getDigestedObjectType() {
        return this.digestedObjectType;
    }

    public ASN1ObjectIdentifier getOtherObjectTypeID() {
        return this.otherObjectTypeID;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public DERBitString getObjectDigest() {
        return this.objectDigest;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector.add(this.digestedObjectType);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.otherObjectTypeID;
        if (aSN1ObjectIdentifier != null) {
            aSN1EncodableVector2.add(aSN1ObjectIdentifier);
        }
        aSN1EncodableVector2.add(this.digestAlgorithm);
        aSN1EncodableVector2.add(this.objectDigest);
        return new DERSequence(aSN1EncodableVector2);
    }
}

