/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9Curve;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9FieldID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.PolynomialExtensionField;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class X9ECParameters
extends ASN1Object
implements X9ObjectIdentifiers {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private X9FieldID fieldID;
    private ECCurve curve;
    private X9ECPoint g;
    private BigInteger n;
    private BigInteger h;
    private byte[] seed;

    private X9ECParameters(ASN1Sequence object) {
        if (((ASN1Sequence)object).getObjectAt(0) instanceof ASN1Integer && ((ASN1Integer)((ASN1Sequence)object).getObjectAt(0)).hasValue(ONE)) {
            X9Curve x9Curve;
            this.n = ((ASN1Integer)((ASN1Sequence)object).getObjectAt(4)).getValue();
            if (((ASN1Sequence)object).size() == 6) {
                this.h = ((ASN1Integer)((ASN1Sequence)object).getObjectAt(5)).getValue();
            }
            ASN1Sequence aSN1Sequence = object;
            X9Curve x9Curve2 = x9Curve;
            ASN1Sequence aSN1Sequence2 = object;
            X9ECParameters x9ECParameters = this;
            object = X9FieldID.getInstance(((ASN1Sequence)object).getObjectAt(1));
            Object object2 = x9ECParameters.n;
            BigInteger bigInteger = x9ECParameters.h;
            ASN1Sequence aSN1Sequence3 = ASN1Sequence.getInstance(aSN1Sequence2.getObjectAt(2));
            this.curve = new X9Curve((X9FieldID)object, (BigInteger)object2, bigInteger, aSN1Sequence3).getCurve();
            object = aSN1Sequence.getObjectAt(3);
            if (object instanceof X9ECPoint) {
                this.g = (X9ECPoint)object;
            } else {
                X9ECPoint x9ECPoint;
                object2 = x9ECPoint;
                ASN1Encodable aSN1Encodable = object;
                object = this.curve;
                x9ECPoint = new X9ECPoint((ECCurve)object, (ASN1OctetString)aSN1Encodable);
                this.g = object2;
            }
            this.seed = x9Curve2.getSeed();
            return;
        }
        throw new IllegalArgumentException("bad version in X9ECParameters");
    }

    public static X9ECParameters getInstance(Object object) {
        if (object instanceof X9ECParameters) {
            return (X9ECParameters)object;
        }
        if (object != null) {
            return new X9ECParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X9ECParameters(ECCurve eCCurve, X9ECPoint x9ECPoint, BigInteger bigInteger) {
        this(eCCurve, x9ECPoint, bigInteger, null, null);
    }

    public X9ECParameters(ECCurve eCCurve, X9ECPoint x9ECPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, x9ECPoint, bigInteger, bigInteger2, null);
    }

    public X9ECParameters(ECCurve object, X9ECPoint x9ECPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        block4: {
            block6: {
                block3: {
                    X9FieldID x9FieldID;
                    ASN1Object aSN1Object;
                    block5: {
                        X9FieldID x9FieldID2;
                        block2: {
                            aSN1Object.curve = object;
                            aSN1Object.g = x9ECPoint;
                            aSN1Object.n = bigInteger;
                            aSN1Object.h = bigInteger2;
                            aSN1Object.seed = Arrays.clone(byArray);
                            if (!ECAlgorithms.isFpCurve((ECCurve)object)) break block2;
                            aSN1Object.fieldID = new X9FieldID(((ECCurve)object).getField().getCharacteristic());
                            break block3;
                        }
                        if (!ECAlgorithms.isF2mCurve((ECCurve)object)) break block4;
                        int[] nArray = ((PolynomialExtensionField)((ECCurve)object).getField()).getMinimalPolynomial().getExponentsPresent();
                        object = nArray;
                        if (nArray.length != 3) break block5;
                        X9ECParameters x9ECParameters = aSN1Object;
                        aSN1Object = x9FieldID2;
                        Object object2 = object;
                        Object object3 = object2[2];
                        x9FieldID2 = new X9FieldID((int)object3, (int)object2[1]);
                        x9ECParameters.fieldID = aSN1Object;
                        break block3;
                    }
                    if (((Object)object).length != 5) break block6;
                    ASN1Object aSN1Object2 = aSN1Object;
                    aSN1Object = x9FieldID;
                    Object object4 = object;
                    Object object5 = object4[4];
                    Object object6 = object4[1];
                    Object object7 = object4[2];
                    Object object8 = object4[3];
                    x9FieldID = new X9FieldID((int)object5, (int)object6, (int)object7, (int)object8);
                    aSN1Object2.fieldID = aSN1Object;
                }
                return;
            }
            throw new IllegalArgumentException("Only trinomial and pentomial curves are supported");
        }
        throw new IllegalArgumentException("'curve' is of an unsupported type");
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.g.getPoint();
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public boolean hasSeed() {
        return this.seed != null;
    }

    public X9Curve getCurveEntry() {
        X9ECParameters x9ECParameters = eCCurve;
        ECCurve eCCurve = x9ECParameters.curve;
        return new X9Curve(eCCurve, x9ECParameters.seed);
    }

    public X9FieldID getFieldIDEntry() {
        return this.fieldID;
    }

    public X9ECPoint getBaseEntry() {
        return this.g;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector2;
        aSN1EncodableVector4(6);
        aSN1EncodableVector4.add(new ASN1Integer(ONE));
        aSN1EncodableVector3.add(((X9ECParameters)((Object)bigInteger)).fieldID);
        X9ECParameters x9ECParameters = bigInteger;
        Object object = x9ECParameters.curve;
        aSN1EncodableVector3.add(new X9Curve((ECCurve)object, x9ECParameters.seed));
        aSN1EncodableVector.add(((X9ECParameters)((Object)bigInteger)).g);
        aSN1EncodableVector.add(new ASN1Integer(((X9ECParameters)((Object)bigInteger)).n));
        BigInteger bigInteger = ((X9ECParameters)((Object)bigInteger)).h;
        if (bigInteger != null) {
            ASN1Integer aSN1Integer;
            object = aSN1Integer;
            aSN1Integer = new ASN1Integer(bigInteger);
            aSN1EncodableVector2.add((ASN1Encodable)object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

