/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;

public class BufferedBlockCipher {
    public byte[] buf;
    public int bufOff;
    public boolean forEncryption;
    public BlockCipher cipher;
    public boolean partialBlockOkay;
    public boolean pgpCFB;

    public BufferedBlockCipher() {
    }

    public BufferedBlockCipher(BlockCipher blockCipher) {
        BufferedBlockCipher bufferedBlockCipher = this;
        this.cipher = blockCipher;
        bufferedBlockCipher.buf = new byte[blockCipher.getBlockSize()];
        bufferedBlockCipher.bufOff = 0;
        String string = blockCipher.getAlgorithmName();
        int n = string.indexOf(47) + 1;
        boolean bl = n > 0 && string.startsWith("PGP", n);
        this.pgpCFB = bl;
        if (!bl && !(blockCipher instanceof StreamCipher)) {
            boolean bl2 = n > 0 && string.startsWith("OpenPGP", n);
            this.partialBlockOkay = bl2;
        } else {
            this.partialBlockOkay = true;
        }
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        BufferedBlockCipher bufferedBlockCipher = this;
        bufferedBlockCipher.forEncryption = bl;
        bufferedBlockCipher.reset();
        bufferedBlockCipher.cipher.init(bl, cipherParameters);
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int getUpdateOutputSize(int n) {
        int n2 = this.pgpCFB ? (this.forEncryption ? n % this.buf.length - (this.cipher.getBlockSize() + 2) : n % this.buf.length) : (n += this.bufOff) % this.buf.length;
        return n - n2;
    }

    public int getOutputSize(int n) {
        return n + this.bufOff;
    }

    public int processByte(byte by, byte[] byArray, int n) {
        int n2;
        BufferedBlockCipher bufferedBlockCipher = this;
        int n3 = 0;
        byte[] byArray2 = bufferedBlockCipher.buf;
        int n4 = bufferedBlockCipher.bufOff;
        this.bufOff = n2 = n4 + 1;
        byArray2[n4] = by;
        if (n2 == byArray2.length) {
            n3 = this.cipher.processBlock(byArray2, 0, byArray, n);
            this.bufOff = 0;
        }
        return n3;
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 >= 0) {
            BufferedBlockCipher bufferedBlockCipher = this;
            int n4 = bufferedBlockCipher.getBlockSize();
            int n5 = bufferedBlockCipher.getUpdateOutputSize(n2);
            if (n5 > 0 && n3 + n5 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            n5 = 0;
            byte[] byArray3 = this.buf;
            int n6 = this.bufOff;
            int n7 = this.buf.length - n6;
            if (n2 > n7) {
                int n8 = n;
                System.arraycopy(byArray, n, byArray3, n6, n7);
                n = this.cipher.processBlock(this.buf, 0, byArray2, n3) + n5;
                this.bufOff = 0;
                n2 -= n7;
                int n9 = n5 = n8 + n7;
                n5 = n;
                n = n9;
                while (n2 > this.buf.length) {
                    int n10 = n;
                    int n11 = n2;
                    n2 = n3 + n5;
                    n = this.cipher.processBlock(byArray, n, byArray2, n2) + n5;
                    n2 = n11 - n4;
                    int n12 = n5 = n10 + n4;
                    n5 = n;
                    n = n12;
                }
            }
            byte[] byArray4 = byArray;
            BufferedBlockCipher bufferedBlockCipher2 = this;
            byArray = bufferedBlockCipher2.buf;
            System.arraycopy(byArray4, n, byArray, bufferedBlockCipher2.bufOff, n2);
            int n13 = this.bufOff + n2;
            BufferedBlockCipher bufferedBlockCipher3 = this;
            bufferedBlockCipher3.bufOff = n13;
            byte[] byArray5 = bufferedBlockCipher3.buf;
            if (n13 == bufferedBlockCipher3.buf.length) {
                int n14 = n3 + n5;
                n5 = this.cipher.processBlock(byArray5, 0, byArray2, n14) + n5;
                this.bufOff = 0;
            }
            return n5;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doFinal(byte[] byArray, int n) {
        block9: {
            int n2;
            block10: {
                int n3;
                n2 = 0;
                try {
                    n3 = this.bufOff;
                }
                catch (Throwable throwable) {
                    this.reset();
                    throw throwable;
                }
                if (n + n3 > byArray.length) break block9;
                if (n3 == 0) break block10;
                if (!this.partialBlockOkay) throw new DataLengthException("data not block size aligned");
                BufferedBlockCipher bufferedBlockCipher = this;
                BufferedBlockCipher bufferedBlockCipher2 = bufferedBlockCipher;
                BufferedBlockCipher bufferedBlockCipher3 = bufferedBlockCipher;
                BufferedBlockCipher bufferedBlockCipher4 = bufferedBlockCipher;
                BlockCipher blockCipher = bufferedBlockCipher.cipher;
                byte[] byArray2 = this.buf;
                blockCipher.processBlock(this.buf, 0, byArray2, 0);
                n2 = bufferedBlockCipher2.bufOff;
                bufferedBlockCipher3.bufOff = 0;
                System.arraycopy(bufferedBlockCipher4.buf, 0, byArray, n, n2);
            }
            this.reset();
            return n2;
        }
        throw new OutputLengthException("output buffer too short for doFinal()");
    }

    public void reset() {
        int n = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n >= this.buf.length) break;
            byArray[n] = 0;
            ++n;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

