/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StagedAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHCStagedAgreement
implements StagedAgreement {
    public ECPrivateKeyParameters key;

    private ECPoint calculateNextPoint(ECPublicKeyParameters object) {
        ECDomainParameters eCDomainParameters = ((ECDHCStagedAgreement)object2).key.getParameters();
        if (eCDomainParameters.equals(((ECKeyParameters)object).getParameters())) {
            ECDomainParameters eCDomainParameters2 = eCDomainParameters;
            Object object2 = eCDomainParameters2.getH().multiply(((ECDHCStagedAgreement)object2).key.getD()).mod(eCDomainParameters.getN());
            object = ECAlgorithms.cleanPoint(eCDomainParameters2.getCurve(), ((ECPublicKeyParameters)object).getQ());
            if (!((ECPoint)object).isInfinity()) {
                if (!((ECPoint)(object2 = ((ECPoint)object).multiply((BigInteger)object2).normalize())).isInfinity()) {
                    return object2;
                }
                throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
            }
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        throw new IllegalStateException("ECDHC public key has wrong domain parameters");
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public AsymmetricKeyParameter calculateStage(CipherParameters object) {
        object = this.calculateNextPoint((ECPublicKeyParameters)object);
        return new ECPublicKeyParameters((ECPoint)object, this.key.getParameters());
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        return this.calculateNextPoint((ECPublicKeyParameters)cipherParameters).getAffineXCoord().toBigInteger();
    }
}

