/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SM3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithID;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.SM2KeyExchangePrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.SM2KeyExchangePublicParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public class SM2KeyExchange {
    private final Digest digest;
    private byte[] userID;
    private ECPrivateKeyParameters staticKey;
    private ECPoint staticPubPoint;
    private ECPoint ephemeralPubPoint;
    private ECDomainParameters ecParams;
    private int w;
    private ECPrivateKeyParameters ephemeralKey;
    private boolean initiator;

    public SM2KeyExchange() {
        SM3Digest sM3Digest;
        SM2KeyExchange sM2KeyExchange = sM3Digest2;
        SM3Digest sM3Digest2 = sM3Digest;
        sM3Digest = new SM3Digest();
        sM2KeyExchange(sM3Digest2);
    }

    public SM2KeyExchange(Digest digest) {
        this.digest = digest;
    }

    private ECPoint calculateU(SM2KeyExchangePublicParameters object) {
        Object object2 = this.staticKey.getParameters();
        ECPoint eCPoint = ECAlgorithms.cleanPoint(((ECDomainParameters)object2).getCurve(), ((SM2KeyExchangePublicParameters)object).getStaticPublicKey().getQ());
        SM2KeyExchange sM2KeyExchange = this;
        object = ECAlgorithms.cleanPoint(((ECDomainParameters)object2).getCurve(), ((SM2KeyExchangePublicParameters)object).getEphemeralPublicKey().getQ());
        object2 = sM2KeyExchange.reduce(sM2KeyExchange.ephemeralPubPoint.getAffineXCoord().toBigInteger());
        BigInteger bigInteger = sM2KeyExchange.reduce(((ECPoint)object).getAffineXCoord().toBigInteger());
        object2 = sM2KeyExchange.staticKey.getD().add(((BigInteger)object2).multiply(this.ephemeralKey.getD()));
        BigInteger bigInteger2 = sM2KeyExchange.ecParams.getH().multiply((BigInteger)object2).mod(this.ecParams.getN());
        return ECAlgorithms.sumOfTwoMultiplies(eCPoint, bigInteger2, (ECPoint)object, bigInteger2.multiply(bigInteger).mod(this.ecParams.getN())).normalize();
    }

    private byte[] kdf(ECPoint eCPoint, byte[] byArray, byte[] byArray2, int n) {
        int n2 = n;
        n = this.digest.getDigestSize();
        byte[] byArray3 = new byte[Math.max(4, n)];
        int n3 = (n2 + 7) / 8;
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        Object object = null;
        Memoable memoable = null;
        Digest digest = this.digest;
        if (digest instanceof Memoable) {
            SM2KeyExchange sM2KeyExchange = this;
            SM2KeyExchange sM2KeyExchange2 = this;
            sM2KeyExchange2.addFieldElement(digest, eCPoint.getAffineXCoord());
            object = sM2KeyExchange2.digest;
            sM2KeyExchange.addFieldElement((Digest)object, eCPoint.getAffineYCoord());
            sM2KeyExchange.digest.update(byArray, 0, byArray.length);
            sM2KeyExchange.digest.update(byArray2, 0, byArray2.length);
            object = (Memoable)((Object)sM2KeyExchange.digest);
            memoable = object.copy();
        }
        int n5 = 0;
        while (n4 < n3) {
            if (object != null) {
                object.reset(memoable);
            } else {
                SM2KeyExchange sM2KeyExchange = this;
                SM2KeyExchange sM2KeyExchange3 = this;
                Digest digest2 = this.digest;
                sM2KeyExchange3.addFieldElement(digest2, eCPoint.getAffineXCoord());
                digest2 = sM2KeyExchange3.digest;
                sM2KeyExchange.addFieldElement(digest2, eCPoint.getAffineYCoord());
                sM2KeyExchange.digest.update(byArray, 0, byArray.length);
                sM2KeyExchange.digest.update(byArray2, 0, byArray2.length);
            }
            SM2KeyExchange sM2KeyExchange = this;
            Pack.intToBigEndian(++n5, byArray3, 0);
            sM2KeyExchange.digest.update(byArray3, 0, 4);
            sM2KeyExchange.digest.doFinal(byArray3, 0);
            int n6 = Math.min(n, n3 - n4);
            System.arraycopy(byArray3, 0, byArray4, n4, n6);
            n4 += n6;
        }
        return byArray4;
    }

    private BigInteger reduce(BigInteger bigInteger) {
        return bigInteger.and(BigInteger.valueOf(1L).shiftLeft(this.w).subtract(BigInteger.valueOf(1L))).setBit(this.w);
    }

    private byte[] S1(Digest digest, ECPoint eCPoint, byte[] byArray) {
        digest.update((byte)2);
        this.addFieldElement(digest, eCPoint.getAffineYCoord());
        digest.update(byArray, 0, byArray.length);
        return this.digestDoFinal();
    }

    private byte[] calculateInnerHash(Digest digest, ECPoint eCPoint, byte[] byArray, byte[] byArray2, ECPoint eCPoint2, ECPoint eCPoint3) {
        SM2KeyExchange sM2KeyExchange = this;
        this.addFieldElement(digest, eCPoint.getAffineXCoord());
        digest.update(byArray, 0, byArray.length);
        digest.update(byArray2, 0, byArray2.length);
        this.addFieldElement(digest, eCPoint2.getAffineXCoord());
        this.addFieldElement(digest, eCPoint2.getAffineYCoord());
        this.addFieldElement(digest, eCPoint3.getAffineXCoord());
        sM2KeyExchange.addFieldElement(digest, eCPoint3.getAffineYCoord());
        return sM2KeyExchange.digestDoFinal();
    }

    private byte[] S2(Digest digest, ECPoint eCPoint, byte[] byArray) {
        digest.update((byte)3);
        this.addFieldElement(digest, eCPoint.getAffineYCoord());
        digest.update(byArray, 0, byArray.length);
        return this.digestDoFinal();
    }

    private byte[] getZ(Digest digest, byte[] byArray, ECPoint eCPoint) {
        SM2KeyExchange sM2KeyExchange = this;
        SM2KeyExchange sM2KeyExchange2 = this;
        SM2KeyExchange sM2KeyExchange3 = this;
        SM2KeyExchange sM2KeyExchange4 = this;
        SM2KeyExchange sM2KeyExchange5 = this;
        sM2KeyExchange5.addUserID(digest, byArray);
        sM2KeyExchange4.addFieldElement(digest, sM2KeyExchange5.ecParams.getCurve().getA());
        sM2KeyExchange3.addFieldElement(digest, sM2KeyExchange4.ecParams.getCurve().getB());
        sM2KeyExchange2.addFieldElement(digest, sM2KeyExchange3.ecParams.getG().getAffineXCoord());
        this.addFieldElement(digest, sM2KeyExchange2.ecParams.getG().getAffineYCoord());
        this.addFieldElement(digest, eCPoint.getAffineXCoord());
        sM2KeyExchange.addFieldElement(digest, eCPoint.getAffineYCoord());
        return sM2KeyExchange.digestDoFinal();
    }

    private void addUserID(Digest digest, byte[] byArray) {
        Digest digest2 = digest;
        int n = byArray.length * 8;
        digest2.update((byte)(n >>> 8));
        digest2.update((byte)n);
        digest.update(byArray, 0, byArray.length);
    }

    private void addFieldElement(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        Object object = byArray;
        int n = byArray.length;
        digest.update((byte[])object, 0, n);
    }

    private byte[] digestDoFinal() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithID) {
            ParametersWithID parametersWithID = (ParametersWithID)cipherParameters;
            cipherParameters = (SM2KeyExchangePrivateParameters)parametersWithID.getParameters();
            this.userID = parametersWithID.getID();
        } else {
            cipherParameters = (SM2KeyExchangePrivateParameters)cipherParameters;
            this.userID = new byte[0];
        }
        this.initiator = ((SM2KeyExchangePrivateParameters)cipherParameters).isInitiator();
        this.staticKey = ((SM2KeyExchangePrivateParameters)cipherParameters).getStaticPrivateKey();
        this.ephemeralKey = ((SM2KeyExchangePrivateParameters)cipherParameters).getEphemeralPrivateKey();
        this.ecParams = this.staticKey.getParameters();
        this.staticPubPoint = ((SM2KeyExchangePrivateParameters)cipherParameters).getStaticPublicPoint();
        this.ephemeralPubPoint = ((SM2KeyExchangePrivateParameters)cipherParameters).getEphemeralPublicPoint();
        this.w = this.ecParams.getCurve().getFieldSize() / 2 - 1;
    }

    public byte[] calculateKey(int n, CipherParameters object) {
        Object object2;
        if (object instanceof ParametersWithID) {
            ParametersWithID parametersWithID = (ParametersWithID)object;
            object = (SM2KeyExchangePublicParameters)parametersWithID.getParameters();
            object2 = parametersWithID.getID();
        } else {
            object = (SM2KeyExchangePublicParameters)object;
            object2 = new byte[]{};
        }
        SM2KeyExchange sM2KeyExchange = this;
        CipherParameters cipherParameters = object;
        SM2KeyExchange sM2KeyExchange2 = this;
        Object object3 = sM2KeyExchange2.digest;
        byte[] byArray = sM2KeyExchange2.userID;
        ECPoint eCPoint = sM2KeyExchange2.staticPubPoint;
        object3 = sM2KeyExchange2.getZ((Digest)object3, byArray, eCPoint);
        object = sM2KeyExchange2.getZ(sM2KeyExchange2.digest, (byte[])object2, ((SM2KeyExchangePublicParameters)object).getStaticPublicKey().getQ());
        object2 = sM2KeyExchange.calculateU((SM2KeyExchangePublicParameters)cipherParameters);
        return sM2KeyExchange.initiator ? this.kdf((ECPoint)object2, (byte[])object3, (byte[])object, n) : this.kdf((ECPoint)object2, (byte[])object, (byte[])object3, n);
    }

    public byte[][] calculateKeyWithConfirmation(int n, byte[] object, CipherParameters object2) {
        byte[] byArray;
        if (object2 instanceof ParametersWithID) {
            ParametersWithID parametersWithID = (ParametersWithID)object2;
            object2 = (SM2KeyExchangePublicParameters)parametersWithID.getParameters();
            byArray = parametersWithID.getID();
        } else {
            object2 = (SM2KeyExchangePublicParameters)object2;
            byArray = new byte[]{};
        }
        if (this.initiator && object == null) {
            throw new IllegalArgumentException("if initiating, confirmationTag must be set");
        }
        SM2KeyExchange sM2KeyExchange = this;
        SM2KeyExchange sM2KeyExchange2 = this;
        Object object3 = sM2KeyExchange2.digest;
        Object object4 = sM2KeyExchange2.userID;
        Object object5 = sM2KeyExchange2.staticPubPoint;
        object3 = sM2KeyExchange2.getZ((Digest)object3, (byte[])object4, (ECPoint)object5);
        byArray = sM2KeyExchange2.getZ(sM2KeyExchange2.digest, byArray, ((SM2KeyExchangePublicParameters)object2).getStaticPublicKey().getQ());
        object4 = sM2KeyExchange.calculateU((SM2KeyExchangePublicParameters)object2);
        if (sM2KeyExchange.initiator) {
            SM2KeyExchange sM2KeyExchange3 = this;
            byte[] byArray2 = sM2KeyExchange3.kdf((ECPoint)object4, (byte[])object3, byArray, n);
            object5 = sM2KeyExchange3.digest;
            ECPoint eCPoint = sM2KeyExchange3.ephemeralPubPoint;
            object2 = ((SM2KeyExchangePublicParameters)object2).getEphemeralPublicKey().getQ();
            if (Arrays.constantTimeAreEqual(sM2KeyExchange3.S1(sM2KeyExchange3.digest, (ECPoint)object4, (byte[])(object2 = (Object)sM2KeyExchange3.calculateInnerHash((Digest)object5, (ECPoint)object4, (byte[])object3, byArray, eCPoint, (ECPoint)object2))), object)) {
                byte[][] byArrayArray = new byte[2][];
                object = byArrayArray;
                SM2KeyExchange sM2KeyExchange4 = this;
                object[0] = (byte)byArray2;
                byArrayArray[1] = sM2KeyExchange4.S2(sM2KeyExchange4.digest, (ECPoint)object4, (byte[])object2);
                return byArrayArray;
            }
            throw new IllegalStateException("confirmation tag mismatch");
        }
        SM2KeyExchange sM2KeyExchange5 = this;
        SM2KeyExchange sM2KeyExchange6 = this;
        byte[] byArray3 = sM2KeyExchange6.kdf((ECPoint)object4, byArray, (byte[])object3, n);
        object = sM2KeyExchange6.digest;
        object2 = ((SM2KeyExchangePublicParameters)object2).getEphemeralPublicKey().getQ();
        object5 = sM2KeyExchange5.ephemeralPubPoint;
        object = sM2KeyExchange5.calculateInnerHash((Digest)object, (ECPoint)object4, byArray, (byte[])object3, (ECPoint)object2, (ECPoint)object5);
        byte[][] byArrayArray = new byte[3][];
        object2 = byArrayArray;
        SM2KeyExchange sM2KeyExchange7 = this;
        SM2KeyExchange sM2KeyExchange8 = this;
        object2[0] = byArray3;
        object2[1] = sM2KeyExchange8.S1(sM2KeyExchange8.digest, (ECPoint)object4, (byte[])object);
        byArrayArray[2] = sM2KeyExchange7.S2(sM2KeyExchange7.digest, (ECPoint)object4, (byte[])object);
        return byArrayArray;
    }
}

