/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.srp;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.srp.SRP6Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.SRP6GroupParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Client {
    public BigInteger N;
    public BigInteger g;
    public BigInteger a;
    public BigInteger A;
    public BigInteger B;
    public BigInteger x;
    public BigInteger u;
    public BigInteger S;
    public BigInteger M1;
    public BigInteger M2;
    public BigInteger Key;
    public Digest digest;
    public SecureRandom random;

    private BigInteger calculateS() {
        SRP6Client sRP6Client = this;
        SRP6Client sRP6Client2 = this;
        BigInteger bigInteger = sRP6Client2.N;
        bigInteger = SRP6Util.calculateK(sRP6Client.digest, bigInteger, sRP6Client2.g);
        BigInteger bigInteger2 = sRP6Client.u.multiply(this.x).add(this.a);
        SRP6Client sRP6Client3 = this;
        BigInteger bigInteger3 = sRP6Client3.x;
        bigInteger = sRP6Client.g.modPow(bigInteger3, sRP6Client3.N).multiply(bigInteger).mod(this.N);
        return sRP6Client.B.subtract(bigInteger).mod(this.N).modPow(bigInteger2, this.N);
    }

    public void init(BigInteger bigInteger, BigInteger bigInteger2, Digest digest, SecureRandom secureRandom) {
        SRP6Client sRP6Client = this;
        sRP6Client.N = bigInteger;
        sRP6Client.g = bigInteger2;
        sRP6Client.digest = digest;
        sRP6Client.random = secureRandom;
    }

    public void init(SRP6GroupParameters sRP6GroupParameters, Digest digest, SecureRandom secureRandom) {
        SRP6Client sRP6Client = bigInteger;
        SRP6GroupParameters sRP6GroupParameters2 = sRP6GroupParameters;
        BigInteger bigInteger = sRP6GroupParameters2.getN();
        sRP6Client.init(bigInteger, sRP6GroupParameters2.getG(), digest, secureRandom);
    }

    public BigInteger generateClientCredentials(byte[] object, byte[] byArray, byte[] byArray2) {
        SRP6Client sRP6Client = this;
        sRP6Client.x = SRP6Util.calculateX(sRP6Client.digest, this.N, object, byArray, byArray2);
        BigInteger bigInteger = sRP6Client.selectPrivateValue();
        object = bigInteger;
        sRP6Client.a = bigInteger;
        this.A = sRP6Client.g.modPow((BigInteger)object, this.N);
        return this.A;
    }

    public BigInteger calculateSecret(BigInteger bigInteger) {
        SRP6Client sRP6Client = this;
        sRP6Client.B = bigInteger = SRP6Util.validatePublicValue(sRP6Client.N, bigInteger);
        SRP6Client sRP6Client2 = this;
        BigInteger bigInteger2 = sRP6Client2.N;
        sRP6Client.u = SRP6Util.calculateU(sRP6Client.digest, bigInteger2, sRP6Client2.A, bigInteger);
        this.S = sRP6Client.calculateS();
        return this.S;
    }

    public BigInteger selectPrivateValue() {
        SRP6Client sRP6Client = bigInteger;
        BigInteger bigInteger = sRP6Client.N;
        BigInteger bigInteger2 = sRP6Client.g;
        SecureRandom secureRandom = sRP6Client.random;
        return SRP6Util.generatePrivateValue(((SRP6Client)((Object)bigInteger)).digest, bigInteger, bigInteger2, secureRandom);
    }

    public BigInteger calculateClientEvidenceMessage() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = this.A;
        if (bigInteger3 != null && (bigInteger2 = this.B) != null && (bigInteger = this.S) != null) {
            this.M1 = SRP6Util.calculateM1(this.digest, this.N, bigInteger3, bigInteger2, bigInteger);
            return this.M1;
        }
        throw new CryptoException("Impossible to compute M1: some data are missing from the previous operations (A,B,S)");
    }

    public boolean verifyServerEvidenceMessage(BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4 = this.A;
        if (bigInteger4 != null && (bigInteger3 = this.M1) != null && (bigInteger2 = this.S) != null) {
            if (SRP6Util.calculateM2(this.digest, this.N, bigInteger4, bigInteger3, bigInteger2).equals(bigInteger)) {
                this.M2 = bigInteger;
                return true;
            }
            return false;
        }
        throw new CryptoException("Impossible to compute and verify M2: some data are missing from the previous operations (A,M1,S)");
    }

    public BigInteger calculateSessionKey() {
        BigInteger bigInteger = this.S;
        if (bigInteger != null && this.M1 != null && this.M2 != null) {
            this.Key = SRP6Util.calculateKey(this.digest, this.N, bigInteger);
            return this.Key;
        }
        throw new CryptoException("Impossible to compute Key: some data are missing from the previous operations (S,M1,M2)");
    }
}

