/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public abstract class GeneralDigest
implements ExtendedDigest,
Memoable {
    private static final int BYTE_LENGTH = 64;
    private final byte[] xBuf;
    private int xBufOff;
    private long byteCount;

    public GeneralDigest() {
        this.xBuf = new byte[4];
        this.xBufOff = 0;
    }

    public GeneralDigest(GeneralDigest generalDigest) {
        this.xBuf = new byte[4];
        this.copyIn(generalDigest);
    }

    public GeneralDigest(byte[] byArray) {
        byte[] byArray2 = byArray;
        byArray = new byte[4];
        this.xBuf = byArray;
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray, 0, n);
        this.xBufOff = Pack.bigEndianToInt(byArray, 4);
        this.byteCount = Pack.bigEndianToLong(byArray2, 8);
    }

    public void copyIn(GeneralDigest generalDigest) {
        GeneralDigest generalDigest2 = object;
        GeneralDigest generalDigest3 = object;
        GeneralDigest generalDigest4 = generalDigest;
        Object object = ((GeneralDigest)object).xBuf;
        int n = generalDigest4.xBuf.length;
        System.arraycopy(generalDigest4.xBuf, 0, object, 0, n);
        generalDigest3.xBufOff = generalDigest4.xBufOff;
        generalDigest2.byteCount = generalDigest.byteCount;
    }

    @Override
    public void update(byte by) {
        int n;
        GeneralDigest generalDigest = this;
        byte[] byArray = generalDigest.xBuf;
        int n2 = generalDigest.xBufOff;
        this.xBufOff = n = n2 + 1;
        byArray[n2] = by;
        if (n == byArray.length) {
            this.processWord(byArray, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        n2 = Math.max(0, n2);
        int n3 = 0;
        if (this.xBufOff != 0) {
            while (n3 < n2) {
                GeneralDigest generalDigest = this;
                byte[] byArray2 = generalDigest.xBuf;
                int n4 = generalDigest.xBufOff;
                int n5 = n4 + 1;
                this.xBufOff = n5;
                byArray2[n4] = byArray[n + n3++];
                if (n5 != 4) continue;
                this.processWord(byArray2, 0);
                this.xBufOff = 0;
                break;
            }
        }
        int n6 = (n2 - n3 & 0xFFFFFFFC) + n3;
        while (n3 < n6) {
            this.processWord(byArray, n + n3);
            n3 += 4;
        }
        while (n3 < n2) {
            n6 = this.xBufOff;
            this.xBufOff = n6 + 1;
            this.xBuf[n6] = byArray[n + n3++];
        }
        this.byteCount += (long)n2;
    }

    public void finish() {
        GeneralDigest generalDigest = this;
        long l = generalDigest.byteCount << 3;
        generalDigest.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        GeneralDigest generalDigest2 = this;
        generalDigest2.processLength(l);
        generalDigest2.processBlock();
    }

    @Override
    public void reset() {
        GeneralDigest generalDigest = this;
        generalDigest.byteCount = 0L;
        generalDigest.xBufOff = 0;
        int n = 0;
        while (true) {
            byte[] byArray = this.xBuf;
            if (n >= this.xBuf.length) break;
            byArray[n] = 0;
            ++n;
        }
    }

    public void populateState(byte[] byArray) {
        GeneralDigest generalDigest = this;
        int n = this.xBufOff;
        System.arraycopy(generalDigest.xBuf, 0, byArray, 0, n);
        Pack.intToBigEndian(generalDigest.xBufOff, byArray, 4);
        Pack.longToBigEndian(generalDigest.byteCount, byArray, 8);
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    public abstract void processWord(byte[] var1, int var2);

    public abstract void processLength(long var1);

    public abstract void processBlock();
}

